/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.model;

import de.elster.elsterxml.schema.headerbasis.v3.VerfahrenSType;
import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.model.ElsterXml;
import de.elster.flutopferhilfen.model.KmId;
import de.finkonsens.rms.kmv.base.v6.ObjectFactory;
import de.finkonsens.rms.kmv.base.v6.VerfasserCType;
import de.finkonsens.rms.kmv.storno.v6.AnweisungArtSType;
import de.finkonsens.rms.kmv.storno.v6.AnweisungCType;
import de.finkonsens.rms.kmv.storno.v6.KMStornoCType;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;

public class Storno {
    private final ElsterXml elster;
    private final KMStornoCType storno;

    private static KMStornoCType createKmStorno(String refKmId, String meldejahr, VerfasserCType verfasser) {
        KMStornoCType storno = new KMStornoCType();
        storno.setVersion("6");
        storno.setKmArt("FLH");
        AnweisungCType anweisung = new AnweisungCType();
        anweisung.setArt(AnweisungArtSType.STORNO);
        anweisung.setKmId(KmId.createRandom("2021").toString());
        anweisung.setRefKmId(refKmId);
        storno.setAnweisung(anweisung);
        storno.setVerfasser(verfasser);
        storno.setMeldejahr(meldejahr);
        storno.setEmpfaengerFA("");
        return storno;
    }

    private static KMStornoCType readKmStorno(Element nutzdaten) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance(KMStornoCType.class);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        JAXBElement<KMStornoCType> result = unmarshaller.unmarshal(nutzdaten, KMStornoCType.class);
        return result.getValue();
    }

    public Storno(String refKmId, String meldejahr, VerfasserCType verfasser, NDHEmpfaengerCType empfaenger, Configuration configuration) throws JAXBException {
        this.elster = new ElsterXml(configuration);
        this.elster.setVerfahren(VerfahrenSType.ELSTER_KMV);
        this.elster.setDatenart("FLHMitteilung");
        NDHEmpfaengerCType ndhEmpfaenger = new NDHEmpfaengerCType();
        ndhEmpfaenger.setId(empfaenger.getId());
        ndhEmpfaenger.setValue(empfaenger.getValue());
        this.elster.setEmfaenger(ndhEmpfaenger);
        this.storno = Storno.createKmStorno(refKmId, meldejahr, Storno.cloneVerfasser(verfasser));
    }

    private static VerfasserCType cloneVerfasser(VerfasserCType value) throws JAXBException {
        if (value != null) {
            JAXBContext context = JAXBContext.newInstance(ObjectFactory.class);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Marshaller marshaller = context.createMarshaller();
            StringWriter writer = new StringWriter();
            ObjectFactory factory = new ObjectFactory();
            marshaller.marshal(factory.createVerfasser(value), writer);
            JAXBElement result = (JAXBElement)unmarshaller.unmarshal(new StringReader(writer.toString()));
            return (VerfasserCType)result.getValue();
        }
        return null;
    }

    public Storno(ElsterXml elster) throws JAXBException {
        this.elster = elster;
        this.storno = elster.getNutzdaten() != null ? Storno.readKmStorno(elster.getNutzdaten()) : null;
    }

    public Storno(Path source) throws JAXBException, IOException {
        this(new ElsterXml(source));
    }

    public void save(Path destination) throws IOException, JAXBException {
        Files.writeString(destination, (CharSequence)this.toXml(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public String toXml() throws JAXBException {
        return this.elster.toXml(this.getStornoXml());
    }

    public String getStornoXml() throws JAXBException {
        if (this.storno != null) {
            JAXBContext context = JAXBContext.newInstance(KMStornoCType.class);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
            StringWriter writer = new StringWriter();
            de.finkonsens.rms.kmv.storno.v6.ObjectFactory factory = new de.finkonsens.rms.kmv.storno.v6.ObjectFactory();
            marshaller.marshal(factory.createKMStorno(this.storno), writer);
            return writer.toString();
        }
        return "";
    }

    public ElsterXml getElster() {
        return this.elster;
    }

    public KMStornoCType getStorno() {
        return this.storno;
    }

    public void update(KMStornoCType value) {
        if (value != null) {
            this.storno.setEmpfaengerFA(value.getEmpfaengerFA());
            this.storno.setVerfasser(value.getVerfasser());
        }
    }

    public void updateKmId(String refKmId) {
        if (refKmId != null && refKmId.length() >= 4) {
            AnweisungCType anweisung = this.storno.getAnweisung();
            if (anweisung == null) {
                anweisung = new AnweisungCType();
                this.storno.setAnweisung(anweisung);
            }
            String year = refKmId.substring(0, 4);
            anweisung.setRefKmId(refKmId);
            anweisung.setKmId(KmId.createRandom(year).toString());
        }
    }
}

