/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.model;

import de.elsterfachmethodik.protokollverfahren.version6.xmlschema.NdSFehlerCType;
import de.elsterfachmethodik.protokollverfahren.version6.xmlschema.NutzdatenBlockStatusCType;
import de.elsterfachmethodik.protokollverfahren.version6.xmlschema.ObjectFactory;
import de.elsterfachmethodik.protokollverfahren.version6.xmlschema.ProtokollCType;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class Protokoll {
    private final ProtokollCType protokoll;

    public Protokoll(Path source) throws JAXBException, IOException {
        this(Files.newInputStream(source, new OpenOption[0]));
    }

    public Protokoll(InputStream source) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance(ObjectFactory.class);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        try {
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal(source);
            this.protokoll = (ProtokollCType)element.getValue();
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
    }

    public void save(Path destination) throws JAXBException, IOException {
        Files.writeString(destination, (CharSequence)this.toXml(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public String toXml() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance(ObjectFactory.class);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        StringWriter writer = new StringWriter();
        ObjectFactory factory = new ObjectFactory();
        marshaller.marshal(factory.createProtokoll(this.protokoll), writer);
        return writer.toString();
    }

    public ProtokollCType getProtokoll() {
        return this.protokoll;
    }

    public List<String> getErrors() {
        return this.protokoll.getDatenTeil().getNutzdatenblock().stream().map(NutzdatenBlockStatusCType::getNdSFehler).flatMap(Collection::stream).map(NdSFehlerCType::getFehlerText).collect(Collectors.toList());
    }
}

