/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.model;

import de.elster.elsterxml.schema.headerbasis.v3.VerfahrenSType;
import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.model.ElsterXml;
import de.elster.flutopferhilfen.model.KmId;
import de.finkonsens.rms.kmv.base.v6.AdresseCType;
import de.finkonsens.rms.kmv.base.v6.BetroffenePersonCType;
import de.finkonsens.rms.kmv.base.v6.BetroffenerFallCType;
import de.finkonsens.rms.kmv.base.v6.SteuerfallCType;
import de.finkonsens.rms.kmv.base.v6.VerfasserCType;
import de.finkonsens.rms.kmv.flh.v1.AntragFLHCType;
import de.finkonsens.rms.kmv.flh.v1.FLHCType;
import de.finkonsens.rms.kmv.km.v6.AnweisungArtSType;
import de.finkonsens.rms.kmv.km.v6.AnweisungCType;
import de.finkonsens.rms.kmv.km.v6.KontrollmitteilungCType;
import de.finkonsens.rms.kmv.km.v6.ObjectFactory;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;

public class Kontrollmitteilung {
    private final ElsterXml elster;
    private final KontrollmitteilungCType kontrollmitteilung;

    public Kontrollmitteilung(Configuration configuration) {
        this.elster = new ElsterXml(configuration);
        this.elster.setVerfahren(VerfahrenSType.ELSTER_KMV);
        this.elster.setDatenart("FLHMitteilung");
        this.elster.setEmfaenger(null);
        this.kontrollmitteilung = Kontrollmitteilung.createKontrollmitteilung();
    }

    public Kontrollmitteilung(Path source) throws JAXBException, IOException {
        this(new ElsterXml(source));
    }

    public Kontrollmitteilung(ElsterXml elster) throws JAXBException {
        this.elster = elster;
        this.kontrollmitteilung = elster.getNutzdaten() != null ? Kontrollmitteilung.readKontrollmitteilung(this.elster.getNutzdaten()) : null;
    }

    public void save(Path destination) throws IOException, JAXBException {
        Files.writeString(destination, (CharSequence)this.toXml(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static String patchLinefeeds(String content) {
        if (content != null) {
            return content.replace('\n', ' ').replace('\t', ' ');
        }
        return content;
    }

    private KontrollmitteilungCType patchLinefeeds() throws JAXBException {
        if (this.kontrollmitteilung == null || this.kontrollmitteilung.getFLH() == null) {
            return this.kontrollmitteilung;
        }
        KontrollmitteilungCType result = Kontrollmitteilung.readKontrollmitteilung(Kontrollmitteilung.getKontrollmitteilungXml(this.kontrollmitteilung));
        FLHCType flh = result.getFLH();
        flh.setFoerderzweck(Kontrollmitteilung.patchLinefeeds(flh.getFoerderzweck()));
        AntragFLHCType antrag = flh.getAntrag();
        if (antrag != null) {
            antrag.setBeschaedigung(Kontrollmitteilung.patchLinefeeds(antrag.getBeschaedigung()));
            antrag.setMassnahme(Kontrollmitteilung.patchLinefeeds(antrag.getMassnahme()));
        }
        return result;
    }

    public String toXml() throws JAXBException {
        return this.elster.toXml(Kontrollmitteilung.getKontrollmitteilungXml(this.kontrollmitteilung));
    }

    public String toXmlPatched() throws JAXBException {
        return this.elster.toXml(Kontrollmitteilung.getKontrollmitteilungXml(this.patchLinefeeds()));
    }

    private static String getKontrollmitteilungXml(KontrollmitteilungCType kontrollmitteilung) throws JAXBException {
        if (kontrollmitteilung != null) {
            JAXBContext context = JAXBContext.newInstance(KontrollmitteilungCType.class);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
            StringWriter writer = new StringWriter();
            ObjectFactory factory = new ObjectFactory();
            marshaller.marshal(factory.createKontrollmitteilung(kontrollmitteilung), writer);
            return writer.toString();
        }
        return "";
    }

    public ElsterXml getElster() {
        return this.elster;
    }

    public KontrollmitteilungCType getKontrollmitteilung() {
        return this.kontrollmitteilung;
    }

    public void update(KontrollmitteilungCType kontrollmitteilung, NDHEmpfaengerCType empfaenger) {
        Optional<KontrollmitteilungCType> input = Optional.ofNullable(kontrollmitteilung);
        this.kontrollmitteilung.setVerfasser(input.map(KontrollmitteilungCType::getVerfasser).orElse(null));
        this.kontrollmitteilung.setAuftragnehmer(input.map(KontrollmitteilungCType::getAuftragnehmer).orElse(null));
        this.kontrollmitteilung.setBetroffenerFall(input.map(KontrollmitteilungCType::getBetroffenerFall).orElse(null));
        this.kontrollmitteilung.setFLH(input.map(KontrollmitteilungCType::getFLH).orElse(null));
        this.elster.setEmfaenger(empfaenger);
    }

    public Optional<String> getKmId() {
        return Optional.ofNullable(this.kontrollmitteilung).map(KontrollmitteilungCType::getAnweisung).map(AnweisungCType::getKmId);
    }

    public void updateKmId() {
        AnweisungCType anweisung = this.kontrollmitteilung.getAnweisung();
        if (anweisung == null) {
            anweisung = new AnweisungCType();
            this.kontrollmitteilung.setAnweisung(anweisung);
        }
        AnweisungCType finalAnweisung = anweisung;
        Optional.of(this.kontrollmitteilung).map(KontrollmitteilungCType::getBetroffenerFall).map(BetroffenerFallCType::getMeldejahr).map(Kontrollmitteilung::generateKmId).ifPresent(finalAnweisung::setKmId);
    }

    private static VerfasserCType createVerfasser() {
        VerfasserCType verfasser = new VerfasserCType();
        AdresseCType adresse = new AdresseCType();
        verfasser.setVerfasserAdresse(adresse);
        return verfasser;
    }

    private static SteuerfallCType.BetroffenePerson createBetroffenePerson() {
        SteuerfallCType.BetroffenePerson betroffenePerson = new SteuerfallCType.BetroffenePerson();
        BetroffenePersonCType.Adresse addresse = new BetroffenePersonCType.Adresse();
        betroffenePerson.setAdresse(addresse);
        return betroffenePerson;
    }

    private static FLHCType createFLHMitteilung() {
        FLHCType flh = new FLHCType();
        flh.setVersion("1");
        return flh;
    }

    private static String generateKmId(String jahr) {
        return KmId.createRandom(jahr).toString();
    }

    private static KontrollmitteilungCType createKontrollmitteilung() {
        KontrollmitteilungCType kontrollmitteilung = new KontrollmitteilungCType();
        kontrollmitteilung.setVersion("6");
        AnweisungCType anweisung = new AnweisungCType();
        anweisung.setArt(AnweisungArtSType.NEU);
        kontrollmitteilung.setAnweisung(anweisung);
        kontrollmitteilung.setVerfasser(Kontrollmitteilung.createVerfasser());
        BetroffenerFallCType betroffenerFall = new BetroffenerFallCType();
        BetroffenerFallCType.Steuerfall steuerfall = new BetroffenerFallCType.Steuerfall();
        steuerfall.setBetroffenePerson(Kontrollmitteilung.createBetroffenePerson());
        betroffenerFall.setSteuerfall(steuerfall);
        kontrollmitteilung.setBetroffenerFall(betroffenerFall);
        kontrollmitteilung.setFLH(Kontrollmitteilung.createFLHMitteilung());
        return kontrollmitteilung;
    }

    private static KontrollmitteilungCType readKontrollmitteilung(Element element) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance(KontrollmitteilungCType.class);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        JAXBElement<KontrollmitteilungCType> result = unmarshaller.unmarshal(element, KontrollmitteilungCType.class);
        return result.getValue();
    }

    private static KontrollmitteilungCType readKontrollmitteilung(String xml) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance(ObjectFactory.class);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        JAXBElement result = (JAXBElement)unmarshaller.unmarshal(new StringReader(xml));
        return (KontrollmitteilungCType)result.getValue();
    }
}

