/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.model;

import de.elster.elsterxml.schema.headerbasis.v3.BundeslandSType;
import de.elster.elsterxml.schema.headerbasis.v3.KompressionSType;
import de.elster.elsterxml.schema.headerbasis.v3.VerfahrenSType;
import de.elster.elsterxml.schema.headerbasis.v3.VerschluesselungSType;
import de.elster.elsterxml.schema.headerbasis.v3.VorgangSType;
import de.elster.elsterxml.schema.v11.Datei;
import de.elster.elsterxml.schema.v11.DatenTeilCType;
import de.elster.elsterxml.schema.v11.Elster;
import de.elster.elsterxml.schema.v11.EmpfaengerCType;
import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.elsterxml.schema.v11.NutzdatenHeaderCType;
import de.elster.elsterxml.schema.v11.NutzdatenblockCType;
import de.elster.elsterxml.schema.v11.RCCType;
import de.elster.elsterxml.schema.v11.TransferHeaderCType;
import de.elster.elsterxml.schema.v11.ZusatzCType;
import de.elster.flutopferhilfen.config.Configuration;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javafx.util.Pair;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;

public class ElsterXml {
    private static final String PLACEHOLDER = "{placeholder}";
    private final Elster elster;
    private final Element nutzdaten;

    public ElsterXml(Configuration configuration) {
        this.elster = ElsterXml.createElster(configuration);
        this.nutzdaten = null;
    }

    public void updateTransferHeader(Configuration configuration) {
        TransferHeaderCType transferHeader = this.elster.getTransferHeader();
        if (transferHeader == null) {
            transferHeader = ElsterXml.createTransferHeader(configuration);
            this.elster.setTransferHeader(transferHeader);
        }
        transferHeader.setHerstellerID("23400");
        transferHeader.setDatenLieferant(configuration.getDatenlieferant().orElse("Bitte den Namen Ihrer Beh\u00f6rde hier eintragen"));
        transferHeader.setVersionClient(configuration.getVersionClient());
    }

    public ElsterXml(Path source) throws JAXBException, IOException {
        this(Files.newBufferedReader(source, StandardCharsets.UTF_8));
    }

    public ElsterXml(Reader source) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance(Elster.class);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Elster elster = (Elster)unmarshaller.unmarshal(source);
        if (elster == null) {
            throw new IllegalArgumentException("Konnte den Steuerfall " + source + " nicht einlesen");
        }
        this.elster = elster;
        this.nutzdaten = ElsterXml.extractNutzdaten(elster);
    }

    private static Element extractNutzdaten(Elster elster) {
        if (elster.getDatenTeil() == null || elster.getDatenTeil().getNutzdatenblock() == null) {
            throw new IllegalArgumentException("Der Steuerfall ist nicht schemakonform");
        }
        List<NutzdatenblockCType> nutzdatenbloecke = elster.getDatenTeil().getNutzdatenblock();
        if (nutzdatenbloecke.isEmpty()) {
            return null;
        }
        if (nutzdatenbloecke.size() > 1) {
            throw new IllegalArgumentException("Sammeldaten sind nicht erlaubt");
        }
        NutzdatenblockCType nutzdatenblock = nutzdatenbloecke.get(0);
        if (nutzdatenblock == null) {
            return null;
        }
        NutzdatenblockCType.Nutzdaten nutzdaten = nutzdatenblock.getNutzdaten();
        if (nutzdaten == null || nutzdaten.getContent() == null) {
            return null;
        }
        Element element = null;
        for (Object content : nutzdaten.getContent()) {
            try {
                element = (Element)content;
                break;
            }
            catch (ClassCastException classCastException) {
            }
        }
        nutzdaten.getContent().clear();
        nutzdaten.getContent().add("\n{placeholder}\n");
        return element;
    }

    public void setDatenart(String datenart) {
        this.elster.getTransferHeader().setDatenArt(datenart);
    }

    public void setVerfahren(VerfahrenSType verfahren) {
        this.elster.getTransferHeader().setVerfahren(verfahren);
    }

    public void setTestmerker(String testmerker) {
        this.elster.getTransferHeader().setTestmerker(testmerker);
    }

    public void setEmfaenger(NDHEmpfaengerCType ndhEmpfaenger) {
        EmpfaengerCType empfaenger = new EmpfaengerCType();
        empfaenger.setId("L");
        empfaenger.setZiel(BundeslandSType.CS);
        this.elster.getTransferHeader().setEmpfaenger(empfaenger);
        if (ndhEmpfaenger != null) {
            NutzdatenblockCType nutzdatenblock = this.elster.getDatenTeil().getNutzdatenblock().get(0);
            NDHEmpfaengerCType ndhEmpfaengerInternal = nutzdatenblock.getNutzdatenHeader().getEmpfaenger();
            ndhEmpfaengerInternal.setId(ndhEmpfaenger.getId());
            ndhEmpfaengerInternal.setValue(ndhEmpfaenger.getValue());
        }
    }

    public NDHEmpfaengerCType getNdhEmpfaenger() {
        return this.elster.getDatenTeil().getNutzdatenblock().get(0).getNutzdatenHeader().getEmpfaenger();
    }

    public Element getNutzdaten() {
        return this.nutzdaten;
    }

    public String getTransferTicket() {
        return this.elster.getTransferHeader().getTransferTicket();
    }

    public Optional<String> getTransferHeaderError() {
        RCCType.Rueckgabe rueckgabe;
        RCCType rc = this.elster.getTransferHeader().getRC();
        if (rc != null && !"0".equals((rueckgabe = rc.getRueckgabe()).getCode())) {
            return Optional.of(rc.getRueckgabe().getText());
        }
        return Optional.empty();
    }

    public Optional<Pair<String, String>> getTransferHeaderErrors() {
        RCCType.Rueckgabe rueckgabe;
        RCCType rc = this.elster.getTransferHeader().getRC();
        if (rc != null && !"0".equals((rueckgabe = rc.getRueckgabe()).getCode())) {
            return Optional.of(new Pair<String, String>(rueckgabe.getCode(), rueckgabe.getText()));
        }
        return Optional.empty();
    }

    public List<String> getNutzdatenErrors() {
        ArrayList<String> result = new ArrayList<String>();
        for (NutzdatenblockCType nutzdatenblock : this.elster.getDatenTeil().getNutzdatenblock()) {
            RCCType.Rueckgabe rueckgabe;
            RCCType rc = nutzdatenblock.getNutzdatenHeader().getRC();
            if (rc == null || "0".equals((rueckgabe = rc.getRueckgabe()).getCode())) continue;
            result.add(rueckgabe.getText());
        }
        return result;
    }

    public String toXml(String nutzdaten) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance(Elster.class);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)this.elster, writer);
        String result = writer.toString();
        result = result.replace(PLACEHOLDER, nutzdaten);
        return result;
    }

    private static Elster createElster(Configuration configuration) {
        Elster result = new Elster();
        result.setTransferHeader(ElsterXml.createTransferHeader(configuration));
        DatenTeilCType datenteil = new DatenTeilCType();
        NutzdatenblockCType nutzdatenblock = new NutzdatenblockCType();
        nutzdatenblock.setNutzdatenHeader(ElsterXml.createNutzdatenHeader());
        NutzdatenblockCType.Nutzdaten nutzdaten = new NutzdatenblockCType.Nutzdaten();
        nutzdaten.getContent().add("\n{placeholder}\n");
        nutzdatenblock.setNutzdaten(nutzdaten);
        datenteil.getNutzdatenblock().add(nutzdatenblock);
        result.setDatenTeil(datenteil);
        return result;
    }

    private static ZusatzCType createZusatz(Configuration configuration) {
        ZusatzCType zusatz = new ZusatzCType();
        configuration.getZusatzInfo().ifPresent(zusatz.getInfo()::add);
        return zusatz;
    }

    private static TransferHeaderCType createTransferHeader(Configuration configuration) {
        TransferHeaderCType transferHeader = new TransferHeaderCType();
        transferHeader.setVersion("11");
        transferHeader.setVorgang(VorgangSType.SEND_AUTH);
        transferHeader.setEmpfaenger(new EmpfaengerCType());
        configuration.getTestmerkerVersand().ifPresent(transferHeader::setTestmerker);
        transferHeader.setHerstellerID("23400");
        configuration.getDatenlieferant().ifPresent(transferHeader::setDatenLieferant);
        transferHeader.setVersionClient(configuration.getVersionClient());
        transferHeader.setZusatz(ElsterXml.createZusatz(configuration));
        Datei datei = new Datei();
        datei.setVerschluesselung(VerschluesselungSType.CMS_ENCRYPTED_DATA);
        datei.setKompression(KompressionSType.GZIP);
        transferHeader.setDatei(datei);
        return transferHeader;
    }

    private static NutzdatenHeaderCType createNutzdatenHeader() {
        NutzdatenHeaderCType nutzdatenHeader = new NutzdatenHeaderCType();
        nutzdatenHeader.setVersion("11");
        nutzdatenHeader.setNutzdatenTicket(UUID.randomUUID().toString().replace("-", ""));
        NDHEmpfaengerCType nutzdatenEmpfaenger = new NDHEmpfaengerCType();
        nutzdatenHeader.setEmpfaenger(nutzdatenEmpfaenger);
        nutzdatenHeader.setDatenLieferant("FlutopferhilfenMitteilung");
        return nutzdatenHeader;
    }
}

