/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.model;

import de.elster.elsterxml.schema.headerbasis.v3.EmpfaengerIDSType;
import de.elster.elsterxml.schema.headerbasis.v3.VerfahrenSType;
import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.model.ElsterXml;
import de.finkonsens.elster.elsterdatenabholung.v3.Datenabholung;
import de.finkonsens.elster.elsterdatenabholung.v3.PostfachBestaetigungRequestCType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.stream.XMLStreamException;

public class DatenabholungBestaetigung {
    private final ElsterXml elster;
    private final Datenabholung datenabholung;

    public DatenabholungBestaetigung(List<String> ids, Configuration configuration) {
        this.elster = new ElsterXml(configuration);
        this.elster.setVerfahren(VerfahrenSType.ELSTER_DATENABHOLUNG);
        this.elster.setDatenart("PostfachBestaetigung");
        NDHEmpfaengerCType empfaenger = new NDHEmpfaengerCType();
        empfaenger.setId(EmpfaengerIDSType.L);
        empfaenger.setValue("CS");
        this.elster.setEmfaenger(empfaenger);
        this.datenabholung = new Datenabholung();
        this.datenabholung.setVersion("31");
        PostfachBestaetigungRequestCType bestaetigung = new PostfachBestaetigungRequestCType();
        PostfachBestaetigungRequestCType.Bereitstellungen bereitstellungen = new PostfachBestaetigungRequestCType.Bereitstellungen();
        bestaetigung.setBereitstellungen(bereitstellungen);
        this.datenabholung.setPostfachBestaetigung(bestaetigung);
        for (String id : ids) {
            PostfachBestaetigungRequestCType.Bereitstellungen.Bereitstellung bereitstellung = new PostfachBestaetigungRequestCType.Bereitstellungen.Bereitstellung();
            bereitstellung.setId(id);
            bereitstellungen.getBereitstellung().add(bereitstellung);
        }
    }

    public DatenabholungBestaetigung(Reader reader) throws JAXBException, XMLStreamException {
        this(new ElsterXml(reader));
    }

    public DatenabholungBestaetigung(Path source) throws JAXBException, IOException, XMLStreamException {
        this(new ElsterXml(source));
    }

    public DatenabholungBestaetigung(ElsterXml elster) throws JAXBException {
        this.elster = elster;
        if (elster.getNutzdaten() != null) {
            JAXBContext context = JAXBContext.newInstance(Datenabholung.class);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setEventHandler(new DefaultValidationEventHandler());
            this.datenabholung = unmarshaller.unmarshal(elster.getNutzdaten(), Datenabholung.class).getValue();
        } else {
            this.datenabholung = null;
        }
    }

    public String toXml() throws JAXBException {
        if (this.datenabholung != null) {
            JAXBContext context = JAXBContext.newInstance(Datenabholung.class);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)this.datenabholung, writer);
            return this.elster.toXml(writer.toString());
        }
        return this.elster.toXml("");
    }

    public void save(Path destination) throws IOException, JAXBException {
        Files.writeString(destination, (CharSequence)this.toXml(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public ElsterXml getElsterXml() {
        return this.elster;
    }
}

