/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.model;

import de.elster.elsterxml.schema.headerbasis.v3.EmpfaengerIDSType;
import de.elster.elsterxml.schema.headerbasis.v3.VerfahrenSType;
import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.model.ElsterXml;
import de.finkonsens.elster.elsterdatenabholung.v3.Datenabholung;
import de.finkonsens.elster.elsterdatenabholung.v3.MetaCType;
import de.finkonsens.elster.elsterdatenabholung.v3.MetaInformationenCType;
import de.finkonsens.elster.elsterdatenabholung.v3.PAAntwortBereitstellungCType;
import de.finkonsens.elster.elsterdatenabholung.v3.PostfachAnfrageAntwortResponseCType;
import de.finkonsens.elster.elsterdatenabholung.v3.PostfachAnfrageDatenartBereitstellungCType;
import de.finkonsens.elster.elsterdatenabholung.v3.PostfachAnfrageRequestCType;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.util.Pair;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.stream.XMLStreamException;

public class DatenabholungAnfrage {
    private final ElsterXml elster;
    private final Datenabholung datenabholung;

    public DatenabholungAnfrage(String transferticket, String lieferdatum, String paginierung, Configuration configuration) {
        this.elster = new ElsterXml(configuration);
        this.elster.setVerfahren(VerfahrenSType.ELSTER_DATENABHOLUNG);
        this.elster.setDatenart("PostfachAnfrage");
        NDHEmpfaengerCType empfaenger = new NDHEmpfaengerCType();
        empfaenger.setId(EmpfaengerIDSType.L);
        empfaenger.setValue("CS");
        this.elster.setEmfaenger(empfaenger);
        this.datenabholung = new Datenabholung();
        this.datenabholung.setVersion("31");
        PostfachAnfrageRequestCType anfrage = new PostfachAnfrageRequestCType();
        anfrage.setEinschraenkung("alle");
        anfrage.setMax("1000");
        if (lieferdatum != null) {
            anfrage.setVon(lieferdatum);
        }
        if (paginierung != null) {
            anfrage.setPaginierungLetzteBestId(paginierung);
        }
        PostfachAnfrageDatenartBereitstellungCType bereitstellung = new PostfachAnfrageDatenartBereitstellungCType();
        bereitstellung.setName("KMVProtokoll");
        anfrage.getDatenartBereitstellung().add(bereitstellung);
        this.datenabholung.setPostfachAnfrage(anfrage);
    }

    public DatenabholungAnfrage(Reader reader) throws JAXBException, XMLStreamException {
        this(new ElsterXml(reader));
    }

    public DatenabholungAnfrage(Path source) throws JAXBException, IOException, XMLStreamException {
        this(new ElsterXml(source));
    }

    public DatenabholungAnfrage(ElsterXml elster) throws JAXBException {
        this.elster = elster;
        if (elster.getNutzdaten() != null) {
            JAXBContext context = JAXBContext.newInstance(Datenabholung.class);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setEventHandler(new DefaultValidationEventHandler());
            this.datenabholung = unmarshaller.unmarshal(elster.getNutzdaten(), Datenabholung.class).getValue();
        } else {
            this.datenabholung = null;
        }
    }

    public List<Pair<String, String>> getRequestedIds(String transferticket) {
        String kmArt = "";
        String lieferticket = "";
        if (this.datenabholung == null || this.datenabholung.getPostfachAnfrageAntwort() == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, String>> ids = new ArrayList<Pair<String, String>>();
        PostfachAnfrageAntwortResponseCType postfachAntwort = this.datenabholung.getPostfachAnfrageAntwort();
        for (PostfachAnfrageAntwortResponseCType.DatenartBereitstellung bereitstellung : postfachAntwort.getDatenartBereitstellung()) {
            String anzahlTreffer = bereitstellung.getAnzahltreffer();
            if (Integer.parseInt(anzahlTreffer) == 0) {
                return ids;
            }
            for (PAAntwortBereitstellungCType b : bereitstellung.getBereitstellungen().getBereitstellung()) {
                MetaInformationenCType metaInfos = b.getMetaInformationen();
                for (Serializable item : metaInfos.getContent()) {
                    try {
                        JAXBElement metaInfo = (JAXBElement)item;
                        MetaCType metaData = (MetaCType)metaInfo.getValue();
                        String name = metaData.getName();
                        String value = metaData.getValue();
                        if ("kmArt".equals(name)) {
                            kmArt = value;
                            continue;
                        }
                        if (!"lieferticket".equals(name)) continue;
                        lieferticket = value;
                    }
                    catch (ClassCastException classCastException) {}
                }
                if (!kmArt.equals("FLHMitteilung") || !lieferticket.equals(transferticket)) continue;
                String ottoId = b.getDatenpaket().getReferenzId();
                String bereitstellungId = b.getId();
                ids.add(new Pair<String, String>(ottoId, bereitstellungId));
            }
        }
        return ids;
    }

    public String getPaginierung() {
        if (this.datenabholung == null || this.datenabholung.getPostfachAnfrageAntwort() == null || this.datenabholung.getPostfachAnfrageAntwort().getPaginierungLetzteBestId() == null) {
            return null;
        }
        String neuePaginierung = this.datenabholung.getPostfachAnfrageAntwort().getPaginierungLetzteBestId();
        return neuePaginierung;
    }

    public String toXml() throws JAXBException {
        if (this.datenabholung != null) {
            JAXBContext context = JAXBContext.newInstance(Datenabholung.class);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)this.datenabholung, writer);
            return this.elster.toXml(writer.toString());
        }
        return this.elster.toXml("");
    }

    public void save(Path destination) throws IOException, JAXBException {
        Files.writeString(destination, (CharSequence)this.toXml(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public ElsterXml getElsterXml() {
        return this.elster;
    }
}

