/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.model;

import de.elster.elsterxml.schema.headerbasis.v3.EmpfaengerIDSType;
import de.elster.elsterxml.schema.headerbasis.v3.VerfahrenSType;
import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.model.ElsterXml;
import de.finkonsens.elster.elsterdatenabholung.v3.AbholungCType;
import de.finkonsens.elster.elsterdatenabholung.v3.Datenabholung;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class DatenabholungAbholung {
    private final ElsterXml elster;
    private final Datenabholung datenabholung;

    public DatenabholungAbholung(String id, Configuration configuration) {
        this.elster = new ElsterXml(configuration);
        this.elster.setVerfahren(VerfahrenSType.ELSTER_DATENABHOLUNG);
        this.elster.setDatenart("ElsterKMVDaten");
        NDHEmpfaengerCType empfaenger = new NDHEmpfaengerCType();
        empfaenger.setId(EmpfaengerIDSType.L);
        empfaenger.setValue("CS");
        this.elster.setEmfaenger(empfaenger);
        this.datenabholung = new Datenabholung();
        this.datenabholung.setVersion("18");
        AbholungCType abholung = new AbholungCType();
        abholung.setId(id);
        this.datenabholung.setAbholung(abholung);
    }

    public DatenabholungAbholung(ElsterXml elster) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance(Datenabholung.class);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        this.elster = elster;
        this.datenabholung = elster.getNutzdaten() != null ? unmarshaller.unmarshal(elster.getNutzdaten(), Datenabholung.class).getValue() : null;
    }

    public byte[] getDatenpaket() {
        if (this.datenabholung == null || this.datenabholung.getAbholung() == null) {
            return new byte[0];
        }
        return this.datenabholung.getAbholung().getDatenpaket().getBytes(StandardCharsets.UTF_8);
    }

    public String toXml() throws JAXBException {
        if (this.datenabholung != null) {
            JAXBContext context = JAXBContext.newInstance(Datenabholung.class);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)this.datenabholung, writer);
            return this.elster.toXml(writer.toString());
        }
        return this.elster.toXml("");
    }

    public void save(Path destination) throws JAXBException, IOException {
        Files.writeString(destination, (CharSequence)this.toXml(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public ElsterXml getElster() {
        return this.elster;
    }
}

