/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.model;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.eric.EricException;
import de.elster.flutopferhilfen.eric.EricWrapper;
import de.elster.flutopferhilfen.eric.Otto;
import de.elster.flutopferhilfen.eric.OttoErrorcode;
import de.elster.flutopferhilfen.eric.schemas.EricBearbeiteVorgang;
import de.elster.flutopferhilfen.eric.schemas.FehlerRegelpruefungTyp;
import de.elster.flutopferhilfen.model.DatenabholungAbholung;
import de.elster.flutopferhilfen.model.DatenabholungAnfrage;
import de.elster.flutopferhilfen.model.DatenabholungBestaetigung;
import de.elster.flutopferhilfen.model.ElsterXml;
import de.elster.flutopferhilfen.model.Kontrollmitteilung;
import de.elster.flutopferhilfen.model.Pin;
import de.elster.flutopferhilfen.model.Protokoll;
import de.elster.flutopferhilfen.model.Storno;
import de.finkonsens.rms.kmv.base.v6.BetroffenerFallCType;
import de.finkonsens.rms.kmv.km.v6.KontrollmitteilungCType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javafx.util.Pair;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class Case {
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final String name;
    private State state;
    private boolean deleted;
    private String transferTicket;
    private Set<String> transferTickets = new HashSet<String>();
    private LocalDate sendDate;
    private LocalDate stornoSendDate;
    private Kontrollmitteilung kontrollmitteilung;
    private Kontrollmitteilung kontrollmitteilungResponse;
    private DatenabholungAnfrage request;
    private DatenabholungAnfrage requestResponse;
    private DatenabholungAbholung receive;
    private DatenabholungAbholung receiveResponse;
    private DatenabholungBestaetigung commit;
    private DatenabholungBestaetigung commitResponse;
    private Protokoll protokoll;
    private Storno storno;
    private String stornoTransferTicket;
    private Set<String> stornoTransferTickets = new HashSet<String>();
    private Storno stornoResponse;
    private DatenabholungAnfrage stornoRequest;
    private DatenabholungAnfrage stornoRequestResponse;
    private DatenabholungAbholung stornoReceive;
    private DatenabholungAbholung stornoReceiveResponse;
    private Protokoll stornoProtokoll;

    public static LocalDate parseDate(String date) {
        return date != null ? LocalDate.parse(date, dateFormatter) : null;
    }

    public static boolean isOverdue(State state, boolean deleted, LocalDate sendDate, LocalDate stornoSendDate) {
        if (deleted) {
            return false;
        }
        if (state == State.SEND) {
            return sendDate != null && ChronoUnit.DAYS.between(sendDate, LocalDate.now()) >= 10L;
        }
        if (state == State.STORNO_SEND) {
            return stornoSendDate != null && ChronoUnit.DAYS.between(stornoSendDate, LocalDate.now()) >= 10L;
        }
        return false;
    }

    public boolean isOverdue() {
        return Case.isOverdue(this.state, this.deleted, this.sendDate, this.stornoSendDate);
    }

    public static Stream<Path> list(Configuration configuration) throws IOException {
        return Files.list(configuration.getCases()).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
    }

    public static Optional<Content> getCaseMetaData(Path source) {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return Optional.of(mapper.readValue(Case.getCaseYaml(source).toFile(), Content.class));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public Case(String name, Configuration configuration) {
        this.name = name;
        this.state = State.EDIT;
        this.deleted = false;
        this.kontrollmitteilung = new Kontrollmitteilung(configuration);
    }

    public Case(Path source) throws IOException, JAXBException {
        Optional<Content> optionalContent = Case.getCaseMetaData(source);
        if (optionalContent.isEmpty()) {
            throw new IOException("Kann Flutopferhilfen-Mitteilung nicht \u00f6ffnen");
        }
        Content content = optionalContent.get();
        Path sourceYaml = Case.getCaseYaml(source);
        this.name = content.name;
        this.state = content.state;
        this.deleted = content.deleted;
        this.transferTicket = content.transferTicket;
        this.transferTickets.addAll(content.transferTickets);
        this.sendDate = Case.parseDate(content.sendDate);
        this.stornoSendDate = Case.parseDate(content.stornoSendDate);
        this.kontrollmitteilung = new Kontrollmitteilung(sourceYaml.getParent().resolve(content.kontrollmitteilung));
        this.kontrollmitteilungResponse = content.kontrollmitteilungResponse != null ? new Kontrollmitteilung(sourceYaml.getParent().resolve(content.kontrollmitteilungResponse)) : null;
        this.protokoll = content.protokoll != null ? new Protokoll(sourceYaml.getParent().resolve(content.protokoll)) : null;
        this.storno = content.storno != null ? new Storno(sourceYaml.getParent().resolve(content.storno)) : null;
        this.stornoResponse = content.stornoResponse != null ? new Storno(sourceYaml.getParent().resolve(content.stornoResponse)) : null;
        this.stornoTransferTicket = content.stornoTransferTicket;
        this.stornoTransferTickets.addAll(content.stornoTransferTickets);
        this.stornoProtokoll = content.stornoProtokoll != null ? new Protokoll(sourceYaml.getParent().resolve(content.stornoProtokoll)) : null;
    }

    private static Path getCaseYaml(Path source) {
        if (Files.isDirectory(source, new LinkOption[0])) {
            return source.resolve("case.yaml");
        }
        return source;
    }

    public void save(Configuration configuration, Path destination) throws IOException, JAXBException {
        if (Files.isRegularFile(destination, new LinkOption[0])) {
            throw new IllegalArgumentException("Destination can't be a regular file");
        }
        Files.createDirectories(destination, new FileAttribute[0]);
        Path destinationYaml = destination.resolve("case.yaml");
        Path kontrollmitteilungDestination = destination.resolve("kontrollmitteilung.xml");
        Path KontrollmitteilungResponseDestination = destination.resolve("kontrollmitteilung_response.xml");
        Path requestDestination = destination.resolve("request.xml");
        Path requestResponseDestination = destination.resolve("request_response.xml");
        Path receiveDestination = destination.resolve("receive.xml");
        Path receiveResponseDestination = destination.resolve("receive_response.xml");
        Path protokollDestination = destination.resolve("protokoll.xml");
        Path stornoDestination = destination.resolve("storno.xml");
        Path stornoResponseDestination = destination.resolve("storno_response.xml");
        Path stornoRequestDestination = destination.resolve("storno_request.xml");
        Path stornoRequestResponseDestination = destination.resolve("storno_request_response.xml");
        Path stornoReceiveDestination = destination.resolve("storno_receive.xml");
        Path stornoReceiveResponseDestination = destination.resolve("storno_receive_response.xml");
        Path protokollStornoDestination = destination.resolve("protokoll_storno.xml");
        String kontrollmitteilungResponseValue = null;
        if (this.kontrollmitteilungResponse != null) {
            kontrollmitteilungResponseValue = destination.relativize(KontrollmitteilungResponseDestination).toString();
        }
        String requestValue = null;
        if (this.request != null) {
            requestValue = destination.relativize(requestDestination).toString();
        }
        String requestResponseValue = null;
        if (this.requestResponse != null) {
            requestResponseValue = destination.relativize(requestResponseDestination).toString();
        }
        String receiveValue = null;
        if (this.receive != null) {
            receiveValue = destination.relativize(receiveDestination).toString();
        }
        String receiveResponseValue = null;
        if (this.receiveResponse != null) {
            receiveResponseValue = destination.relativize(receiveResponseDestination).toString();
        }
        String protokollValue = null;
        if (this.protokoll != null) {
            protokollValue = destination.relativize(protokollDestination).toString();
        }
        String stornoValue = null;
        if (this.storno != null) {
            stornoValue = destination.relativize(stornoDestination).toString();
        }
        String stornoResponseValue = null;
        if (this.stornoResponse != null) {
            stornoResponseValue = destination.relativize(stornoResponseDestination).toString();
        }
        String stornoRequestValue = null;
        if (this.stornoRequest != null) {
            stornoRequestValue = destination.relativize(stornoRequestDestination).toString();
        }
        String stornoRequestResponseValue = null;
        if (this.stornoRequestResponse != null) {
            stornoRequestResponseValue = destination.relativize(stornoRequestResponseDestination).toString();
        }
        String stornoReceiveValue = null;
        if (this.stornoReceive != null) {
            stornoReceiveValue = destination.relativize(stornoReceiveDestination).toString();
        }
        String stornoReceiveResponseValue = null;
        if (this.stornoReceiveResponse != null) {
            stornoReceiveResponseValue = destination.relativize(stornoReceiveResponseDestination).toString();
        }
        String protokollStornoValue = null;
        if (this.stornoProtokoll != null) {
            protokollStornoValue = destination.relativize(protokollStornoDestination).toString();
        }
        Content content = new Content(destination.getFileName().toString(), this.state, this.deleted, this.transferTicket, new ArrayList<String>(this.transferTickets), this.sendDate != null ? dateFormatter.format(this.sendDate) : null, this.stornoSendDate != null ? dateFormatter.format(this.stornoSendDate) : null, destination.relativize(kontrollmitteilungDestination).toString(), kontrollmitteilungResponseValue, requestValue, requestResponseValue, receiveValue, receiveResponseValue, protokollValue, stornoValue, this.stornoTransferTicket, new ArrayList<String>(this.stornoTransferTickets), stornoResponseValue, stornoRequestValue, stornoRequestResponseValue, stornoReceiveValue, stornoReceiveResponseValue, protokollStornoValue);
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        mapper.writeValue(destinationYaml.toFile(), (Object)content);
        if (this.state == State.EDIT) {
            this.kontrollmitteilung.getElster().updateTransferHeader(configuration);
            this.kontrollmitteilung.updateKmId();
        }
        this.kontrollmitteilung.save(kontrollmitteilungDestination);
        if (this.kontrollmitteilungResponse != null) {
            this.kontrollmitteilungResponse.save(KontrollmitteilungResponseDestination);
        }
        if (this.request != null) {
            this.request.save(requestDestination);
        }
        if (this.requestResponse != null) {
            this.requestResponse.save(requestResponseDestination);
        }
        if (this.receive != null) {
            this.receive.save(receiveDestination);
        }
        if (this.receiveResponse != null) {
            this.receiveResponse.save(receiveResponseDestination);
        }
        if (this.protokoll != null) {
            this.protokoll.save(protokollDestination);
        }
        if (this.storno != null) {
            if (this.state == State.ACCEPTED) {
                this.storno.getElster().updateTransferHeader(configuration);
                this.storno.updateKmId(this.kontrollmitteilung.getKmId().orElse(null));
            }
            this.storno.save(stornoDestination);
        }
        if (this.stornoResponse != null) {
            this.stornoResponse.save(stornoResponseDestination);
        }
        if (this.stornoRequest != null) {
            this.stornoRequest.save(stornoRequestDestination);
        }
        if (this.stornoRequestResponse != null) {
            this.stornoRequestResponse.save(stornoRequestResponseDestination);
        }
        if (this.stornoReceive != null) {
            this.stornoReceive.save(stornoReceiveDestination);
        }
        if (this.stornoReceiveResponse != null) {
            this.stornoReceiveResponse.save(stornoReceiveResponseDestination);
        }
        if (this.stornoProtokoll != null) {
            this.stornoProtokoll.save(protokollStornoDestination);
        }
    }

    public Case duplicate(String name, Configuration configuration) {
        Case result = new Case(name, configuration);
        result.state = State.EDIT;
        result.deleted = false;
        result.transferTicket = null;
        result.transferTickets = new HashSet<String>();
        result.kontrollmitteilung = this.kontrollmitteilung;
        result.kontrollmitteilungResponse = null;
        result.request = null;
        result.requestResponse = null;
        result.receive = null;
        result.receiveResponse = null;
        result.protokoll = null;
        result.storno = null;
        result.stornoTransferTicket = null;
        result.stornoTransferTickets = new HashSet<String>();
        result.stornoResponse = null;
        result.stornoRequest = null;
        result.stornoRequestResponse = null;
        result.stornoReceive = null;
        result.stornoReceiveResponse = null;
        result.stornoProtokoll = null;
        return result;
    }

    public Result validate() throws JAXBException, SAXException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL resource = Case.class.getResource("/de/elster/flutopferhilfen/schemas/kmv/elster11_kmv_FLH_000001_extern.xsd");
        if (resource == null) {
            throw new RuntimeException("Can't find Flutopferhilfen-Mitteilung schemas in resources");
        }
        Schema schema = schemaFactory.newSchema(resource);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(new ByteArrayInputStream(this.kontrollmitteilung.toXmlPatched().getBytes(StandardCharsets.UTF_8)));
        try {
            validator.validate(source);
            return Result.success();
        }
        catch (IllegalArgumentException | SAXException e) {
            return Result.failure(e.getMessage());
        }
    }

    public Result send(Eric eric, Configuration configuration, String pin) throws JAXBException, MalformedURLException {
        return this.send(eric, configuration, Pin.fixed(pin));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result send(Eric eric, Configuration configuration, Pin pin) throws JAXBException, MalformedURLException {
        Eric.VorgangResult elsterKMV;
        if (this.state != State.EDIT) {
            return Result.failure("Flutopferhilfen-Mitteilung wurde bereits versendet");
        }
        if (!configuration.getClientCertificate().isPresent()) return Result.failure("Es muss zun\u00e4chst ein ELSTER-Client-Zertifikat in den Einstellungen gesetzt werden");
        try (Eric.Token token = eric.getToken(configuration.getClientCertificate().get());){
            Eric.VorgangBuilder builder222 = eric.bearbeiteVorgang(this.kontrollmitteilung.toXmlPatched(), "ElsterKMV").useToken(token);
            if (token.needsSignaturePin() || token.needsEncryptionPin()) {
                Optional<String> pinInput = pin.get();
                if (!pinInput.isPresent()) {
                    pin.reset();
                    Result result = Result.failure("Eingabe des Zertifikatspassworts unterbrochen");
                    return result;
                }
                builder222.withPin(pinInput.get());
            }
            elsterKMV = builder222.send();
        }
        catch (Eric.TokenException e) {
            return Result.failure(e.getMessage());
        }
        this.sendDate = LocalDate.now();
        this.transferTickets.addAll(elsterKMV.getTransferTickets());
        ElsterXml answer = elsterKMV.getServerAnswer();
        int rc = elsterKMV.getRc();
        if (rc == 0) {
            this.state = State.SEND;
            this.transferTicket = answer.getTransferTicket();
            this.kontrollmitteilungResponse = new Kontrollmitteilung(answer);
            this.sendDate = LocalDate.now();
            return Result.fromVorgangResult(elsterKMV, "Die Flutopferhilfen-Mitteilung konnte nicht versendet werden");
        }
        if (!EricWrapper.isTokenError(rc)) return Result.fromVorgangResult(elsterKMV, "Die Flutopferhilfen-Mitteilung konnte nicht versendet werden");
        pin.reset();
        return Result.fromVorgangResult(elsterKMV, "Die Flutopferhilfen-Mitteilung konnte nicht versendet werden");
    }

    public Result request(Eric eric, String pin, Configuration configuration) throws JAXBException, MalformedURLException {
        return this.request(eric, Pin.fixed(pin), configuration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result request(Eric eric, Pin pin, Configuration configuration) throws JAXBException, MalformedURLException {
        Eric.VorgangResult protokollAnfrage;
        ArrayList<Pair<String, String>> ids = new ArrayList<Pair<String, String>>();
        if (this.state != State.SEND) {
            return Result.failure("Flutopferhilfen-Mitteilung wurde noch nicht versendet");
        }
        if (this.transferTicket == null) {
            return Result.failure("Der Flutopferhilfen-Mitteilung wurde noch kein Transfer-Ticket zugeordnet");
        }
        if (!configuration.getClientCertificate().isPresent()) return Result.failure("Es muss zun\u00e4chst ein ELSTER-Client-Zertifikat in den Einstellungen gesetzt werden");
        String lieferdatum = this.sendDate.format(dateFormatter);
        String paginierung = null;
        do {
            this.request = new DatenabholungAnfrage(this.transferTicket, lieferdatum, paginierung, configuration);
            try (Eric.Token token = eric.getToken(configuration.getClientCertificate().get());){
                Eric.VorgangBuilder builder = eric.bearbeiteVorgang(this.request.toXml(), "PostfachAnfrage_31").useToken(token);
                if (token.needsEncryptionPin() || token.needsSignaturePin()) {
                    Optional<String> pinInput = pin.get();
                    if (!pinInput.isPresent()) {
                        Result result = Result.failure("Eingabe des Zertifikatspassworts unterbrochen");
                        return result;
                    }
                    builder.withPin(pinInput.get());
                }
                protokollAnfrage = builder.send();
            }
            catch (Eric.TokenException e) {
                pin.reset();
                return Result.failure(e.getMessage());
            }
            ElsterXml answer = protokollAnfrage.getServerAnswer();
            if (answer == null) continue;
            this.requestResponse = new DatenabholungAnfrage(answer);
            paginierung = this.requestResponse.getPaginierung();
            ids.addAll(this.requestResponse.getRequestedIds(this.transferTicket));
        } while (paginierung != null);
        int rc = protokollAnfrage.getRc();
        if (EricWrapper.isTokenError(rc)) {
            pin.reset();
            return Result.fromVorgangResult(protokollAnfrage, "Das Protokoll zur Flutopferhilfen-Mitteilung konnte nicht abgeholt werden");
        }
        if (rc != 0) return Result.fromVorgangResult(protokollAnfrage, "Das Protokoll zur Flutopferhilfen-Mitteilung konnte nicht abgeholt werden");
        return Result.successPair(ids);
    }

    public Result receive(Eric eric, String pin, String id, Configuration configuration) throws JAXBException {
        return this.receive(eric, Pin.fixed(pin), id, configuration);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public Result receive(Eric eric, Pin pin, String id, Configuration configuration) throws JAXBException {
        block24: {
            if (this.state != State.SEND) {
                return Result.failure("Flutopferhilfen-Mitteilung wurde noch nicht versendet");
            }
            if (!configuration.getClientCertificate().isPresent()) break block24;
            try {
                token = eric.getToken(configuration.getClientCertificate().get());
                try {
                    block23: {
                        block21: {
                            block22: {
                                otto = new Otto(configuration);
                                try {
                                    pinInput = Optional.empty();
                                    if (!token.needsEncryptionPin() && !token.needsSignaturePin()) break block21;
                                    pinInput = pin.get();
                                    if (!pinInput.isPresent()) ** GOTO lbl31
                                    rc = otto.ladeZertifikat(configuration, (String)pinInput.get());
                                    if (rc == OttoErrorcode.OTTO_OK.getErrorcode()) break block22;
                                    var9_17 = Result.failure("Laden des Zertifikats in Otto nicht erfolgreich");
                                }
                                catch (Throwable var7_11) {
                                    try {
                                        otto.close();
                                    }
                                    catch (Throwable var8_16) {
                                        var7_11.addSuppressed(var8_16);
                                    }
                                    throw var7_11;
                                }
                                otto.close();
                                return var9_17;
                            }
                            break block21;
lbl31:
                            // 1 sources

                            rc = Result.failure("Eingabe des Zertifikatspassworts unterbrochen");
                            otto.close();
                            return rc;
                        }
                        antwort = otto.empfangeDaten(id);
                        in = new ByteArrayInputStream(antwort);
                        this.protokoll = new Protokoll(in);
                        errors = this.protokoll.getErrors();
                        if (!errors.isEmpty()) break block23;
                        this.state = State.ACCEPTED;
                        var11_20 = Result.success(Collections.singletonList(this.protokoll.toXml()));
                        otto.close();
                        return var11_20;
                    }
                    this.state = State.EDIT;
                    var11_21 = Result.success(errors);
                    otto.close();
                    return var11_21;
                }
                finally {
                    if (token != null) {
                        token.close();
                    }
                }
            }
            catch (Eric.TokenException | EricException e) {
                pin.reset();
                return Result.failure(e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Result.failure("Es muss zun\u00e4chst ein ELSTER-Client-Zertifikat in den Einstellungen gesetzt werden");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result commit(Eric eric, Pin pin, List<String> ids, Configuration configuration) throws JAXBException, XMLStreamException, MalformedURLException {
        Eric.VorgangResult posfachBestaetigungResult;
        this.commit = new DatenabholungBestaetigung(ids, configuration);
        try (Eric.Token token = eric.getToken(configuration.getClientCertificate().get());){
            Eric.VorgangBuilder builder = eric.bearbeiteVorgang(this.commit.toXml(), "PostfachBestaetigung_31").useToken(token);
            if (token.needsEncryptionPin() || token.needsSignaturePin()) {
                Optional<String> pinInput = pin.get();
                if (!pinInput.isPresent()) {
                    Result result = Result.failure("Eingabe des Zertifikatspassworts unterbrochen");
                    return result;
                }
                builder.withPin(pinInput.get());
            }
            posfachBestaetigungResult = builder.send();
        }
        catch (Eric.TokenException e) {
            pin.reset();
            return Result.failure(e.getMessage());
        }
        ElsterXml answer = posfachBestaetigungResult.getServerAnswer();
        if (answer != null) {
            this.commitResponse = new DatenabholungBestaetigung(answer);
            if (this.commitResponse.getElsterXml().getNutzdatenErrors().isEmpty()) {
                return Result.success();
            }
        }
        this.state = State.SEND;
        return Result.failure("Protokollbestaetigung konnte nicht gesendet werden.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result stornoCommit(Eric eric, Pin pin, List<String> ids, Configuration configuration) throws JAXBException, XMLStreamException, MalformedURLException {
        Eric.VorgangResult posfachBestaetigungResult;
        this.commit = new DatenabholungBestaetigung(ids, configuration);
        try (Eric.Token token = eric.getToken(configuration.getClientCertificate().get());){
            Eric.VorgangBuilder builder = eric.bearbeiteVorgang(this.commit.toXml(), "PostfachBestaetigung_31").useToken(token);
            if (token.needsEncryptionPin() || token.needsSignaturePin()) {
                Optional<String> pinInput = pin.get();
                if (!pinInput.isPresent()) {
                    Result result = Result.failure("Eingabe des Zertifikatspassworts unterbrochen");
                    return result;
                }
                builder.withPin(pinInput.get());
            }
            posfachBestaetigungResult = builder.send();
        }
        catch (Eric.TokenException e) {
            pin.reset();
            return Result.failure(e.getMessage());
        }
        ElsterXml answer = posfachBestaetigungResult.getServerAnswer();
        if (answer != null) {
            this.commitResponse = new DatenabholungBestaetigung(answer);
            if (this.commitResponse.getElsterXml().getNutzdatenErrors().isEmpty()) {
                return Result.success();
            }
        }
        this.state = State.STORNO_SEND;
        return Result.failure("Protokollbestaetigung Strono konnte nicht gesendet werden.");
    }

    public Result createStorno(Configuration configuration) throws JAXBException {
        if (this.state != State.ACCEPTED) {
            return Result.failure("Nur akzeptierte Flutopferhilfen-Mitteilungen k\u00f6nnen storniert werden");
        }
        Optional<KontrollmitteilungCType> kontrollmitteilung = Optional.ofNullable(this.kontrollmitteilung.getKontrollmitteilung());
        this.storno = new Storno(this.kontrollmitteilung.getKmId().orElse(null), kontrollmitteilung.map(KontrollmitteilungCType::getBetroffenerFall).map(BetroffenerFallCType::getMeldejahr).orElse(null), kontrollmitteilung.map(KontrollmitteilungCType::getVerfasser).orElse(null), this.kontrollmitteilung.getElster().getNdhEmpfaenger(), configuration);
        return Result.success();
    }

    public Result stornoValidate() throws JAXBException, SAXException, IOException {
        if (this.storno != null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL resource = Case.class.getResource("/de/elster/flutopferhilfen/schemas/kmv/elster11_kmv_FLH_000001_extern.xsd");
            if (resource == null) {
                throw new RuntimeException("Can't find Flutopferhilfen-Mitteilung schemas in resources");
            }
            Schema schema = schemaFactory.newSchema(resource);
            Validator validator = schema.newValidator();
            StreamSource source = new StreamSource(new ByteArrayInputStream(this.storno.toXml().getBytes(StandardCharsets.UTF_8)));
            try {
                validator.validate(source);
                return Result.success();
            }
            catch (IllegalArgumentException | SAXException e) {
                return Result.failure(e.getMessage());
            }
        }
        return Result.failure("Es muss zun\u00e4chst eine Stornierung angelegt werden");
    }

    public Result cancel(Eric eric, String pin, Configuration configuration) throws JAXBException, MalformedURLException {
        return this.cancel(eric, Pin.fixed(pin), configuration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result cancel(Eric eric, Pin pin, Configuration configuration) throws JAXBException, MalformedURLException {
        Eric.VorgangResult stornoResult;
        if (this.storno == null) {
            return Result.failure("Es muss zun\u00e4chst eine Stornierung angelegt werden");
        }
        if (!configuration.getClientCertificate().isPresent()) return Result.failure("Es muss zun\u00e4chst ein ELSTER-Client-Zertifikat in den Einstellungen gesetzt werden");
        try (Eric.Token token = eric.getToken(configuration.getClientCertificate().get());){
            Eric.VorgangBuilder builder222 = eric.bearbeiteVorgang(this.storno.toXml(), "ElsterKMV").useToken(token);
            if (token.needsEncryptionPin() || token.needsSignaturePin()) {
                Optional<String> pinInput = pin.get();
                if (!pinInput.isPresent()) {
                    Result result = Result.failure("Eingabe des Zertifikatspassworts unterbrochen");
                    return result;
                }
                builder222.withPin(pinInput.get());
            }
            stornoResult = builder222.send();
        }
        catch (Eric.TokenException e) {
            pin.reset();
            return Result.failure(e.getMessage());
        }
        this.stornoSendDate = LocalDate.now();
        this.stornoTransferTickets.addAll(stornoResult.getTransferTickets());
        ElsterXml answer = stornoResult.getServerAnswer();
        int rc = stornoResult.getRc();
        if (rc == 0) {
            this.state = State.STORNO_SEND;
            this.stornoTransferTicket = answer.getTransferTicket();
            this.stornoResponse = new Storno(answer);
            this.stornoSendDate = LocalDate.now();
            return Result.fromVorgangResult(stornoResult, "Die Stornieruing der Flutopferhilfen-Mitteilung konnte nicht versendet werden");
        }
        if (!EricWrapper.isTokenError(rc)) return Result.fromVorgangResult(stornoResult, "Die Stornieruing der Flutopferhilfen-Mitteilung konnte nicht versendet werden");
        pin.reset();
        return Result.fromVorgangResult(stornoResult, "Die Stornieruing der Flutopferhilfen-Mitteilung konnte nicht versendet werden");
    }

    public Result stornoRequest(Eric eric, String pin, Configuration configuration) throws JAXBException, MalformedURLException {
        return this.stornoRequest(eric, Pin.fixed(pin), configuration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result stornoRequest(Eric eric, Pin pin, Configuration configuration) throws JAXBException, MalformedURLException {
        Eric.VorgangResult protokollAnfrage;
        ArrayList<Pair<String, String>> ids = new ArrayList<Pair<String, String>>();
        if (this.state != State.STORNO_SEND) {
            return Result.failure("Stornierung der Flutopferhilfen-Mitteilung wurde noch nicht versendet");
        }
        if (this.stornoTransferTicket == null) {
            return Result.failure("Der Stornierung der Flutopferhilfen-Mitteilung wurde noch kein Transfer-Ticket zugeordnet");
        }
        if (!configuration.getClientCertificate().isPresent()) return Result.failure("Es muss zun\u00e4chst ein ELSTER-Client-Zertifikat in den Einstellungen gesetzt werden");
        String lieferdatum = this.sendDate.format(dateFormatter);
        String paginierung = null;
        do {
            this.stornoRequest = new DatenabholungAnfrage(this.stornoTransferTicket, lieferdatum, paginierung, configuration);
            try (Eric.Token token = eric.getToken(configuration.getClientCertificate().get());){
                Eric.VorgangBuilder builder = eric.bearbeiteVorgang(this.stornoRequest.toXml(), "PostfachAnfrage_31").useToken(token);
                if (token.needsEncryptionPin() || token.needsSignaturePin()) {
                    Optional<String> pinInput = pin.get();
                    if (!pinInput.isPresent()) {
                        Result result = Result.failure("Eingabe des Zertifikatspassworts unterbrochen");
                        return result;
                    }
                    builder.withPin(pinInput.get());
                }
                protokollAnfrage = builder.send();
            }
            catch (Eric.TokenException e) {
                pin.reset();
                return Result.failure(e.getMessage());
            }
            ElsterXml answer = protokollAnfrage.getServerAnswer();
            if (answer == null) continue;
            this.stornoRequestResponse = new DatenabholungAnfrage(answer);
            paginierung = this.stornoRequestResponse.getPaginierung();
            ids.addAll(this.stornoRequestResponse.getRequestedIds(this.stornoTransferTicket));
        } while (paginierung != null);
        int rc = protokollAnfrage.getRc();
        if (EricWrapper.isTokenError(rc)) {
            pin.reset();
            return Result.fromVorgangResult(protokollAnfrage, "Das Protokoll zur Stornierung der BSB-Mitteilung konnte nicht abgeholt werden");
        }
        if (rc != 0) return Result.fromVorgangResult(protokollAnfrage, "Das Protokoll zur Stornierung der BSB-Mitteilung konnte nicht abgeholt werden");
        return Result.successPair(ids);
    }

    public Result stornoReceive(Eric eric, String pin, String id, Configuration configuration) throws JAXBException {
        return this.stornoReceive(eric, Pin.fixed(pin), id, configuration);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public Result stornoReceive(Eric eric, Pin pin, String id, Configuration configuration) throws JAXBException {
        block24: {
            if (this.state != State.STORNO_SEND) {
                return Result.failure("Stornierung der Flutopferhilfen-Mitteilung wurde noch nicht versendet");
            }
            if (!configuration.getClientCertificate().isPresent()) break block24;
            try {
                token = eric.getToken(configuration.getClientCertificate().get());
                try {
                    block23: {
                        block21: {
                            block22: {
                                otto = new Otto(configuration);
                                try {
                                    pinInput = Optional.empty();
                                    if (!token.needsEncryptionPin() && !token.needsSignaturePin()) break block21;
                                    pinInput = pin.get();
                                    if (!pinInput.isPresent()) ** GOTO lbl31
                                    rc = otto.ladeZertifikat(configuration, (String)pinInput.get());
                                    if (rc == OttoErrorcode.OTTO_OK.getErrorcode()) break block22;
                                    var9_17 = Result.failure("Laden des Zertifikats in Otto nicht erfolgreich");
                                }
                                catch (Throwable var7_11) {
                                    try {
                                        otto.close();
                                    }
                                    catch (Throwable var8_16) {
                                        var7_11.addSuppressed(var8_16);
                                    }
                                    throw var7_11;
                                }
                                otto.close();
                                return var9_17;
                            }
                            break block21;
lbl31:
                            // 1 sources

                            rc = Result.failure("Eingabe des Zertifikatspassworts unterbrochen");
                            otto.close();
                            return rc;
                        }
                        antwort = otto.empfangeDaten(id);
                        in = new ByteArrayInputStream(antwort);
                        this.stornoProtokoll = new Protokoll(in);
                        errors = this.protokoll.getErrors();
                        if (!errors.isEmpty()) break block23;
                        this.state = State.CANCELED;
                        var11_20 = Result.success(Collections.singletonList(this.protokoll.toXml()));
                        otto.close();
                        return var11_20;
                    }
                    this.state = State.ACCEPTED;
                    var11_21 = Result.success(errors);
                    otto.close();
                    return var11_21;
                }
                finally {
                    if (token != null) {
                        token.close();
                    }
                }
            }
            catch (Eric.TokenException | EricException e) {
                pin.reset();
                return Result.failure(e.getMessage());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Result.failure("Es muss zun\u00e4chst ein ELSTER-Client-Zertifikat in den Einstellungen gesetzt werden");
    }

    public boolean delete(Configuration configuration) {
        return this.deleteDirectoryRecursive(configuration.getCases().resolve(this.name));
    }

    private boolean deleteDirectoryRecursive(Path path) {
        try {
            return Files.list(path).allMatch(this::deleteEntry) && Files.deleteIfExists(path);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean deleteEntry(Path entry) {
        try {
            if (Files.isDirectory(entry, new LinkOption[0])) {
                return this.deleteDirectoryRecursive(entry);
            }
            if (Files.isRegularFile(entry, new LinkOption[0])) {
                return Files.deleteIfExists(entry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public State getState() {
        return this.state;
    }

    public Set<String> getTransferTickets() {
        HashSet<String> result = new HashSet<String>();
        if (this.transferTicket != null) {
            result.add(this.transferTicket);
        }
        result.addAll(this.transferTickets);
        return result;
    }

    public String getSendDate() {
        return this.sendDate != null ? DateTimeFormatter.ofPattern("dd.MM.yyyy").format(this.sendDate) : "<Leer>";
    }

    public String getStornoSendDate() {
        return this.stornoSendDate != null ? DateTimeFormatter.ofPattern("dd.MM.yyyy").format(this.stornoSendDate) : "<Leer>";
    }

    public Set<String> getStornoTransferTickets() {
        HashSet<String> result = new HashSet<String>();
        if (this.stornoTransferTicket != null) {
            result.add(this.stornoTransferTicket);
        }
        result.addAll(this.stornoTransferTickets);
        return result;
    }

    public Kontrollmitteilung getKontrollmitteilung() {
        return this.kontrollmitteilung;
    }

    public Protokoll getProtokoll() {
        return this.protokoll;
    }

    public Storno getStorno() {
        return this.storno;
    }

    public Protokoll getStornoProtokoll() {
        return this.stornoProtokoll;
    }

    public void setKontrollmitteilung(Kontrollmitteilung kontrollmitteilung) {
        this.kontrollmitteilung = kontrollmitteilung;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public static enum State {
        EDIT,
        SEND,
        ACCEPTED,
        FINISHED,
        STORNO_SEND,
        CANCELED;

    }

    public static class Content
    implements Comparable<Content> {
        public String name;
        public State state;
        public boolean deleted;
        public String transferTicket;
        public List<String> transferTickets;
        public String sendDate;
        public String stornoSendDate;
        public String kontrollmitteilung;
        public String kontrollmitteilungResponse;
        public String request;
        public String requestResponse;
        public String receive;
        public String receiveResponse;
        public String protokoll;
        public String storno;
        public String stornoTransferTicket;
        public List<String> stornoTransferTickets;
        public String stornoResponse;
        public String stornoRequest;
        public String stornoRequestResponse;
        public String stornoReceive;
        public String stornoReceiveResponse;
        public String stornoProtokoll;

        public Content(String name, State state, boolean deleted, String transferTicket, List<String> transferTickets, String sendDate, String stornoSendDate, String kontrollmitteilung, String kontrollmitteilungResponse, String request, String requestResponse, String receive, String receiveResponse, String protokoll, String storno, String stornoTransferTicket, List<String> stornoTransferTickets, String stornoResponse, String stornoRequest, String stornoRequestResponse, String stornoReceive, String stornoReceiveResponse, String stornoProtokoll) {
            this.name = name;
            this.state = state;
            this.deleted = deleted;
            this.transferTicket = transferTicket;
            this.transferTickets = new ArrayList<String>(transferTickets);
            this.sendDate = sendDate;
            this.stornoSendDate = stornoSendDate;
            this.kontrollmitteilung = kontrollmitteilung;
            this.kontrollmitteilungResponse = kontrollmitteilungResponse;
            this.request = request;
            this.requestResponse = requestResponse;
            this.receive = receive;
            this.receiveResponse = receiveResponse;
            this.protokoll = protokoll;
            this.storno = storno;
            this.stornoTransferTicket = stornoTransferTicket;
            this.stornoTransferTickets = new ArrayList<String>(stornoTransferTickets);
            this.stornoResponse = stornoResponse;
            this.stornoRequest = stornoRequest;
            this.stornoRequestResponse = stornoRequestResponse;
            this.stornoReceive = stornoReceive;
            this.stornoReceiveResponse = stornoReceiveResponse;
            this.stornoProtokoll = stornoProtokoll;
        }

        Content() {
            this.transferTickets = new ArrayList<String>();
            this.stornoTransferTickets = new ArrayList<String>();
        }

        @Override
        public int compareTo(Content o) {
            return this.name.compareTo(o.name);
        }
    }

    public static class Result {
        private final String transferTicket;
        private final boolean successful;
        private final List<String> messages = new ArrayList<String>();
        private final List<String> values = new ArrayList<String>();
        private final Map<String, URL> actions = new HashMap<String, URL>();

        public static Result success() {
            return new Result(true);
        }

        public static Result success(String transferTicket) {
            return new Result(true, transferTicket);
        }

        public static Result success(List<String> ids) {
            return new Result(true, null, ids);
        }

        public static Result successPair(List<Pair<String, String>> werte) {
            return new Result(true, null, werte, 0);
        }

        public static Result failure(String message) {
            Result result = new Result(false, null);
            result.messages.add(message);
            return result;
        }

        public static Result failure(EricBearbeiteVorgang returnBuffer) {
            Result result = new Result(false);
            for (JAXBElement<?> element : returnBuffer.getContent()) {
                if (!"FehlerRegelpruefung".equals(element.getName().getLocalPart())) continue;
                FehlerRegelpruefungTyp fehler = (FehlerRegelpruefungTyp)element.getValue();
                result.messages.add(fehler.getText());
            }
            return result;
        }

        public static Result failure(ElsterXml serverResult) {
            Result result = new Result(false, serverResult.getTransferTicket());
            serverResult.getTransferHeaderError().ifPresent(result.messages::add);
            result.messages.addAll(serverResult.getNutzdatenErrors());
            return result;
        }

        public static Result fromVorgangResult(Eric.VorgangResult result, String title) throws MalformedURLException {
            ElsterXml answer = result.getServerAnswer();
            switch (result.getRc()) {
                case 0: {
                    return Result.success();
                }
                case 610001002: {
                    return Result.failure(result.getReturnBuffer());
                }
                case 610101210: {
                    Optional<Pair<String, String>> error;
                    if (answer != null && (error = answer.getTransferHeaderErrors()).isPresent() && "010015008".equals(error.get().getKey())) {
                        return new Result(false, List.of(title + ": Die vorliegende Version der Flutopferhilfen-Mitteilung ist veraltet und muss aktualisiert werden. Sie finden die aktuellste Version auf https://esteuer.de oder https://forum.elster.de."), Map.of("esteuer.de", new URL("https://www.esteuer.de/#kmv#berichtigte-steuerbescheinigungen"), "Anwenderforum", new URL("https://forum.elster.de/anwenderforum/forum/elster-programme/mitteilung-anwendungen-von-elster")));
                    }
                }
                case 610101292: {
                    if (answer != null) {
                        return Result.failure(answer);
                    }
                    return Result.failure(result.getReturnBuffer());
                }
                case 610201106: 
                case 610201107: 
                case 610201113: 
                case 610201114: 
                case 610201115: 
                case 610201116: 
                case 610201205: {
                    return Result.failure(title + ": Das Zertifikatspasswort ist nicht korrekt");
                }
                case 610101284: {
                    return Result.failure(title + ": Der Port zum Proxy-Server ist nicht korrekt");
                }
                case 610101276: {
                    return Result.failure(title + ": Es konnte keine Verbindung zum Proxy-Server aufgebaut werden");
                }
                case 610101280: {
                    return Result.failure(title + ": Die Anmeldedaten f\u00fcr den Proxy-Server sind nicht korrekt");
                }
                case 610101278: {
                    return Result.failure(title + ": Es konnte keine Verbindung zum Server aufgebaut werden");
                }
                case 610101283: {
                    return Result.failure(title + ": Es kam zu einer Zeit\u00fcberschreitung bei der Kommunikation mit dem Server. M\u00f6glicherweise muss eine Firewall oder ein Proxy konfiguriert werden.\n\nEin Proxy kann \u00fcber die Anwendung \u201eBSB-Mitteilung\u201c im Dialog \u201eEinstellungen\u201c, Abschnitt \u201eProxy-Konfiguration\u201c eingestellt werden. Die Adressen des Proxys muss Ihnen Ihre IT-Administration mitteilen.\n\nEine Firewall-Freischaltung muss von Ihrer IT-Administration vorgenommen werden. Es m\u00fcssen folgende Adressen freigeschaltet sein:\n\nAdressen:\n \u2022 datenannahme1.elster.de\n \u2022 datenannahme2.elster.de\n \u2022 datenannahme3.elster.de\n \u2022 datenannahme4.elster.de\n \u2022 objektspeicher.elster.de\nPort:\n \u2022 443\nProtokoll:\n \u2022 https\n");
                }
            }
            return Result.failure(title + ": Es wurde der Fehlercode " + result.getRc() + " gemeldet. Bitte wenden Sie sich an den Support der Flutopferhilfen-Mitteilung.");
        }

        private Result(boolean successful) {
            this(successful, null);
        }

        private Result(boolean successful, String transferTicket) {
            this(successful, transferTicket, Collections.emptyList());
        }

        private Result(boolean successful, String transferTicket, List<String> messages) {
            this.successful = successful;
            this.transferTicket = transferTicket;
            this.messages.addAll(messages);
        }

        private Result(boolean successful, List<String> messages, Map<String, URL> actions) {
            this.successful = successful;
            this.transferTicket = "";
            this.messages.addAll(messages);
            this.actions.putAll(actions);
        }

        public Result(boolean successful, String transferTicket, List<Pair<String, String>> ids, int zusatz) {
            this.successful = successful;
            this.transferTicket = transferTicket;
            for (Pair<String, String> element : ids) {
                this.messages.add(element.getKey());
                this.values.add(element.getValue());
            }
        }

        public List<String> getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public List<String> getMessages() {
            return Collections.unmodifiableList(this.messages);
        }

        public boolean wasSuccessful() {
            return this.successful;
        }

        public String getTransferTicket() {
            return this.transferTicket;
        }
    }
}

