/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.model;

import java.util.Optional;

public enum Bundesland {
    BY("9", "BY", "Bayern"),
    NW("5", "NW", "Nordrhein-Westfalen"),
    RP("27", "RP", "Rheinland-Pfalz"),
    ST("31", "ST", "Sachsen-Anhalt"),
    BW("28", "BW", "Baden-W\u00fcrttemberg"),
    BE("11", "BE", "Berlin"),
    BB("30", "BB", "Brandenburg"),
    HB("24", "HB", "Bremen"),
    HH("22", "HH", "Hamburg"),
    HE("26", "HE", "Hessen"),
    MV("40", "MV", "Mecklenburg-Vorpommern"),
    NI("23", "NI", "Niedersachsen"),
    SL("10", "SL", "Saarland"),
    SN("32", "SN", "Sachsen"),
    SH("21", "SH", "Schleswig-Holstein"),
    TH("41", "TH", "Th\u00fcringen");

    private final String num;
    private final String kuerzel;
    private final String name;

    private Bundesland(String num, String kuerzel, String name) {
        this.num = num;
        this.kuerzel = kuerzel;
        this.name = name;
    }

    public static Optional<Bundesland> getBundeslandFromElsterSteuernummer(String elsterSteuernummer) {
        if (elsterSteuernummer != null) {
            for (Bundesland item : Bundesland.values()) {
                if (item.num == null || !elsterSteuernummer.startsWith(item.num)) continue;
                return Optional.of(item);
            }
        }
        return Optional.empty();
    }

    public static Optional<Bundesland> getBundeslandFromKuerzel(String kuerzel) {
        if (kuerzel != null) {
            for (Bundesland item : Bundesland.values()) {
                if (!kuerzel.equals(item.kuerzel)) continue;
                return Optional.of(item);
            }
        }
        return Optional.empty();
    }

    public Optional<String> getLaendernummer(String bescheidSteuernummer) {
        if (this.num != null) {
            if (this.num.length() >= 2) {
                return Optional.of(this.num.substring(0, 2));
            }
            if (bescheidSteuernummer != null && !bescheidSteuernummer.isEmpty()) {
                return Optional.of(this.num + bescheidSteuernummer.charAt(0));
            }
        }
        return Optional.empty();
    }

    public String toString() {
        return this.name;
    }

    public String getKuerzel() {
        return this.kuerzel;
    }
}

