/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui.utils;

import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.util.converter.LocalDateStringConverter;

public interface Validator<T> {
    public Optional<String> validate(T var1, String var2);

    public static Validator<Object> maxLength(int max, String message) {
        return (v, s) -> s.length() > max ? Optional.of(message) : Optional.empty();
    }

    public static Function<String, Optional<String>> maxLength2(int max, String message) {
        return s -> s != null && s.length() > max ? Optional.of(message) : Optional.empty();
    }

    public static Validator<Object> minLength(int min, String message) {
        return (v, s) -> !s.isEmpty() && s.length() < min ? Optional.of(message) : Optional.empty();
    }

    public static Function<String, Optional<String>> minLength2(int min, String message) {
        return s -> s != null && !s.isEmpty() && s.length() < min ? Optional.of(message) : Optional.empty();
    }

    public static Validator<Object> forPattern(final String pattern, final String message) {
        return new Validator<Object>(){
            private final Pattern p;
            {
                this.p = Pattern.compile(pattern);
            }

            @Override
            public Optional<String> validate(Object value, String content) {
                if (!content.isEmpty() && !this.p.matcher(content).matches()) {
                    return Optional.of(message);
                }
                return Optional.empty();
            }
        };
    }

    public static Function<String, Optional<String>> forPattern2(final String pattern, final String message) {
        return new Function<String, Optional<String>>(){
            private final Pattern p;
            {
                this.p = Pattern.compile(pattern);
            }

            @Override
            public Optional<String> apply(String content) {
                if (content != null && !content.isEmpty() && !this.p.matcher(content).matches()) {
                    return Optional.of(message);
                }
                return Optional.empty();
            }
        };
    }

    public static Validator<Object> forPredicate(Predicate<String> predicate, String message) {
        return (v, s) -> !s.isEmpty() && !predicate.test(s) ? Optional.of(message) : Optional.empty();
    }

    public static Function<String, Optional<String>> forPredicate2(Predicate<String> predicate, String message) {
        return s -> s != null && !s.isEmpty() && !predicate.test((String)s) ? Optional.of(message) : Optional.empty();
    }

    public static Function<String, Optional<String>> forDate() {
        return new Function<String, Optional<String>>(){
            private final Pattern p = Pattern.compile("[0-9]{2}\\.[0-9]{2}\\.[0-9]{4}");
            private final LocalDateStringConverter converter = new LocalDateStringConverter(FormatStyle.SHORT);

            @Override
            public Optional<String> apply(String content) {
                if (content != null && !content.isEmpty()) {
                    if (!this.p.matcher(content).matches()) {
                        return Optional.of("Das Datum muss im Format tt.mm.jjjj sein");
                    }
                    try {
                        this.converter.fromString(content);
                    }
                    catch (DateTimeParseException ignore) {
                        return Optional.of("Das eingegebene Datum ist nicht g\u00fcltig");
                    }
                }
                return Optional.empty();
            }
        };
    }
}

