/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui.utils;

import de.elster.flutopferhilfen.gui.utils.Formatter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

class TimestampFormatter
implements Formatter<String> {
    private final DateTimeFormatter parser;
    private final DateTimeFormatter formatter;

    public TimestampFormatter(String parsedPattern, String displayPattern) {
        this.parser = DateTimeFormatter.ofPattern(parsedPattern);
        this.formatter = DateTimeFormatter.ofPattern(displayPattern);
    }

    @Override
    public String format(String value) {
        if (value != null) {
            LocalDateTime parsed = LocalDateTime.parse(value, this.parser);
            return parsed.format(this.formatter);
        }
        return "";
    }

    @Override
    public String parse(String value) {
        if (!value.isEmpty()) {
            LocalDateTime parsed = LocalDateTime.parse(value, this.formatter);
            return parsed.format(this.parser);
        }
        return null;
    }
}

