/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Staat {
    private static final Map<String, String> VALUES;
    private final String key;
    private final String value;

    public Staat(String key) {
        this.key = key;
        this.value = VALUES.get(key);
    }

    public String toString() {
        return this.key + " " + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Staat other = (Staat)o;
        return Objects.equals(this.key, other.key);
    }

    public String getKey() {
        return this.key;
    }

    public static List<Staat> values() {
        return VALUES.keySet().stream().sorted(Comparator.naturalOrder()).map(Staat::new).collect(Collectors.toList());
    }

    static {
        HashMap<String, String> map;
        InputStream nationalitaeten = Staat.class.getResourceAsStream("nationalitaeten.csv");
        if (nationalitaeten != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(nationalitaeten));
            map = new HashMap<String, String>();
            while (true) {
                String[] values;
                String line;
                try {
                    line = reader.readLine();
                }
                catch (IOException e) {
                    throw new RuntimeException("Konnte Zeile aus Datei mit Nationalit\u00e4ten nicht einlesen");
                }
                if (line == null) break;
                if ((line = line.trim()).startsWith("#") || line.isEmpty() || (values = line.split(";")).length != 2) continue;
                String key = values[0];
                String name = values[1];
                map.put(key, name);
            }
        } else {
            throw new RuntimeException("Datei mit Nationalit\u00e4ten konnte nicht geladen werden");
        }
        VALUES = Collections.unmodifiableMap(map);
    }
}

