/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Nationalitaeten {
    private static final Nationalitaeten INSTANCE = new Nationalitaeten();
    private static final String EMPTY_VALUE = "<Leer>";
    private final List<String> displayNames;
    private final List<String> rawDisplayNames;
    private final Map<String, Integer> keyToIndex = new HashMap<String, Integer>();

    public static Nationalitaeten getInstance() {
        return INSTANCE;
    }

    private Nationalitaeten() {
        ArrayList<CallSite> rawDisplayNames;
        ArrayList<Object> displayNames;
        InputStream nationalitaeten = this.getClass().getResourceAsStream("nationalitaeten.csv");
        if (nationalitaeten != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(nationalitaeten));
            ArrayList<String> names = new ArrayList<String>();
            displayNames = new ArrayList<Object>();
            rawDisplayNames = new ArrayList<CallSite>();
            displayNames.add(EMPTY_VALUE);
            while (true) {
                String[] values;
                String line;
                try {
                    line = reader.readLine();
                }
                catch (IOException e) {
                    throw new RuntimeException("Konnte Zeile aus Datei mit Nationalit\u00e4ten nicht einlesen");
                }
                if (line == null) break;
                if ((line = line.trim()).startsWith("#") || line.isEmpty() || (values = line.split(";")).length != 2) continue;
                String key = values[0];
                String name = values[1];
                this.keyToIndex.put(key, names.size());
                names.add(name);
                displayNames.add(key + " " + name);
                rawDisplayNames.add((CallSite)((Object)(key + " " + name)));
            }
        } else {
            throw new RuntimeException("Datei mit Nationalit\u00e4ten konnte nicht geladen werden");
        }
        this.displayNames = Collections.unmodifiableList(displayNames);
        this.rawDisplayNames = Collections.unmodifiableList(rawDisplayNames);
    }

    public Optional<Integer> getIndexOfKey(String key) {
        return Optional.ofNullable(this.keyToIndex.get(key)).map(x -> x + 1);
    }

    public Optional<String> getKeyOfDisplayName(String displayName) {
        String key;
        if (!displayName.equals(EMPTY_VALUE) && displayName.length() >= 3 && this.keyToIndex.containsKey(key = displayName.substring(0, 3))) {
            return Optional.of(key);
        }
        return Optional.empty();
    }

    public int getEmptyValueIndex() {
        return 0;
    }

    public List<String> getDisplayNames() {
        return this.displayNames;
    }

    public List<String> getRawDisplayNames() {
        return this.rawDisplayNames;
    }
}

