/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui.utils;

import de.elster.flutopferhilfen.gui.utils.DateFormatter;
import de.elster.flutopferhilfen.gui.utils.DateTimeFormatter;
import de.elster.flutopferhilfen.gui.utils.EuroFormatter;
import de.elster.flutopferhilfen.gui.utils.IBANFormatter;
import de.elster.flutopferhilfen.gui.utils.IdentityFormatter;
import de.elster.flutopferhilfen.gui.utils.TimestampFormatter;
import de.elster.flutopferhilfen.gui.utils.YearFormatter;
import de.finkonsens.rms.kmv.base.v6.AdresseCType;
import de.finkonsens.rms.kmv.base.v6.MaxAdresseCType;
import java.time.LocalDate;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;

public interface Formatter<T> {
    public static final Pattern XML_DATUM = Pattern.compile("([0-9]{4})([0-9]{2})([0-9]{2})");
    public static final Pattern DISPLAY_DATUM = Pattern.compile("([0-9]{2})\\.([0-9]{2})\\.([0-9]{4})");

    public String format(T var1);

    public T parse(String var1);

    public static Formatter<String> forTimestamps() {
        return new TimestampFormatter("uuuuMMddkkmmss", "dd.MM.yyyy kk:mm:ss");
    }

    public static Formatter<String> forDateTime() {
        return new DateTimeFormatter();
    }

    public static IBANFormatter forIBAN() {
        return new IBANFormatter();
    }

    public static Formatter<LocalDate> forDate() {
        return new DateFormatter();
    }

    public static EuroFormatter forEuroBetrag() {
        return new EuroFormatter();
    }

    public static Formatter<XMLGregorianCalendar> forYear() {
        return new YearFormatter();
    }

    public static Formatter<String> identity() {
        return new IdentityFormatter();
    }

    public static AdresseCType mapAdresse(MaxAdresseCType value) {
        if (value != null) {
            AdresseCType result = new AdresseCType();
            Optional<MaxAdresseCType> input = Optional.of(value);
            result.setStrAdresse(input.map(MaxAdresseCType::getStrAdresse).orElse(null));
            result.setPostfachAdresse(input.map(MaxAdresseCType::getPostfachAdresse).orElse(null));
            result.setGKAdresse(input.map(MaxAdresseCType::getGKAdresse).orElse(null));
            return result;
        }
        return null;
    }

    public static String mapEmptyToNull(String value) {
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        return null;
    }

    public static String convertToXml(String value) {
        if (value != null && !value.isEmpty()) {
            Matcher matcher = DISPLAY_DATUM.matcher(value);
            if (matcher.matches()) {
                return matcher.group(3) + matcher.group(2) + matcher.group(1);
            }
            return value;
        }
        return null;
    }

    public static String convertFromXml(String value) {
        if (value != null && !value.isEmpty()) {
            Matcher matcher = XML_DATUM.matcher(value);
            if (matcher.matches()) {
                return matcher.group(3) + "." + matcher.group(2) + "." + matcher.group(1);
            }
            return value;
        }
        return null;
    }

    public static String formatIBAN(String value) {
        if (value != null) {
            StringBuilder sb = new StringBuilder();
            for (int pos = 0; pos < value.length(); pos += 4) {
                int end = Math.min(pos + 4, value.length());
                sb.append(value, pos, end);
                sb.append(' ');
            }
            return sb.toString().trim();
        }
        return null;
    }

    public static String unformatIBAN(String value) {
        if (value != null) {
            return value.replace(" ", "");
        }
        return null;
    }

    public static String formatEuro(String value) {
        if (value != null) {
            return value.replace('.', ',');
        }
        return null;
    }

    public static String unformatEuro(String value) {
        if (value != null) {
            return value.replace(',', '.');
        }
        return null;
    }
}

