/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui.utils;

import de.elster.flutopferhilfen.gui.utils.Icons;
import de.elster.flutopferhilfen.gui.utils.Identifier;
import de.elster.flutopferhilfen.gui.utils.Style;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;

public class Form<T> {
    private final String title;
    private final Supplier<T> constructor;
    private final LinkedHashMap<String, Field<T, ?, ?>> fields = new LinkedHashMap();

    private Form(String title, Supplier<T> constructor) {
        this.title = title;
        this.constructor = constructor;
    }

    @SafeVarargs
    public static <T> Form<T> of(Supplier<T> constructor, FieldBuilder<T, ?, ?> ... fields) {
        return Form.of(null, constructor, fields);
    }

    @SafeVarargs
    public static <T> Form<T> of(String title, Supplier<T> constructor, FieldBuilder<T, ?, ?> ... fields) {
        Form<T> result = new Form<T>(title, constructor);
        for (FieldBuilder<T, ?, ?> field : fields) {
            result.add(field.build());
        }
        return result;
    }

    @SafeVarargs
    public static Form<Empty> of(String title, FieldBuilder<Empty, ?, ?> ... fields) {
        Form<Empty> result = Form.of(title, Empty::new, fields);
        result.load(new Empty());
        return result;
    }

    public static FieldBuilder<Empty, String, ?> withText(String label, String value) {
        return new FieldBuilder(new StringField<Empty>(label, v -> value, (v, s) -> {}));
    }

    public static FieldBuilder<Empty, String, ?> withMultilineText(String label, String value) {
        return new FieldBuilder(new MultilineStringField<Empty>(label, 5, v -> value, (v, s) -> {}));
    }

    public static <T> FieldBuilder<T, String, ?> withMultilineText(String label, int rows, Function<T, String> getter, BiConsumer<T, String> setter) {
        return new FieldBuilder(new MultilineStringField<T>(label, rows, getter, setter));
    }

    public static <T> FieldBuilder<T, String, ?> withText(String label, Function<T, String> getter, BiConsumer<T, String> setter) {
        return new FieldBuilder(new StringField<T>(label, getter, setter));
    }

    public static <T, V> FieldBuilder<T, V, ?> withChoice(String label, List<V> items, Function<T, V> getter, BiConsumer<T, V> setter) {
        return new FieldBuilder(new ChoiceField<T, V>(label, items, getter, setter));
    }

    public static <T> FieldBuilder<T, String, ?> withDate(String label, Function<T, String> getter, BiConsumer<T, String> setter) {
        return new FieldBuilder(new DateField<T>(label, getter, setter));
    }

    private void add(Field<T, ?, ?> field) {
        this.fields.put(Identifier.toIdentifier(field.getTitle()), field);
    }

    public Node render() {
        return this.render(-1.0);
    }

    public Node render(double minLabelWidth) {
        GridPane form = new GridPane();
        form.getStyleClass().add("form");
        ColumnConstraints labelColumn = new ColumnConstraints();
        labelColumn.setHgrow(Priority.NEVER);
        if (minLabelWidth != -1.0) {
            labelColumn.setMinWidth(minLabelWidth);
        }
        ColumnConstraints fieldColumn = new ColumnConstraints();
        fieldColumn.setHgrow(Priority.ALWAYS);
        ColumnConstraints helpColumn = new ColumnConstraints();
        helpColumn.setHgrow(Priority.NEVER);
        form.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{labelColumn, fieldColumn, helpColumn});
        boolean hasHelp = this.fields.values().stream().anyMatch(Field::hasHelp);
        for (Field<T, ?, ?> field : this.fields.values()) {
            int next = form.getRowCount();
            field.render(form, next, hasHelp);
        }
        if (this.title != null) {
            TitledPane titledPane = new TitledPane(this.title, form);
            titledPane.setCollapsible(false);
            titledPane.getStyleClass().add("titled-form-container");
            return titledPane;
        }
        StackPane pane = new StackPane(form);
        pane.getStyleClass().add("untitled-form-container");
        return pane;
    }

    public T save() {
        T destination = this.constructor.get();
        return (T)(this.saveInto(destination) ? destination : null);
    }

    public boolean saveInto(T destination) {
        boolean filled = false;
        for (Field<T, ?, ?> field : this.fields.values()) {
            field.resetMessages();
            if (field.saveInto(destination)) {
                filled = true;
            }
            field.changed(false);
        }
        return filled;
    }

    public boolean validate() {
        boolean valid = true;
        for (Field<T, ?, ?> field : this.fields.values()) {
            if (field.validate()) continue;
            valid = false;
        }
        return valid;
    }

    public void load(T source) {
        for (Field<T, ?, ?> field : this.fields.values()) {
            field.resetMessages();
            field.load(source);
            field.changed(false);
        }
    }

    public boolean isEmpty() {
        for (Field<T, ?, ?> field : this.fields.values()) {
            if (field.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(String id) {
        return this.fields.get(id).isEmpty();
    }

    public boolean hasChanged() {
        return this.fields.values().stream().anyMatch(Field::hasChanged);
    }

    public <V> V getValue(String id, Class<V> c) {
        return c.cast(this.fields.get(id).getValue());
    }

    public void addErrorMessage(String id, String message) {
        this.fields.get(id).addErrorMessage(message);
    }

    public static class FieldBuilder<T, V, C extends Node> {
        private final Field<T, V, C> start;

        public FieldBuilder(Field<T, V, C> start) {
            this.start = start;
        }

        public FieldBuilder<T, V, C> validate(Function<V, Optional<String>> validator) {
            this.start.addValidator(validator);
            return this;
        }

        public FieldBuilder<T, V, C> required(String message) {
            return this.required(true, message);
        }

        public FieldBuilder<T, V, C> required(boolean required, String message) {
            if (required) {
                this.start.setRequired(message);
            }
            return this;
        }

        public FieldBuilder<T, V, C> remainingCounter(int max) {
            this.start.setRemainingCounter(true, max);
            return this;
        }

        public FieldBuilder<T, V, C> help(String help) {
            if (help != null) {
                this.start.setHelp(help);
            }
            return this;
        }

        public FieldBuilder<T, V, C> monospaced() {
            this.start.setMonospaced(true);
            return this;
        }

        public FieldBuilder<T, V, C> readonly() {
            this.start.readonly();
            return this;
        }

        public Field<T, V, C> build() {
            return this.start;
        }
    }

    private static abstract class Field<T, V, C extends Node> {
        private String title;
        private final C field;
        private Label remainingCounter;
        private String help;
        private final VBox messages;
        private Label helpLabel;
        private boolean changed;
        private final List<Function<V, Optional<String>>> validators = new ArrayList<Function<V, Optional<String>>>();
        private String required;

        protected Field(String title, C field) {
            this.title = title;
            this.field = field;
            ((Node)this.field).getStyleClass().add("field");
            ((Node)this.field).setId(Identifier.toIdentifier(title));
            this.remainingCounter = null;
            this.messages = new VBox();
            this.messages.setFillWidth(true);
            this.helpLabel = null;
            this.changed = false;
        }

        protected void render(GridPane destination, int row, boolean hasHelp) {
            int current_row = row;
            destination.add(new Label(this.title), 0, current_row);
            if (hasHelp) {
                destination.add((Node)this.field, 1, current_row);
                if (this.help != null) {
                    StackPane pane = new StackPane(Icons.getQuestionCircle());
                    pane.setOnMouseClicked(e -> this.showHelp());
                    pane.setAlignment(Pos.CENTER);
                    pane.setCursor(Cursor.HAND);
                    destination.add(pane, 2, current_row);
                }
            } else {
                destination.add((Node)this.field, 1, current_row, 2, 1);
            }
            if (this.remainingCounter != null) {
                destination.add(this.remainingCounter, 1, ++current_row);
                GridPane.setHalignment(this.remainingCounter, HPos.RIGHT);
            }
            destination.add(this.messages, 1, ++current_row);
            this.resetMessages();
        }

        protected void addErrorMessage(String message) {
            Label label = new Label(message);
            label.setGraphic(Icons.getExclamationTriangle());
            label.getStyleClass().add("error");
            label.setWrapText(true);
            label.setMinHeight(Double.NEGATIVE_INFINITY);
            this.messages.getChildren().add(label);
            ((Node)this.field).pseudoClassStateChanged(Style.INVALID, true);
        }

        private void showHelp() {
            if (this.helpLabel == null) {
                this.helpLabel = new Label(this.help);
                this.helpLabel.getStyleClass().add("help");
                this.helpLabel.setGraphic(Icons.getInfo());
                this.helpLabel.setWrapText(true);
                this.helpLabel.setMinHeight(Double.NEGATIVE_INFINITY);
                this.messages.getChildren().add(this.helpLabel);
            } else {
                this.messages.getChildren().remove(this.helpLabel);
                this.helpLabel = null;
            }
        }

        public void setHelp(String help) {
            this.help = help;
        }

        protected void resetMessages() {
            this.messages.getChildren().clear();
            this.helpLabel = null;
            ((Node)this.field).pseudoClassStateChanged(Style.INVALID, false);
        }

        protected void changed(boolean changed) {
            ((Node)this.field).pseudoClassStateChanged(Style.CHANGED, changed);
            this.changed = changed;
        }

        abstract V getValue();

        abstract void load(T var1);

        abstract boolean saveInto(T var1);

        abstract void readonly();

        abstract void setChangeListener(Consumer<String> var1);

        public boolean validate() {
            this.resetMessages();
            boolean valid = true;
            if (this.required != null && this.isEmpty()) {
                this.addErrorMessage(this.required);
                valid = false;
            }
            V content = this.getValue();
            for (Function<V, Optional<String>> validator : this.validators) {
                Optional<String> result = validator.apply(content);
                if (!result.isPresent()) continue;
                this.addErrorMessage(result.get());
                valid = false;
            }
            return valid;
        }

        public boolean isEmpty() {
            return this.getValue() == null;
        }

        public boolean hasChanged() {
            return this.changed;
        }

        public void addValidator(Function<V, Optional<String>> validator) {
            this.validators.add(validator);
        }

        public void setRequired(String message) {
            if (!this.title.endsWith("*")) {
                this.title = this.title + "*";
            }
            this.required = message;
        }

        public void setRemainingCounter(boolean value, int max) {
            if (value) {
                this.remainingCounter = new Label("0/" + max);
                this.setChangeListener(s -> {
                    int len = s.length();
                    this.remainingCounter.setText(len + "/" + max);
                    this.remainingCounter.pseudoClassStateChanged(Style.INVALID, len > max);
                });
            } else {
                this.remainingCounter = null;
            }
        }

        public C getField() {
            return this.field;
        }

        public boolean hasHelp() {
            return this.help != null;
        }

        public void setMonospaced(boolean b) {
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class Empty {
    }

    private static class StringField<T>
    extends Field<T, String, TextField> {
        private final Function<T, String> getter;
        private final BiConsumer<T, String> setter;

        public StringField(String title, Function<T, String> getter, BiConsumer<T, String> setter) {
            super(title, new TextField());
            this.getter = getter;
            this.setter = setter;
            ((TextField)this.getField()).textProperty().addListener(o -> this.changed(true));
        }

        @Override
        public String getValue() {
            String text = ((TextField)this.getField()).getText().trim();
            return !text.isEmpty() ? text : null;
        }

        @Override
        public void load(T source) {
            String content = source != null ? this.getter.apply(source) : null;
            ((TextField)this.getField()).setText(content != null ? content : "");
        }

        @Override
        public boolean saveInto(T destination) {
            String content = this.getValue();
            this.setter.accept(destination, content);
            return content != null;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() || ((TextField)this.getField()).getText().isEmpty();
        }

        @Override
        public void readonly() {
            ((TextField)this.getField()).setEditable(false);
        }

        @Override
        void setChangeListener(Consumer<String> listener) {
            ((TextField)this.getField()).textProperty().addListener((observableValue, oldValue, newValue) -> listener.accept((String)newValue));
        }

        @Override
        public void setMonospaced(boolean monospaced) {
            if (monospaced) {
                TextField field = (TextField)this.getField();
                Font origin = field.getFont();
                Font next = Font.font("Consolas", origin.getSize());
                field.setFont(next);
            }
        }
    }

    private static class MultilineStringField<T>
    extends Field<T, String, TextArea> {
        private final Function<T, String> getter;
        private final BiConsumer<T, String> setter;

        public MultilineStringField(String title, int rows, Function<T, String> getter, BiConsumer<T, String> setter) {
            super(title, new TextArea());
            this.getter = getter;
            this.setter = setter;
            TextArea field = (TextArea)this.getField();
            field.setWrapText(true);
            field.setPrefRowCount(rows);
            field.textProperty().addListener(o -> this.changed(true));
        }

        @Override
        public String getValue() {
            String text = ((TextArea)this.getField()).getText().trim();
            return !text.isEmpty() ? text : null;
        }

        @Override
        public void load(T source) {
            String content = source != null ? this.getter.apply(source) : null;
            ((TextArea)this.getField()).setText(content != null ? content : "");
        }

        @Override
        public boolean saveInto(T destination) {
            String content = this.getValue();
            this.setter.accept(destination, content);
            return content != null;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() || ((TextArea)this.getField()).getText().isEmpty();
        }

        @Override
        public void readonly() {
            ((TextArea)this.getField()).setEditable(false);
        }

        @Override
        public void setMonospaced(boolean monospaced) {
            if (monospaced) {
                TextArea field = (TextArea)this.getField();
                Font origin = field.getFont();
                Font next = Font.font("Consolas", origin.getSize());
                field.setFont(next);
            }
        }

        @Override
        void setChangeListener(Consumer<String> listener) {
            ((TextArea)this.getField()).textProperty().addListener((observableValue, oldValue, newValue) -> listener.accept((String)newValue));
        }
    }

    private static class ChoiceField<T, V>
    extends Field<T, V, ComboBox<String>> {
        private final List<V> items;
        private final Function<T, V> getter;
        private final BiConsumer<T, V> setter;

        private static <V> ObservableList<String> getDisplayValues(List<V> items) {
            ObservableList<String> display = FXCollections.observableArrayList(items.stream().map(Object::toString).collect(Collectors.toList()));
            display.add(0, "<Leer>");
            return display;
        }

        public ChoiceField(String title, List<V> items, Function<T, V> getter, BiConsumer<T, V> setter) {
            super(title, new ComboBox<String>(ChoiceField.getDisplayValues(items)));
            this.items = items;
            ComboBox choiceBox = (ComboBox)this.getField();
            choiceBox.setVisibleRowCount(10);
            SingleSelectionModel selectionModel = choiceBox.getSelectionModel();
            selectionModel.select(0);
            selectionModel.selectedIndexProperty().addListener(o -> this.changed(true));
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public V getValue() {
            int index = ((ComboBox)this.getField()).getSelectionModel().getSelectedIndex();
            if (index > 0) {
                return this.items.get(index - 1);
            }
            return null;
        }

        @Override
        public void load(T source) {
            Object content = source != null ? this.getter.apply(source) : null;
            ((ComboBox)this.getField()).getSelectionModel().select(content != null ? this.items.indexOf(content) + 1 : 0);
        }

        @Override
        public boolean saveInto(T destination) {
            V value = this.getValue();
            this.setter.accept(destination, value);
            return value != null;
        }

        @Override
        public void readonly() {
            ((ComboBox)this.getField()).setEditable(false);
        }

        @Override
        void setChangeListener(Consumer<String> listener) {
            throw new UnsupportedOperationException("Can't set change listener for choice fields");
        }
    }

    private static class DateField<T>
    extends Field<T, String, DatePicker> {
        private final Function<T, String> getter;
        private final BiConsumer<T, String> setter;

        private void unfocus(ObservableValue<? extends Boolean> o, Boolean old, Boolean next) {
            if (old.booleanValue() && !next.booleanValue()) {
                DatePicker field = (DatePicker)this.getField();
                LocalDate oldValue = (LocalDate)field.getValue();
                try {
                    LocalDate value = field.getConverter().fromString(field.getEditor().getText());
                    if (oldValue == null && value != null || oldValue != null && !oldValue.equals(value)) {
                        this.resetMessages();
                        field.setValue(value);
                    }
                }
                catch (DateTimeParseException ignore) {
                    this.resetMessages();
                    this.addErrorMessage("Das eingegebene Datum ist nicht g\u00fcltig");
                }
            }
        }

        public DateField(String title, Function<T, String> getter, BiConsumer<T, String> setter) {
            super(title, new DatePicker());
            this.getter = getter;
            this.setter = setter;
            DatePicker field = (DatePicker)this.getField();
            field.valueProperty().addListener(o -> this.changed(true));
            field.getEditor().setOnKeyPressed(e -> this.changed(true));
            field.focusedProperty().addListener(this::unfocus);
        }

        @Override
        public String getValue() {
            return ((DatePicker)this.getField()).getEditor().getText();
        }

        @Override
        public void load(T source) {
            DatePicker field = (DatePicker)this.getField();
            String value = this.getter.apply(source);
            try {
                if (source != null) {
                    LocalDate localDate = field.getConverter().fromString(value);
                    field.setValue(localDate);
                }
            }
            catch (DateTimeParseException ignore) {
                field.setValue(null);
                field.getEditor().setText(value);
            }
        }

        @Override
        public boolean saveInto(T destination) {
            String content = this.getValue();
            this.setter.accept(destination, content);
            return content != null && !content.isEmpty();
        }

        @Override
        public void readonly() {
            ((DatePicker)this.getField()).setEditable(false);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() || this.getValue().isEmpty();
        }

        @Override
        void setChangeListener(Consumer<String> listener) {
            throw new UnsupportedOperationException("Can't set change listener for date fields");
        }
    }

    public static interface Formatter<T> {
        public T parse(String var1);

        public String format(T var1);
    }
}

