/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui.utils;

import de.elster.flutopferhilfen.gui.utils.Formatter;
import de.elster.flutopferhilfen.gui.utils.Validator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeFormatter
implements Formatter<String> {
    private static final Pattern userFormat = Pattern.compile("(?<day>[0-9]{1,2})\\.(?<month>[0-9]{1,2})\\.(?<year>[0-9]{4})(?: (?<hour>[0-9]{1,2}):(?<minute>[0-9]{2})(?::(?<second>[0-9]{2}))?)?");
    private static final Pattern xmlFormat = Pattern.compile("(?<year>[0-9]{4})-(?<month>[0-9]{2})-(?<day>[0-9]{2})T(?<hour>[0-9]{2}):(?<minute>[0-9]{2}):(?<second>[0-9]{2})");

    public static Validator<Object> getValidator(String message) {
        return Validator.forPattern(userFormat.pattern(), message);
    }

    @Override
    public String format(String value) {
        Matcher matcher;
        if (value != null && (matcher = userFormat.matcher(value)).matches()) {
            StringBuilder result = new StringBuilder();
            String year = matcher.group("year");
            Object month = matcher.group("month");
            Object day = matcher.group("day");
            Object hour = DateTimeFormatter.optionalGroup(matcher, "hour");
            String minute = DateTimeFormatter.optionalGroup(matcher, "minute");
            String second = DateTimeFormatter.optionalGroup(matcher, "second");
            if (((String)month).length() < 2) {
                month = "0" + (String)month;
            }
            if (((String)day).length() < 2) {
                day = "0" + (String)day;
            }
            if (hour != null && ((String)hour).length() < 2) {
                hour = "0" + (String)hour;
            }
            result.append(year).append('-').append((String)month).append('-').append((String)day).append('T');
            if (hour != null || minute != null) {
                result.append((String)hour).append(':').append(minute).append(':').append(Objects.requireNonNullElse(second, "00"));
            } else {
                result.append("00:00:00");
            }
            return result.toString();
        }
        return value;
    }

    @Override
    public String parse(String value) {
        Matcher matcher;
        if (value != null && (matcher = xmlFormat.matcher(value)).matches()) {
            StringBuilder result = new StringBuilder();
            String year = matcher.group("year");
            String month = matcher.group("month");
            String day = matcher.group("day");
            String hour = matcher.group("hour");
            String minute = matcher.group("minute");
            String second = matcher.group("second");
            result.append(day).append('.').append(month).append('.').append(year).append(' ').append(hour).append(':').append(minute).append(':').append(second);
            return result.toString();
        }
        return value;
    }

    private static String optionalGroup(Matcher matcher, String group) {
        try {
            return matcher.group(group);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }
}

