/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxController;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.Formatter;
import de.elster.flutopferhilfen.gui.utils.Validator;
import de.finkonsens.rms.kmv.flh.v1.ZahlungFLHCType;
import java.util.ArrayList;
import java.util.List;

public class Zahlungen
implements ButtonBoxController {
    private final ButtonBox buttonBox;
    private final List<Zahlung> zahlungen = new ArrayList<Zahlung>();

    public Zahlungen(List<ZahlungFLHCType> value) {
        this.buttonBox = new ButtonBox(this, false, Type.values());
        this.load(value);
    }

    @Override
    public void onButtonClicked(ButtonBox buttonBox, ButtonEnum key) {
        if (Type.ZAHLUNG_HINZUFUEGEN.equals(key)) {
            this.addZahlung(null);
        }
    }

    @Override
    public void onContentRemoved(ButtonBoxNode node) {
        if (Type.ZAHLUNG_HINZUFUEGEN.equals(node.getKey())) {
            this.removeZahlung((Zahlung)node);
        }
    }

    public ButtonBox getButtonBox() {
        return this.buttonBox;
    }

    public void load(List<ZahlungFLHCType> value) {
        this.buttonBox.clearMessages();
        while (!this.zahlungen.isEmpty()) {
            this.buttonBox.removeContent(this.zahlungen.get(0));
        }
        if (value != null) {
            if (value.size() == 0) {
                this.addZahlung(new ZahlungFLHCType());
            } else {
                for (ZahlungFLHCType zahlung : value) {
                    this.addZahlung(zahlung);
                }
            }
        }
        if (this.zahlungen.size() == 0) {
            this.addZahlung(new ZahlungFLHCType());
        }
        this.buttonBox.setChanged(false);
    }

    private void addZahlung(ZahlungFLHCType value) {
        Zahlung next = new Zahlung(this.buttonBox, value);
        this.zahlungen.add(next);
        this.buttonBox.addContent(next);
    }

    private void removeZahlung(Zahlung zahlung) {
        this.zahlungen.remove(zahlung);
    }

    public List<ZahlungFLHCType> save() {
        ArrayList<ZahlungFLHCType> result = new ArrayList<ZahlungFLHCType>(this.zahlungen.size());
        for (Zahlung zahlung : this.zahlungen) {
            ZahlungFLHCType item = zahlung.save();
            if (item == null) continue;
            result.add(item);
        }
        this.buttonBox.setChanged(false);
        return result;
    }

    public boolean hasChanged() {
        boolean changed = this.buttonBox.hasChanged();
        for (Zahlung z : this.zahlungen) {
            changed = z.hasChanged() || changed;
        }
        return changed;
    }

    public String getMeldejahr() {
        if (!this.zahlungen.isEmpty()) {
            return this.zahlungen.get(0).getMeldejahr();
        }
        return null;
    }

    public boolean validate() {
        this.buttonBox.clearMessages();
        if (this.zahlungen.isEmpty()) {
            this.buttonBox.addErrorMessage("Es m\u00fcssen Angaben zu Zahlungen gemacht werden");
            return false;
        }
        boolean result = this.zahlungen.stream().allMatch(Zahlung::validate);
        if (result) {
            boolean equals;
            boolean bl = equals = this.zahlungen.stream().map(Zahlung::getMeldejahr).distinct().count() <= 1L;
            if (!equals) {
                this.buttonBox.addErrorMessage("Die Zahlungen m\u00fcssen alle das gleiche Jahr des Auszahlungsdatums haben.");
                return false;
            }
            return true;
        }
        return false;
    }

    private static enum Type implements ButtonEnum
    {
        ZAHLUNG_HINZUFUEGEN("Hinzuf\u00fcgen", "Leere Zahlung erg\u00e4nzen");

        private final String name;
        private final String beschreibung;

        private Type(String name, String beschreibung) {
            this.name = name;
            this.beschreibung = beschreibung;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getTooltip() {
            return this.beschreibung;
        }
    }

    private static class Zahlung
    extends ButtonBoxNode {
        private final Form<ZahlungFLHCType> form = Form.of(ZahlungFLHCType::new, Form.withDate("Auszahlungsdatum*", v -> v != null ? Formatter.convertFromXml(v.getDatum()) : null, (z, v) -> z.setDatum(Formatter.convertToXml(v))).help("Datum der Zahlungsanweisung").validate(Validator.forDate()).required("Das Datum der Auszahlung muss angegeben werden"), Form.withDate("Entstehungsdatum*", v -> v != null ? Formatter.convertFromXml(v.getEntstehung()) : null, (z, v) -> z.setEntstehung(Formatter.convertToXml(v))).help("Datum der Entstehung des Anspruchs").validate(Validator.forDate()).required("Das Datum der Entstehung des Anspruchs muss angegeben werden"), Form.withText("Betrag*", z -> Formatter.formatEuro(z.getBetrag()), (z, v) -> z.setBetrag(Formatter.unformatEuro(v))).required("Es muss ein Betrag zur Zahlung angegeben werden").help("R\u00fcckzahlungen sind als negative Betr\u00e4ge anzugeben.").validate(Validator.forPattern2("-?[0-9]{1,12},[0-9]{2}", "Der Betrag muss eine Zahl mit zwei Nachkommastellen sein und darf insgesamt h\u00f6chstens 15 Zeichen lang sein")).validate(Validator.forPredicate2(s -> !"0,00".equals(s), "Der Betrag darf nicht 0,00\u20ac sein")), Form.withText("Bewilligte Leistung*", z -> Formatter.formatEuro(z.getBewilligt()), (z, v) -> z.setBewilligt(Formatter.unformatEuro(v))).required("Die bewilligte Leistung muss angegeben werden").help("H\u00f6he der bewilligten Leistung in Euro").validate(Validator.forPattern2("[0-9]{1,12},[0-9]{2}", "Der Betrag muss eine Zahl mit zwei Nachkommastellen sein und darf insgesamt h\u00f6chstens 15 Zeichen lang sein")), Form.withText("Angerechnete Soforthilfen", z -> Formatter.formatEuro(z.getAnrechnung()), (z, v) -> z.setAnrechnung(Formatter.unformatEuro(v))).help("H\u00f6he der angerechneten Soforthilfen in Euro").validate(Validator.forPattern2("[0-9]{1,12},[0-9]{2}", "Der Betrag muss eine Zahl mit zwei Nachkommastellen sein und darf insgesamt h\u00f6chstens 15 Zeichen lang sein")));

        public Zahlung(ButtonBox buttonBox, ZahlungFLHCType value) {
            super(buttonBox, Type.ZAHLUNG_HINZUFUEGEN);
            this.form.load(value);
            this.setContent(this.form.render());
        }

        public ZahlungFLHCType save() {
            return this.form.save();
        }

        public String getMeldejahr() {
            String datum;
            ZahlungFLHCType content = this.save();
            if (content != null && (datum = content.getDatum()) != null && datum.length() >= 4) {
                return datum.substring(0, 4);
            }
            return null;
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean validate() {
            return this.form.validate();
        }
    }
}

