/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.BetroffenePerson;
import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxController;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.NNatPers;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.finkonsens.rms.kmv.base.v6.NichtNatuerlichePersonCType;
import de.finkonsens.rms.kmv.base.v6.PersonRolleSType;
import de.finkonsens.rms.kmv.base.v6.WeiterePersonCType;

public class WeiterePerson
implements ButtonBoxController {
    private NNatPers firma;
    private final Eric eric;
    private final ButtonBox buttonBox;

    public WeiterePerson(WeiterePersonCType value, Eric eric) {
        this.eric = eric;
        this.buttonBox = new ButtonBox(this, true, Type.values());
        this.buttonBox.addHelp("Handelt es sich bei der betroffenen Person um eine nat\u00fcrliche Person, k\u00f6nnen hier die Firmendaten, insbesondere der Firmenname, als nicht nat\u00fcrliche Person angegeben werden.");
        this.load(value);
    }

    public void load(WeiterePersonCType value) {
        this.buttonBox.clearMessages();
        if (this.firma != null) {
            this.buttonBox.removeContent(this.firma);
        }
        if (value != null && value.getNNatPers() != null) {
            this.addNNatPers(value.getNNatPers());
        }
        this.buttonBox.setChanged(false);
    }

    public WeiterePersonCType save() {
        this.buttonBox.setChanged(false);
        if (this.firma != null) {
            WeiterePersonCType result = new WeiterePersonCType();
            result.setRolle(PersonRolleSType.FI);
            result.setNNatPers(this.firma.save(null));
            return result;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.firma == null;
    }

    private void addNNatPers(NichtNatuerlichePersonCType value) {
        this.firma = new NNatPers(this.buttonBox, Type.FIRMA, value, true, false, false, null, this.eric);
        this.buttonBox.addContent(this.firma);
        this.buttonBox.disableButtons(true, Type.FIRMA);
    }

    public ButtonBox getButtonBox() {
        return this.buttonBox;
    }

    public Type getType() {
        if (this.firma != null) {
            return Type.FIRMA;
        }
        return null;
    }

    @Override
    public void onButtonClicked(ButtonBox buttonBox, ButtonEnum key) {
        if (Type.FIRMA.equals(key)) {
            this.addNNatPers(null);
        }
    }

    @Override
    public void onContentRemoved(ButtonBoxNode node) {
        if (Type.FIRMA.equals(node.getKey())) {
            this.removeNNatPers();
        }
    }

    public boolean hasChanged() {
        boolean change = this.buttonBox.hasChanged();
        if (this.firma != null) {
            change = change || this.firma.hasChanged();
        }
        return change;
    }

    private void removeNNatPers() {
        this.firma = null;
        this.buttonBox.disableButtons(false, Type.FIRMA);
    }

    public boolean validate(boolean optional, BetroffenePerson.Type betroffenePerson) {
        this.buttonBox.clearMessages();
        boolean valid = true;
        if (!optional && this.firma == null) {
            this.buttonBox.addErrorMessage("Es muss eine Firma angegeben werden");
            valid = false;
        }
        if (betroffenePerson == BetroffenePerson.Type.NNATPERS && this.firma != null) {
            this.buttonBox.addErrorMessage("Zu einer betroffenen nicht nat\u00fcrlichen Person d\u00fcrfen keine Angaben zu einer Firma gemacht werden");
            valid = false;
        }
        return Validators.allOf(valid, this.firma == null || this.firma.validate());
    }

    public static enum Type implements ButtonEnum
    {
        FIRMA("Firma");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }
}

