/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.Adresse;
import de.elster.flutopferhilfen.gui.Bearbeiter;
import de.elster.flutopferhilfen.gui.Komm;
import de.elster.flutopferhilfen.gui.Referenz;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.Icons;
import de.elster.flutopferhilfen.gui.utils.Validator;
import de.finkonsens.rms.kmv.base.v6.AdresseCType;
import de.finkonsens.rms.kmv.base.v6.BearbeiterCType;
import de.finkonsens.rms.kmv.base.v6.KommunikationCType;
import de.finkonsens.rms.kmv.base.v6.ReferenzCType;
import de.finkonsens.rms.kmv.base.v6.VerfasserCType;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

class Verfasser
extends Tab {
    private final VBox content;
    private final AllgemeinPane allgemein;
    private final BearbeiterPane bearbeiter;
    private final ReferenzPane referenz;

    public Verfasser(String title, VerfasserCType value, Eric eric) {
        super(title);
        ScrollPane scroll = new ScrollPane();
        scroll.setFitToWidth(true);
        scroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.content = new VBox();
        this.content.setFillWidth(true);
        scroll.setContent(this.content);
        this.setContent(scroll);
        ObservableList<Node> panes = this.content.getChildren();
        this.allgemein = new AllgemeinPane(value);
        panes.add(this.allgemein);
        this.bearbeiter = new BearbeiterPane(value);
        panes.add(this.bearbeiter);
        this.referenz = new ReferenzPane(value, eric);
        panes.add(this.referenz);
    }

    public void load(VerfasserCType value) {
        this.allgemein.load(value);
        this.bearbeiter.load(value);
        this.referenz.load(value);
        this.setGraphic(null);
    }

    public VerfasserCType save() {
        VerfasserCType result = new VerfasserCType();
        boolean allgemein = this.allgemein.saveInto(result);
        boolean bearbeiter = this.bearbeiter.saveInto(result);
        boolean referenz = this.referenz.saveInto(result);
        if (allgemein || bearbeiter || referenz) {
            return result;
        }
        return null;
    }

    public boolean hasChanged() {
        return Validators.anyOf(this.allgemein.hasChanged(), this.bearbeiter.hasChanged(), this.referenz.hasChanged());
    }

    public boolean validate() {
        boolean valid = Validators.allOf(this.allgemein.validate(), this.bearbeiter.validate(), this.referenz.validate());
        this.setGraphic(valid ? Icons.getCheck(Color.GREEN) : Icons.getPencil(Color.RED));
        return valid;
    }

    void setReadonly(boolean value) {
        this.setGraphic(null);
        this.content.setDisable(value);
    }

    static class AllgemeinPane
    extends TitledPane {
        private final Form<VerfasserCType> nameForm;
        private final Adresse verfasserAdresse;
        private final Komm komm;

        public AllgemeinPane(VerfasserCType value) {
            super("Allgemein*", null);
            this.setCollapsible(false);
            this.setPadding(new Insets(7.0));
            VBox content = new VBox();
            content.getStyleClass().add("form-container");
            this.setContent(content);
            ObservableList<Node> children = content.getChildren();
            content.setFillWidth(true);
            this.nameForm = Form.of(VerfasserCType::new, Form.withText("Name*", VerfasserCType::getName, VerfasserCType::setName).validate(Validator.maxLength2(72, "Der Name des Verfassers darf h\u00f6chstens 72 Zeichen lang sein")).validate(Validator.forPattern2(".*([\\p{N}]|[\\p{L}]).*", "Der Name des Verfassers muss mindestens einen Buchstaben oder eine Ziffer enthalten")).help("Der Name der auszahlenden Stelle").required("Der Name des Verfassers muss angegeben werden"));
            this.nameForm.load(value);
            children.add(this.nameForm.render());
            this.verfasserAdresse = new Adresse(value != null ? value.getVerfasserAdresse() : null, false);
            children.add(this.verfasserAdresse.getButtonBox());
            this.komm = new Komm(value != null ? value.getKomm() : null);
            children.add(this.komm.getButtonBox());
        }

        public void load(VerfasserCType value) {
            this.nameForm.load(value);
            this.verfasserAdresse.load(value != null ? value.getVerfasserAdresse() : null);
            this.komm.load(value != null ? value.getKomm() : null);
        }

        public boolean saveInto(VerfasserCType value) {
            KommunikationCType komm;
            boolean filled = this.nameForm.saveInto(value);
            AdresseCType adresse = this.verfasserAdresse.save();
            if (adresse != null) {
                value.setVerfasserAdresse(adresse);
                filled = true;
            }
            if ((komm = this.komm.save()) != null) {
                value.setKomm(komm);
                filled = true;
            }
            return filled;
        }

        public boolean hasChanged() {
            return Validators.anyOf(this.nameForm.hasChanged(), this.verfasserAdresse.hasChanged(), this.komm.hasChanged());
        }

        public boolean validate() {
            return Validators.allOf(this.nameForm.validate(), this.verfasserAdresse.validate(false), this.komm.validate());
        }
    }

    static class BearbeiterPane
    extends TitledPane {
        private final Bearbeiter bearbeiter;

        public BearbeiterPane(VerfasserCType value) {
            super("Bearbeiter beim Verfasser", null);
            this.setCollapsible(false);
            this.setPadding(new Insets(7.0));
            VBox content = new VBox();
            content.getStyleClass().add("form-container");
            content.setFillWidth(true);
            this.setContent(content);
            ObservableList<Node> children = content.getChildren();
            this.bearbeiter = new Bearbeiter(value != null ? value.getBearbeiter() : null);
            children.add(this.bearbeiter);
        }

        public void load(VerfasserCType value) {
            this.bearbeiter.load(value != null ? value.getBearbeiter() : null);
        }

        public boolean saveInto(VerfasserCType value) {
            BearbeiterCType bearbeiter;
            if (value != null && (bearbeiter = this.bearbeiter.save()) != null) {
                value.setBearbeiter(bearbeiter);
                return true;
            }
            return false;
        }

        public boolean hasChanged() {
            return this.bearbeiter.hasChanged();
        }

        public boolean validate() {
            return this.bearbeiter.validate();
        }
    }

    static class ReferenzPane
    extends TitledPane {
        private final Referenz referenz;

        public ReferenzPane(VerfasserCType value, Eric eric) {
            super("Referenz zur Mitteilung", null);
            this.setCollapsible(false);
            this.setPadding(new Insets(7.0));
            VBox content = new VBox();
            content.getStyleClass().add("form-container");
            content.setFillWidth(true);
            this.setContent(content);
            ObservableList<Node> children = content.getChildren();
            this.referenz = new Referenz(value != null ? value.getReferenz() : null, eric);
            children.add(this.referenz.getButtonBox());
        }

        public void load(VerfasserCType value) {
            this.referenz.load(value != null ? value.getReferenz() : null);
        }

        public boolean saveInto(VerfasserCType value) {
            ReferenzCType referenz;
            if (value != null && (referenz = this.referenz.save()) != null) {
                value.setReferenz(referenz);
                return true;
            }
            return false;
        }

        public boolean hasChanged() {
            return this.referenz.hasChanged();
        }

        public boolean validate() {
            return this.referenz.validate();
        }
    }
}

