/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.gui.utils.Identifier;
import de.elster.flutopferhilfen.gui.utils.Style;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;

public class ToggleButtons<T>
extends HBox {
    private static final String PROPERTY_KEY = "TOGGLE_BUTTON_KEY";
    private final ToggleGroup group = new ToggleGroup();
    private boolean changed;

    @SafeVarargs
    public ToggleButtons(String title, T ... keys) {
        this.setAlignment(Pos.CENTER_LEFT);
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        FlowPane pane = new FlowPane();
        ObservableList<Node> buttons = pane.getChildren();
        for (T key : keys) {
            String caption = key.toString();
            ToggleButton button = new ToggleButton(caption);
            button.setId("togglebutton-" + Identifier.toIdentifier(caption));
            button.getProperties().put(PROPERTY_KEY, key);
            button.setToggleGroup(this.group);
            buttons.add(button);
        }
        this.group.selectedToggleProperty().addListener(this::onSelect);
        this.setBorder(new Border(new BorderStroke(Color.SILVER, BorderStrokeStyle.SOLID, null, null, new Insets(0.0, 20.0, 20.0, 20.0))));
        this.getStyleClass().add("form-container");
        pane.setAlignment(Pos.TOP_RIGHT);
        pane.setHgap(5.0);
        pane.setVgap(5.0);
        Label label = new Label(title);
        label.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        label.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(label, Priority.ALWAYS);
        HBox.setHgrow(pane, Priority.NEVER);
        this.getChildren().addAll((Node[])new Node[]{label, pane});
        this.changed = false;
    }

    private void onSelect(ObservableValue<? extends Toggle> observableValue, Toggle oldValue, Toggle newValue) {
        if (newValue == null) {
            oldValue.setSelected(true);
        } else {
            this.changed = true;
        }
    }

    public void load(T key) {
        this.group.getToggles().stream().filter(t -> t.getProperties().get(PROPERTY_KEY).equals(key)).findAny().ifPresentOrElse(this.group::selectToggle, () -> this.group.selectToggle(null));
        this.changed = false;
    }

    public Optional<T> getSelected() {
        this.changed = false;
        Toggle selected = this.group.getSelectedToggle();
        if (selected != null) {
            return Optional.of(selected.getProperties().get(PROPERTY_KEY));
        }
        return Optional.empty();
    }

    public void setError(boolean value) {
        this.pseudoClassStateChanged(Style.INVALID, value);
    }

    public boolean hasChanged() {
        return this.changed;
    }
}

