/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.elsterxml.schema.headerbasis.v3.EmpfaengerIDSType;
import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.model.Bundesland;
import java.util.List;
import java.util.Optional;
import javafx.scene.Node;

public class Steuernummer {
    private final boolean bufaAllowed;
    private final Eric eric;
    private final Form<Content> form;
    private final Node node;

    public Steuernummer(String elsterSteuernummer, boolean required, boolean bufaAllowed, String stNrHelp, Eric eric) {
        this.bufaAllowed = bufaAllowed;
        this.eric = eric;
        this.form = Form.of("Steuernummer" + (required ? "*" : ""), Content::new, Form.withChoice("Bundesland", List.of(Bundesland.values()), Content::getBundesland, Content::setBundesland).required(required, "Das Bundesland zur Steuernummer muss angegeben werden"), Form.withText("Steuernummer", Content::getBescheidSteuernummer, Content::setBescheidSteuernummer).required(required, "Die Steuernummer im Bescheid-Format muss angegeben werden").help(stNrHelp));
        this.load(elsterSteuernummer);
        this.node = this.form.render();
    }

    public Node getNode() {
        return this.node;
    }

    public void load(String elsterSteuernummer) {
        if (elsterSteuernummer != null && elsterSteuernummer.endsWith("000000000")) {
            this.form.load(new Content(elsterSteuernummer.substring(0, 4)));
        } else {
            this.form.load(new Content(elsterSteuernummer, this.eric));
        }
    }

    public Optional<String> getElsterSteuernummer() {
        String steuernummer = this.form.getValue("steuernummer", String.class);
        if (steuernummer != null && steuernummer.length() == 4 && this.bufaAllowed) {
            return Optional.of(steuernummer + "000000000");
        }
        Bundesland bundesland = this.form.getValue("bundesland", Bundesland.class);
        return Content.getElsterSteuernummer(bundesland, steuernummer, this.eric);
    }

    public String save(NDHEmpfaengerCType empfaenger) {
        Content content = this.form.save();
        if (content != null) {
            String steuernummer = content.getBescheidSteuernummer();
            Object result = steuernummer != null && steuernummer.length() == 4 && this.bufaAllowed ? steuernummer + "000000000" : content.getElsterSteuernummer(this.eric).orElse(content.getBescheidSteuernummer());
            if (empfaenger != null) {
                Bundesland bundesland = content.getBundesland();
                if (bundesland != null) {
                    empfaenger.setId(EmpfaengerIDSType.L);
                    empfaenger.setValue(bundesland.getKuerzel());
                } else {
                    empfaenger.setId(null);
                    empfaenger.setValue(null);
                }
            }
            return result;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.form.isEmpty();
    }

    public boolean hasChanged() {
        return this.form.hasChanged();
    }

    public boolean validate() {
        boolean valid = this.form.validate();
        if (!this.isEmpty()) {
            String steuernummer = this.form.getValue("steuernummer", String.class);
            if (steuernummer != null && steuernummer.length() == 4 && this.bufaAllowed) {
                Optional<Bundesland> bundesland;
                if (!this.eric.pruefeBuFaNummer(steuernummer)) {
                    this.form.addErrorMessage("steuernummer", "Die Finanzamtsamtsnummer ist nicht korrekt");
                    valid = false;
                }
                if ((bundesland = Bundesland.getBundeslandFromElsterSteuernummer(steuernummer)).isPresent() && !bundesland.get().equals((Object)this.form.getValue("bundesland", Bundesland.class))) {
                    this.form.addErrorMessage("bundesland", "Die Finanzamtsamtsnummer passt nicht zum ausgew\u00e4hlten Bundesland");
                    valid = false;
                }
            } else if (!this.getElsterSteuernummer().map(this.eric::pruefeSteuernummer).orElse(false).booleanValue()) {
                this.form.addErrorMessage("steuernummer", "Die Steuernummer ist fachlich nicht korrekt");
                valid = false;
            }
        }
        return valid;
    }

    private static class Content {
        private Bundesland bundesland;
        private String bescheidSteuernummer;

        public Content() {
        }

        public Content(String elsterSteuernummer, Eric eric) {
            if (elsterSteuernummer != null) {
                this.bundesland = Bundesland.getBundeslandFromElsterSteuernummer(elsterSteuernummer).orElse(null);
                this.bescheidSteuernummer = eric.formatiereSteuernummer(elsterSteuernummer).orElse("");
            } else {
                this.bundesland = null;
                this.bescheidSteuernummer = null;
            }
        }

        public Content(String bufaNummer) {
            if (bufaNummer != null) {
                this.bundesland = Bundesland.getBundeslandFromElsterSteuernummer(bufaNummer).orElse(null);
                this.bescheidSteuernummer = bufaNummer;
            } else {
                this.bundesland = null;
                this.bescheidSteuernummer = null;
            }
        }

        public static Optional<String> getElsterSteuernummer(Bundesland bundesland, String bescheidSteuernummer, Eric eric) {
            return Optional.ofNullable(bundesland).flatMap(b -> b.getLaendernummer(bescheidSteuernummer)).flatMap(l -> eric.getElsterSteuernummer((String)l, bescheidSteuernummer));
        }

        public Optional<String> getElsterSteuernummer(Eric eric) {
            return Content.getElsterSteuernummer(this.bundesland, this.bescheidSteuernummer, eric);
        }

        public Bundesland getBundesland() {
            return this.bundesland;
        }

        public void setBundesland(Bundesland bundesland) {
            this.bundesland = bundesland;
        }

        public String getBescheidSteuernummer() {
            return this.bescheidSteuernummer;
        }

        public void setBescheidSteuernummer(String bescheidSteuernummer) {
            this.bescheidSteuernummer = bescheidSteuernummer;
        }
    }
}

