/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.gui.utils.Formatter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Optional;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class Settings {
    private Configuration configuration;
    public BorderPane content;
    public Accordion accordion;
    public TitledPane allgemein;
    public TextField datenlieferant;
    public TextField clientCertificate;
    public TextField proxyHost;
    public TextField proxyPort;
    public TextField proxyUsername;
    public PasswordField proxyPassword;
    public ChoiceBox<Auth> proxyAuth;

    @FXML
    public void initialize() {
        this.proxyAuth.getItems().setAll((Auth[])Auth.values());
        this.accordion.setExpandedPane(this.allgemein);
    }

    public static Stage create(Configuration configuration) throws IOException {
        Stage stage = new Stage();
        stage.setTitle("Einstellungen");
        stage.initModality(Modality.WINDOW_MODAL);
        stage.setResizable(false);
        FXMLLoader loader = new FXMLLoader(Settings.class.getResource("settings.fxml"));
        stage.setScene(new Scene((Parent)loader.load()));
        Settings settings = (Settings)loader.getController();
        settings.setConfiguration(configuration);
        return stage;
    }

    private void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.datenlieferant.setText(configuration.getDatenlieferant().orElse(""));
        Optional<URI> clientCertificate = configuration.getClientCertificate();
        if (clientCertificate.isEmpty()) {
            this.clientCertificate.setText("");
        } else {
            URI uri = clientCertificate.get();
            if (uri.getScheme().equals("file")) {
                this.clientCertificate.setText(Paths.get(uri).toString());
            } else {
                this.clientCertificate.setText(uri.toString());
            }
        }
        this.proxyHost.setText(configuration.getProxyHost().orElse(""));
        this.proxyPort.setText(configuration.getProxyPort().orElse(""));
        this.proxyUsername.setText(configuration.getProxyUsername().orElse(""));
        this.proxyPassword.setText(configuration.getProxyPassword().orElse(""));
        this.proxyAuth.setValue(Auth.getAuth(configuration.getProxyAuth().orElse(null)));
    }

    public void onChooseClientCertificate(Event ignore) {
        File file;
        File f;
        FileChooser chooser = new FileChooser();
        chooser.setTitle("ELSTER-Client-Zertifikat");
        chooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("Zertifiaktsdateien", "*.pfx", "*.p12"));
        chooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("Alle Dateien", "*.*"));
        String clientCertificate = this.clientCertificate.getText();
        if (clientCertificate != null && !clientCertificate.isEmpty() && (f = new File(clientCertificate)).exists()) {
            chooser.setInitialFileName(clientCertificate);
            chooser.setInitialDirectory(Paths.get(clientCertificate, new String[0]).getParent().toFile());
        }
        if ((file = chooser.showOpenDialog(this.content.getScene().getWindow())) != null) {
            this.clientCertificate.setText(file.toString());
        }
    }

    private Optional<URI> getClientCertificate() {
        String text = this.clientCertificate.getText();
        if (!text.isEmpty()) {
            try {
                return Optional.of(Paths.get(text, new String[0]).toUri());
            }
            catch (InvalidPathException invalidPathException) {
                try {
                    return Optional.of(new URI(text));
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException();
                }
            }
        }
        return Optional.empty();
    }

    public void onOk(Event ignore) throws IOException {
        if (this.validate()) {
            this.configuration.setDatenlieferant(Formatter.mapEmptyToNull(this.datenlieferant.getText()));
            this.configuration.setClientCertificate(this.getClientCertificate().orElse(null));
            this.configuration.setProxyHost(Formatter.mapEmptyToNull(this.proxyHost.getText()));
            this.configuration.setProxyPort(Formatter.mapEmptyToNull(this.proxyPort.getText()));
            this.configuration.setProxyUsername(Formatter.mapEmptyToNull(this.proxyUsername.getText()));
            this.configuration.setProxyPassword(Formatter.mapEmptyToNull(this.proxyPassword.getText()));
            this.configuration.setProxyAuth(Optional.ofNullable(this.proxyAuth.getValue()).map(Auth::getEricValue).orElse(null));
            this.configuration.save(Configuration.defaultConfiguration());
            this.close();
        }
    }

    private boolean validate() {
        Alert message = new Alert(Alert.AlertType.ERROR);
        message.setTitle("Flutopferhilfen-Mitteilung");
        message.setResizable(true);
        String datenlieferant = Formatter.mapEmptyToNull(this.datenlieferant.getText());
        if (datenlieferant == null) {
            message.setHeaderText("Der Datenlieferant darf nicht leer sein");
            message.showAndWait();
            return false;
        }
        try {
            this.getClientCertificate();
        }
        catch (IllegalArgumentException ignore) {
            message.setHeaderText("Ung\u00fcltiger Pfad bzw. ung\u00fcltige URL zum ELSTER-Client-Zertifikat");
            message.setContentText("Es kann entweder eine Pfad zur einem ELSTER-Client-Zertifikat, ein Pfad zu einer Treiber-DLL f\u00fcr einen Sicherheitsstick oder eine Signaturkarte oder eine URL zu einem eID-Client f\u00fcr den neuen Personalausweis angegeben werden.");
            message.showAndWait();
            return false;
        }
        return true;
    }

    public void onCancel(Event ignore) {
        this.close();
    }

    private void close() {
        Stage stage = (Stage)this.content.getScene().getWindow();
        stage.close();
    }

    private static enum Auth {
        EMPTY("<Leer>", null),
        ANY("Beliebig", "Any"),
        BASIC("Basic"),
        DIGEST("Digest"),
        DIGEST_IO("Digest (IE)", "DigestIE"),
        NTLM("NTLM"),
        SPNEGO("SPNEGO");

        private final String display;
        private final String ericValue;

        private Auth(String display) {
            this(display, display);
        }

        private Auth(String display, String ericValue) {
            this.display = display;
            this.ericValue = ericValue;
        }

        public String toString() {
            return this.display;
        }

        public String getEricValue() {
            return this.ericValue;
        }

        public static Auth getAuth(String ericValue) {
            if (ericValue != null) {
                for (Auth value : Auth.values()) {
                    if (!ericValue.equals(value.ericValue)) continue;
                    return value;
                }
            }
            return EMPTY;
        }
    }
}

