/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxController;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.Steuernummer;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.StringContainer;
import de.elster.flutopferhilfen.gui.utils.Validator;
import de.finkonsens.rms.kmv.base.v6.IDMCType;
import de.finkonsens.rms.kmv.base.v6.ReferenzCType;
import java.util.Optional;
import java.util.function.Function;

public class Referenz
implements ButtonBoxController {
    private final ButtonBox buttonBox = new ButtonBox(this, true, Type.values());
    private final Eric eric;
    private ReferenzElement aktenzeichen;
    private SteuernummerElement stnr;
    private ReferenzElement idnr;
    private ReferenzElement widnr;

    public Referenz(ReferenzCType value, Eric eric) {
        this.buttonBox.addHelp("Unter Referenz kann eine Referenzangabe zu der konkreten KONSENS-Mitteilung angewiesen werden. Dies kann z.B. ein Aktenzeichen sein, unter dem die Daten zu dieser KONSENS-Mitteilung beim Verfasser gef\u00fchrt werden. Referenzdaten, die auch zum betroffenen Fall angewiesen werden, sollten hier nicht geliefert werden. Z.B. reicht es, die IdNr nur zur betroffenen Person zu liefern.");
        this.eric = eric;
        this.load(value);
    }

    public ButtonBox getButtonBox() {
        return this.buttonBox;
    }

    @Override
    public void onButtonClicked(ButtonBox buttonBox, ButtonEnum key) {
        if (Type.AKTENZEICHEN.equals(key)) {
            this.addAktenzeichen(null);
        } else if (Type.STEUERNUMMER.equals(key)) {
            this.addStnr(null);
        } else if (Type.STEUERIDNUMMER.equals(key)) {
            this.addIdNr(null);
        } else if (Type.WIRTSCHAFTSIDNUMMER.equals(key)) {
            this.addWIdNr(null);
        }
    }

    @Override
    public void onContentRemoved(ButtonBoxNode node) {
        if (Type.AKTENZEICHEN.equals(node.getKey())) {
            this.removeAktenzeichen();
        } else if (Type.STEUERNUMMER.equals(node.getKey())) {
            this.removeStnr();
        } else if (Type.STEUERIDNUMMER.equals(node.getKey())) {
            this.removeIdNr();
        } else if (Type.WIRTSCHAFTSIDNUMMER.equals(node.getKey())) {
            this.removeWIdNr();
        }
    }

    private void removeAktenzeichen() {
        this.aktenzeichen = null;
        this.buttonBox.disableButtons(false, Type.AKTENZEICHEN, Type.STEUERNUMMER, Type.STEUERIDNUMMER, Type.WIRTSCHAFTSIDNUMMER);
    }

    private void removeStnr() {
        this.stnr = null;
        this.buttonBox.disableButtons(false, Type.AKTENZEICHEN, Type.STEUERNUMMER, Type.STEUERIDNUMMER, Type.WIRTSCHAFTSIDNUMMER);
    }

    private void removeIdNr() {
        this.idnr = null;
        this.buttonBox.disableButtons(false, Type.AKTENZEICHEN, Type.STEUERNUMMER, Type.STEUERIDNUMMER, Type.WIRTSCHAFTSIDNUMMER);
    }

    private void removeWIdNr() {
        this.widnr = null;
        this.buttonBox.disableButtons(false, Type.AKTENZEICHEN, Type.STEUERNUMMER, Type.STEUERIDNUMMER, Type.WIRTSCHAFTSIDNUMMER);
    }

    public void load(ReferenzCType value) {
        this.buttonBox.clearMessages();
        this.buttonBox.removeContent(this.aktenzeichen);
        this.buttonBox.removeContent(this.stnr);
        this.buttonBox.removeContent(this.idnr);
        this.buttonBox.removeContent(this.widnr);
        if (value != null) {
            String widnr;
            String aktenzeichen = value.getAktenzeichen();
            String stnr = value.getStNr();
            IDMCType idm = value.getIDM();
            String idnr = idm != null ? idm.getIdNr() : null;
            String string = widnr = idm != null ? idm.getWIdNr() : null;
            if (aktenzeichen != null && !aktenzeichen.isEmpty()) {
                this.addAktenzeichen(aktenzeichen);
            } else if (stnr != null && !stnr.isEmpty()) {
                this.addStnr(stnr);
            } else if (idnr != null && !idnr.isEmpty()) {
                this.addIdNr(idnr);
            } else if (widnr != null && !widnr.isEmpty()) {
                this.addWIdNr(widnr);
            }
        }
        this.buttonBox.setChanged(false);
    }

    private void addAktenzeichen(String aktenzeichen) {
        this.aktenzeichen = new ReferenzElement(this.buttonBox, Type.AKTENZEICHEN, aktenzeichen, Validator.maxLength2(20, "Das Aktenzeichen darf h\u00f6chstens 20 Zeichen lang sein"));
        this.buttonBox.addContent(this.aktenzeichen);
        this.buttonBox.disableButtons(true, Type.AKTENZEICHEN, Type.STEUERNUMMER, Type.STEUERIDNUMMER, Type.WIRTSCHAFTSIDNUMMER);
    }

    private void addStnr(String stnr) {
        this.stnr = new SteuernummerElement(this.buttonBox, stnr, this.eric);
        this.buttonBox.addContent(this.stnr);
        this.buttonBox.disableButtons(true, Type.AKTENZEICHEN, Type.STEUERNUMMER, Type.STEUERIDNUMMER, Type.WIRTSCHAFTSIDNUMMER);
    }

    private void addIdNr(String idnr) {
        Function[] functionArray = new Function[2];
        functionArray[0] = Validator.forPattern2("[0-9]{0,11}", "Die Steueridentifikationsnummer darf h\u00f6chstens 11 Ziffern lang sein");
        functionArray[1] = Validator.forPredicate2(this.eric::pruefeSteuerID, "Die Steueridentifikation ist fachlich ung\u00fcltig");
        this.idnr = new ReferenzElement(this.buttonBox, Type.STEUERIDNUMMER, idnr, functionArray);
        this.buttonBox.addContent(this.idnr);
        this.buttonBox.disableButtons(true, Type.AKTENZEICHEN, Type.STEUERNUMMER, Type.STEUERIDNUMMER, Type.WIRTSCHAFTSIDNUMMER);
    }

    private void addWIdNr(String widnr) {
        this.widnr = new ReferenzElement(this.buttonBox, Type.WIRTSCHAFTSIDNUMMER, widnr, Validator.maxLength2(17, "Die Wirtschaftsidentifikationsnummer darf h\u00f6chstens 17 Zeichen lang sein"));
        this.buttonBox.addContent(this.widnr);
        this.buttonBox.disableButtons(true, Type.AKTENZEICHEN, Type.STEUERNUMMER, Type.STEUERIDNUMMER, Type.WIRTSCHAFTSIDNUMMER);
    }

    public ReferenzCType save() {
        this.buttonBox.setChanged(false);
        if (this.aktenzeichen != null) {
            ReferenzCType result = new ReferenzCType();
            result.setAktenzeichen(this.aktenzeichen.save());
            return result;
        }
        if (this.stnr != null) {
            ReferenzCType result = new ReferenzCType();
            result.setStNr(this.stnr.save());
            return result;
        }
        if (this.idnr != null) {
            ReferenzCType result = new ReferenzCType();
            IDMCType idm = new IDMCType();
            idm.setIdNr(this.idnr.save());
            result.setIDM(idm);
            return result;
        }
        if (this.widnr != null) {
            ReferenzCType result = new ReferenzCType();
            IDMCType idm = new IDMCType();
            idm.setWIdNr(this.widnr.save());
            result.setIDM(idm);
            return result;
        }
        return null;
    }

    public boolean hasChanged() {
        boolean change = this.buttonBox.hasChanged();
        if (this.aktenzeichen != null) {
            change |= this.aktenzeichen.hasChanged();
        }
        if (this.stnr != null) {
            change |= this.stnr.hasChanged();
        }
        if (this.idnr != null) {
            change |= this.idnr.hasChanged();
        }
        if (this.widnr != null) {
            change |= this.widnr.hasChanged();
        }
        return change;
    }

    public boolean validate() {
        boolean aktenzeichenValid = this.aktenzeichen == null || this.aktenzeichen.validate();
        boolean stnrValid = this.stnr == null || this.stnr.validate();
        boolean idnrValid = this.idnr == null || this.idnr.validate();
        boolean widnrValid = this.widnr == null || this.widnr.validate();
        return Validators.allOf(aktenzeichenValid, stnrValid, idnrValid, widnrValid);
    }

    public boolean isEmpty() {
        return Validators.allOf(this.aktenzeichen == null || this.aktenzeichen.isEmpty(), this.stnr == null || this.stnr.isEmpty(), this.idnr == null || this.idnr.isEmpty(), this.widnr == null || this.widnr.isEmpty());
    }

    private static enum Type implements ButtonEnum
    {
        AKTENZEICHEN("Aktenzeichen"),
        STEUERNUMMER("Steuernummer"),
        STEUERIDNUMMER("SteueridentNr"),
        WIRTSCHAFTSIDNUMMER("WirtschaftsidentNr");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }

    private static class ReferenzElement
    extends ButtonBoxNode {
        private final Form<StringContainer> form;

        @SafeVarargs
        public ReferenzElement(ButtonBox parent, Type key, String value, Function<String, Optional<String>> ... validators) {
            super(parent, key);
            Form.FieldBuilder<StringContainer, String, ?> field = Form.withText(key + "*", StringContainer::getContent, StringContainer::setContent).required("Die Angabe darf nicht leer bleiben");
            for (Function<String, Optional<String>> validator : validators) {
                field.validate(validator);
            }
            this.form = Form.of(StringContainer::new, field);
            this.form.load(new StringContainer(value));
            this.setContent(this.form.render());
        }

        public String save() {
            StringContainer container = this.form.save();
            if (container != null) {
                return container.getContent();
            }
            return null;
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean validate() {
            return this.form.validate();
        }

        public boolean isEmpty() {
            return this.form.isEmpty();
        }
    }

    private static class SteuernummerElement
    extends ButtonBoxNode {
        private final Steuernummer steuernummer;

        public SteuernummerElement(ButtonBox parent, String value, Eric eric) {
            super(parent, Type.STEUERNUMMER);
            this.steuernummer = new Steuernummer(value, true, false, null, eric);
            this.setContent(this.steuernummer.getNode());
        }

        public String save() {
            return this.steuernummer.save(null);
        }

        public boolean validate() {
            return this.steuernummer.validate();
        }

        public boolean isEmpty() {
            return this.steuernummer.isEmpty();
        }

        @Override
        public boolean hasChanged() {
            return this.steuernummer.hasChanged();
        }
    }
}

