/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxController;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.geometry.Insets;
import javafx.scene.control.Label;

public class Rechtsgrund
implements ButtonBoxController {
    private final ButtonBox buttonBox;
    private final Set<RechtsgrundElement> selected = new HashSet<RechtsgrundElement>();

    public Rechtsgrund(List<String> values) {
        this.buttonBox = new ButtonBox(this, true, Type.values());
        this.load(values);
    }

    public ButtonBox getButtonBox() {
        return this.buttonBox;
    }

    @Override
    public void onButtonClicked(ButtonBox buttonBox, ButtonEnum key) {
        this.addRechtsgrund((Type)key);
    }

    private void addRechtsgrund(Type key) {
        RechtsgrundElement node = new RechtsgrundElement(this.buttonBox, key);
        this.selected.add(node);
        this.buttonBox.addContent(node);
        this.disableButtons();
    }

    private void disableButtons() {
        this.buttonBox.disableButtons(false, Type.values());
        for (RechtsgrundElement node : this.selected) {
            this.buttonBox.disableButtons(true, node.getKey());
        }
    }

    @Override
    public void onContentRemoved(ButtonBoxNode node) {
        this.selected.removeIf(n -> n.getKey().equals(node.getKey()));
        this.disableButtons();
    }

    public void load(List<String> values) {
        this.buttonBox.clearMessages();
        while (!this.selected.isEmpty()) {
            this.buttonBox.removeContent(this.selected.iterator().next());
        }
        if (values != null && !values.isEmpty()) {
            values.stream().map(Type::find).forEach(this::addRechtsgrund);
            this.buttonBox.setChanged(false);
        }
        this.disableButtons();
        this.buttonBox.setChanged(false);
    }

    public boolean saveInto(List<String> values) {
        this.buttonBox.setChanged(false);
        boolean filled = false;
        for (RechtsgrundElement node : this.selected) {
            values.add(((Type)node.getKey()).getValue());
            filled = true;
        }
        return filled;
    }

    public boolean hasChanged() {
        return this.buttonBox.hasChanged();
    }

    public boolean validate() {
        this.buttonBox.clearMessages();
        if (this.selected.isEmpty()) {
            this.buttonBox.addErrorMessage("Es muss mindestens ein Rechtsgrund angegeben werden");
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.selected.isEmpty();
    }

    private static enum Type implements ButtonEnum
    {
        PRIVATHAUSHALT("Privathaushalt", "1"),
        GEWERBE("Gewerbliche Unternehmen, Selbst\u00e4ndige und Angeh\u00f6rige der freien Berufe", "2"),
        VERMIETER_WOHNRAUM("Wohnungsunternehmen und Vermieter von Wohnraum", "3"),
        VERMIETER_GEWERBERAUM("Vermieter und Verp\u00e4chter von ganz oder teilweise f\u00fcr eine gewerbliche, selbst\u00e4ndige oder freiberufliche T\u00e4tigkeit genutzt Geb\u00e4ude oder Geb\u00e4udeteile", "4"),
        BETRIEBE("Betriebe der Land- und Forstwirtschaft und \u00e4hnliche Betriebe, Betriebe der Fischerei und Aquakultur", "5"),
        NICHT_ZUORDENBAR("Nicht zuordenbar", "6");

        private final String display;
        private final String value;

        private Type(String display, String value) {
            this.display = display;
            this.value = value;
        }

        public String toString() {
            return this.display;
        }

        public static Type find(String value) {
            return Arrays.stream(Type.values()).filter(t -> t.value.equals(value)).findAny().orElse(null);
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }

    private static class RechtsgrundElement
    extends ButtonBoxNode {
        public RechtsgrundElement(ButtonBox parent, Type key) {
            super(parent, key);
            Label label = new Label(key.toString());
            label.setWrapText(true);
            label.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            label.setMaxWidth(Double.MAX_VALUE);
            this.setContent(label);
        }

        @Override
        public boolean hasChanged() {
            return false;
        }
    }
}

