/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.Formatter;
import de.elsterfachmethodik.protokollverfahren.version6.xmlschema.DatenTeilStatusCType;
import de.elsterfachmethodik.protokollverfahren.version6.xmlschema.NdSFehlerCType;
import de.elsterfachmethodik.protokollverfahren.version6.xmlschema.NutzdatenBlockStatusCType;
import de.elsterfachmethodik.protokollverfahren.version6.xmlschema.ProtokollCType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;

public class Protokoll
extends Tab {
    private final VBox content;
    private final ObservableList<Node> messages;
    private final Formatter<String> timestamps = Formatter.forTimestamps();

    public Protokoll(String title, Set<String> transfertickets, String sendDate, ProtokollCType value) {
        super(title);
        ScrollPane scroll = new ScrollPane();
        scroll.setFitToWidth(true);
        scroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.content = new VBox();
        this.content.setFillWidth(true);
        scroll.setContent(this.content);
        this.setContent(scroll);
        this.messages = this.content.getChildren();
        this.load(transfertickets, sendDate, value);
    }

    public void load(Set<String> transfertickets, String sendDate, ProtokollCType value) {
        this.messages.clear();
        Optional<ProtokollCType> input = Optional.ofNullable(value);
        if (input.isEmpty()) {
            this.messages.add(Form.of("Allgemein", Form.withMultilineText("Transfertickets", String.join((CharSequence)"\n", transfertickets)).monospaced().readonly(), Form.withText("Versanddatum", sendDate != null ? sendDate : "<Leer>").readonly()).render());
            Label nothing = new Label("Es wurden aktuell noch keine Protokolle abgeholt");
            Font oldFont = nothing.getFont();
            nothing.setFont(Font.font(oldFont.getName(), FontPosture.ITALIC, oldFont.getSize()));
            nothing.setAlignment(Pos.CENTER);
            nothing.setMaxWidth(Double.MAX_VALUE);
            nothing.setPadding(new Insets(10.0));
            this.messages.add(nothing);
            VBox.setVgrow(nothing, Priority.ALWAYS);
        } else {
            String zeitstempel = this.timestamps.format(input.map(ProtokollCType::getZeitStempel).orElse(null));
            Optional<DatenTeilStatusCType> datenteil = input.map(ProtokollCType::getDatenTeil);
            this.messages.add(Form.of("Allgemein", Form.withMultilineText("Transfertickets", String.join((CharSequence)"\n", transfertickets)).monospaced().readonly(), Form.withText("Zeitstempel", zeitstempel).readonly(), Form.withText("Fehlercode", datenteil.map(DatenTeilStatusCType::getCode).orElse("")).monospaced().readonly(), Form.withMultilineText("Fehlertext", datenteil.map(DatenTeilStatusCType::getText).orElse("")).readonly()).render());
            for (NutzdatenBlockStatusCType nutzdatenblock : datenteil.map(DatenTeilStatusCType::getNutzdatenblock).orElse(Collections.emptyList())) {
                ArrayList fields = new ArrayList();
                fields.add(Form.withText("Nutzdatenticket", nutzdatenblock.getNutzdatenTicket()).monospaced().readonly());
                fields.add(Form.withText("Fehlercode", nutzdatenblock.getCode()).monospaced().readonly());
                fields.add(Form.withMultilineText("Fehlertext", nutzdatenblock.getText()).readonly());
                for (NdSFehlerCType item : nutzdatenblock.getNdSFehler()) {
                    fields.add(Form.withText("Fehlercode", item.getFehlerNummer()).monospaced().readonly());
                    fields.add(Form.withMultilineText("Fehlertext", item.getFehlerText()).readonly());
                }
                this.messages.add(Form.of("Nutzdatenblock", fields.toArray(new Form.FieldBuilder[0])).render());
            }
        }
    }

    public void setReadonly(boolean value) {
        this.content.setDisable(value);
    }
}

