/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.model.Pin;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.PasswordField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class PinDialog
extends Dialog<String>
implements Pin {
    private final PasswordField pinField;
    private String pin;

    public PinDialog() {
        this.setTitle("Zertifikatspasswort");
        this.setHeaderText("Bitte geben Sie das Zertifikatspasswort ein");
        this.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.pinField = new PasswordField();
        this.pinField.setPromptText("Zertifikatspasswort");
        HBox content = new HBox();
        content.getChildren().add(this.pinField);
        content.setPadding(new Insets(20.0));
        HBox.setHgrow(this.pinField, Priority.ALWAYS);
        this.getDialogPane().setContent(content);
        this.pinField.focusedProperty().addListener(x -> this.pinField.requestFocus());
        this.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                String pin = this.pinField.getText();
                this.pinField.setText(null);
                return pin;
            }
            return null;
        });
    }

    @Override
    public Optional<String> get() {
        if (this.pin == null) {
            this.pin = this.showAndWait().orElse(null);
        }
        return Optional.ofNullable(this.pin);
    }

    @Override
    public void reset() {
        this.pin = null;
    }
}

