/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxController;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class PersonInfos<T>
implements ButtonBoxController {
    private final ButtonBox buttonBox;
    private final List<PersonInfo<T>> personInfos = new ArrayList<PersonInfo<T>>();
    private final Supplier<T> constructor;
    private final Function<T, String> getTyp;
    private final BiConsumer<T, String> setTyp;
    private final Function<T, String> getWert;
    private final BiConsumer<T, String> setWert;

    public PersonInfos(List<T> value, Supplier<T> constructor, Function<T, String> getTyp, BiConsumer<T, String> setTyp, Function<T, String> getWert, BiConsumer<T, String> setWert) {
        this.buttonBox = new ButtonBox(this, true, Type.values());
        this.constructor = constructor;
        this.getTyp = getTyp;
        this.setTyp = setTyp;
        this.getWert = getWert;
        this.setWert = setWert;
        this.load(value);
    }

    public void load(List<T> value) {
        this.buttonBox.clearMessages();
        while (!this.personInfos.isEmpty()) {
            this.buttonBox.removeContent(this.personInfos.get(0));
        }
        if (value != null) {
            for (T info : value) {
                this.addPersonInfo(info);
            }
        }
        this.buttonBox.setChanged(false);
    }

    public boolean saveInto(List<T> value) {
        if (value != null) {
            value.clear();
            for (PersonInfo<T> personInfo : this.personInfos) {
                value.add(personInfo.save());
            }
            this.buttonBox.setChanged(false);
            return !value.isEmpty();
        }
        return false;
    }

    private void addPersonInfo(T info) {
        PersonInfo<T> personInfo = new PersonInfo<T>(this.buttonBox, info, this.constructor, this.getTyp, this.setTyp, this.getWert, this.setWert);
        this.personInfos.add(personInfo);
        this.buttonBox.addContent(personInfo);
        this.buttonBox.disableButtons(this.personInfos.size() >= 10, Type.PERSON_INFO_ADD);
    }

    private void removePersonInfo(PersonInfo<T> personInfo) {
        this.personInfos.remove(personInfo);
        this.buttonBox.disableButtons(this.personInfos.size() >= 10, Type.PERSON_INFO_ADD);
        this.buttonBox.setChanged(true);
    }

    @Override
    public void onButtonClicked(ButtonBox buttonBox, ButtonEnum key) {
        this.addPersonInfo(null);
    }

    @Override
    public void onContentRemoved(ButtonBoxNode node) {
        this.removePersonInfo((PersonInfo)node);
    }

    public ButtonBox getButtonBox() {
        return this.buttonBox;
    }

    public boolean hasChanged() {
        boolean change = this.buttonBox.hasChanged();
        for (PersonInfo<T> i : this.personInfos) {
            change |= i.hasChanged();
        }
        return change;
    }

    public boolean isEmpty() {
        return this.personInfos.stream().allMatch(PersonInfo::isEmpty);
    }

    public boolean validate() {
        return this.personInfos.stream().allMatch(PersonInfo::validate);
    }

    private static enum Type implements ButtonEnum
    {
        PERSON_INFO_ADD("Weitere Informationen hinzuf\u00fcgen");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }

    private static class PersonInfo<T>
    extends ButtonBoxNode {
        private final Form<T> form;

        public PersonInfo(ButtonBox parent, T value, Supplier<T> constructor, Function<T, String> getTyp, BiConsumer<T, String> setTyp, Function<T, String> getWert, BiConsumer<T, String> setWert) {
            super(parent, Type.PERSON_INFO_ADD);
            this.form = Form.of(constructor, Form.withText("Typ*", getTyp, setTyp).validate(Validator.forPattern2(".{3,30}", "Der Typ der weiteren Information muss mindestens 3 und h\u00f6chstens 30 Zeichen lang sein")).required("Es muss der Typ der weiteren Information angegeben werden"), Form.withText("Wert*", getWert, setWert).validate(Validator.maxLength2(250, "Die weitere Information darf h\u00f6chstens 250 Zeichen lang sein")).required("Die weitere Information darf nicht leer sein"));
            this.form.load(value);
            this.setContent(this.form.render());
        }

        public void load(T value) {
            this.form.load(value);
        }

        public T save() {
            return this.form.save();
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean isEmpty() {
            return this.form.isEmpty();
        }

        public boolean validate() {
            return this.form.validate();
        }
    }
}

