/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.elsterxml.schema.headerbasis.v3.EmpfaengerIDSType;
import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.PersonInfos;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.Formatter;
import de.elster.flutopferhilfen.gui.utils.Validator;
import de.elster.flutopferhilfen.model.Bundesland;
import de.finkonsens.rms.kmv.allg.v6.AllgBlocknameArtSType;
import de.finkonsens.rms.kmv.base.v6.BetroffenePersonCType;
import de.finkonsens.rms.kmv.base.v6.GeburtsdatenCType;
import de.finkonsens.rms.kmv.base.v6.NatuerlichePersonCType;
import de.finkonsens.rms.kmv.base.v6.PersonInfoCType;
import de.finkonsens.rms.kmv.base.v6.WeiterePersonCType;
import java.util.List;
import java.util.function.Function;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

class NatPers
extends ButtonBoxNode {
    private final Form<Content> form;
    private final PersonInfos<PersonInfoCType> personInfos;

    public NatPers(ButtonBox parent, ButtonEnum type, NatuerlichePersonCType value, NDHEmpfaengerCType empfaenger, boolean idnrRequired, boolean bundeslandRequired, String idNrHelp, Eric eric) {
        super(parent, type);
        Content input = new Content(value, empfaenger);
        Form.FieldBuilder[] fieldBuilderArray = new Form.FieldBuilder[6];
        fieldBuilderArray[0] = Form.withText("Name*", new GetName(NatuerlichePersonCType::getName, AllgBlocknameArtSType.NN), NatuerlichePersonCType::setName).validate(Validator.maxLength2(72, "Der Name der Person darf h\u00f6chstens 72 Zeichen lang sein")).validate(Validator.forPattern2("[\\p{L}\\p{P}\\p{Zs}\\p{Nd}`\u00b4]*", "Der Name der Person darf nur aus Buchstaben, Ziffern, Leerzeichen, Interpunktionszeichen und Hochkommata bestehen")).required("Der Name der nat\u00fcrlichen Person muss angegeben werden");
        fieldBuilderArray[1] = Form.withText("Vorname", new GetName(NatuerlichePersonCType::getVorname, AllgBlocknameArtSType.VN), NatuerlichePersonCType::setVorname).validate(Validator.maxLength2(72, "Der Vorname der Person darf h\u00f6chstens 72 Zeichen lang sein")).validate(Validator.forPattern2("[\\p{L}\\p{P}\\p{Zs}\\p{Nd}`\u00b4]*", "Der Name der Person darf nur aus Buchstaben, Ziffern, Leerzeichen, Interpunktionszeichen und Hochkommata bestehen"));
        fieldBuilderArray[2] = Form.withText("Titel", NatuerlichePersonCType::getTitel, NatuerlichePersonCType::setTitel).validate(Validator.maxLength2(30, "Der Titel der Person darf h\u00f6chstens 30 Zeichen lang sein"));
        fieldBuilderArray[3] = Form.withDate("Geburtsdatum*", NatPers::getGeburtsdatum, NatPers::setGeburtsdatum).validate(Validator.forDate()).required("Das Geburtsdatum der nat\u00fcrlichen Person muss angegeben werden");
        fieldBuilderArray[4] = Form.withChoice("Bundesland*", List.of(Bundesland.values()), Content::getEmpfaenger, Content::setEmpfaenger).required(bundeslandRequired, "Das Bundesland des Leistungsempf\u00e4ngers muss angegeben werden");
        fieldBuilderArray[5] = Form.withText("Steueridentifikationsnr" + (idnrRequired ? "*" : ""), NatuerlichePersonCType::getIdNr, NatuerlichePersonCType::setIdNr).validate(Validator.forPattern2("[0-9]{11}", "Die Steueridentifikationsnummer muss genau 11 Zeichen lang sein")).validate(Validator.forPredicate2(eric::pruefeSteuerID, "Die Steueridentifikation ist fachlich ung\u00fcltig")).help(idNrHelp).required(idnrRequired, "Zu einer nat\u00fcrlichen Person muss eine Steueridentifikationsnummer angegeben werden");
        this.form = Form.of("Nat\u00fcrliche Person", Content::new, fieldBuilderArray);
        this.form.load(input);
        this.personInfos = new PersonInfos<PersonInfoCType>(input.getPersonInfo(), PersonInfoCType::new, PersonInfoCType::getTyp, PersonInfoCType::setTyp, PersonInfoCType::getValue, PersonInfoCType::setValue);
        ButtonBox personInfosButtonBox = this.personInfos.getButtonBox();
        personInfosButtonBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        personInfosButtonBox.getStyleClass().add("formsfx-form");
        TitledPane personInfos = new TitledPane("Informationen zur Person", personInfosButtonBox);
        personInfos.setBorder(new Border(new BorderStroke(Color.TRANSPARENT, BorderStrokeStyle.NONE, null, BorderWidths.EMPTY, new Insets(0.0, 20.0, 20.0, 20.0))));
        personInfos.setCollapsible(false);
        VBox content = new VBox();
        content.setFillWidth(true);
        content.getChildren().addAll((Node[])new Node[]{this.form.render(120.0), personInfos});
        this.setContent(content);
    }

    private static void setGeburtsdatum(Content value, String geburtsdatum) {
        if (value != null) {
            if (geburtsdatum != null && !geburtsdatum.isEmpty()) {
                GeburtsdatenCType geburtsdaten = value.getGeburtsdaten();
                if (geburtsdaten == null) {
                    geburtsdaten = new GeburtsdatenCType();
                    value.setGeburtsdaten(geburtsdaten);
                }
                geburtsdaten.setGebDat(Formatter.convertToXml(geburtsdatum));
            } else {
                value.setGeburtsdaten(null);
            }
        }
    }

    private static String getGeburtsdatum(Content value) {
        GeburtsdatenCType geburtsdaten;
        if (value != null && (geburtsdaten = value.getGeburtsdaten()) != null) {
            return Formatter.convertFromXml(geburtsdaten.getGebDat());
        }
        return null;
    }

    public void load(NatuerlichePersonCType value, NDHEmpfaengerCType empfaenger) {
        Content content = new Content(value, empfaenger);
        this.form.load(content);
        this.personInfos.load(content.getPersonInfo());
    }

    private static void normalizeName(NatuerlichePersonCType value) {
        if (value != null) {
            NatuerlichePersonCType.Blockname blockname;
            String name = value.getName();
            String vorname = value.getVorname();
            if (name != null && !name.isEmpty() && (vorname == null || vorname.isEmpty())) {
                blockname = new NatuerlichePersonCType.Blockname();
                blockname.setArt(AllgBlocknameArtSType.NN);
                blockname.setValue(name);
                value.setBlockname(blockname);
                value.setName(null);
            }
            if (vorname != null && !vorname.isEmpty() && (name == null || name.isEmpty())) {
                blockname = new NatuerlichePersonCType.Blockname();
                blockname.setArt(AllgBlocknameArtSType.VN);
                blockname.setValue(vorname);
                value.setBlockname(blockname);
                value.setVorname(null);
            }
        }
    }

    private boolean saveInto(NatuerlichePersonCType value, NDHEmpfaengerCType empfaenger) {
        if (value != null) {
            Content destination = new Content();
            if (Validators.anyOf(this.form.saveInto(destination), this.personInfos.saveInto(destination.getPersonInfo()))) {
                destination.saveIntoNatPers(value);
                NatPers.normalizeName(value);
                destination.saveEmpfaenger(empfaenger);
                return true;
            }
        }
        return false;
    }

    public BetroffenePersonCType.NatPers saveToBetroffenePerson(NDHEmpfaengerCType empfaenger) {
        BetroffenePersonCType.NatPers result = new BetroffenePersonCType.NatPers();
        if (this.saveInto(result, empfaenger)) {
            return result;
        }
        return null;
    }

    public WeiterePersonCType.NatPers saveToWeiterePerson() {
        WeiterePersonCType.NatPers result = new WeiterePersonCType.NatPers();
        if (this.saveInto(result, null)) {
            return result;
        }
        return null;
    }

    @Override
    public boolean hasChanged() {
        return Validators.anyOf(this.form.hasChanged(), this.personInfos.hasChanged());
    }

    public boolean validate() {
        return Validators.allOf(this.form.validate(), this.personInfos.validate());
    }

    private static class Content
    extends NatuerlichePersonCType {
        private Bundesland empfaenger;

        public Content() {
        }

        public Content(NatuerlichePersonCType input, NDHEmpfaengerCType empfaenger) {
            if (input != null) {
                this.setName(input.getName());
                this.setVorname(input.getVorname());
                NatuerlichePersonCType.Blockname blockname = input.getBlockname();
                if (blockname != null) {
                    NatuerlichePersonCType.Blockname copy = new NatuerlichePersonCType.Blockname();
                    copy.setValue(blockname.getValue());
                    copy.setArt(blockname.getArt());
                    this.setBlockname(copy);
                }
                this.setTitel(input.getTitel());
                GeburtsdatenCType geburtsdaten = input.getGeburtsdaten();
                if (geburtsdaten != null) {
                    GeburtsdatenCType copy = new GeburtsdatenCType();
                    copy.setGebDat(geburtsdaten.getGebDat());
                    this.setGeburtsdaten(copy);
                }
                this.setIdNr(input.getIdNr());
                List<PersonInfoCType> personInfo = input.getPersonInfo();
                if (!personInfo.isEmpty()) {
                    List<PersonInfoCType> copy = this.getPersonInfo();
                    for (PersonInfoCType info : personInfo) {
                        PersonInfoCType next = new PersonInfoCType();
                        next.setValue(info.getValue());
                        next.setTyp(info.getTyp());
                        copy.add(next);
                    }
                }
            }
            if (empfaenger != null && EmpfaengerIDSType.L.equals((Object)empfaenger.getId())) {
                this.empfaenger = Bundesland.getBundeslandFromKuerzel(empfaenger.getValue()).orElse(null);
            }
        }

        public Bundesland getEmpfaenger() {
            return this.empfaenger;
        }

        public void setEmpfaenger(Bundesland empfaenger) {
            this.empfaenger = empfaenger;
        }

        public void saveEmpfaenger(NDHEmpfaengerCType destination) {
            if (destination != null) {
                if (this.empfaenger != null) {
                    destination.setId(EmpfaengerIDSType.L);
                    destination.setValue(this.empfaenger.getKuerzel());
                } else {
                    destination.setId(null);
                    destination.setValue(null);
                }
            }
        }

        public void saveIntoNatPers(NatuerlichePersonCType destination) {
            if (destination != null) {
                List<PersonInfoCType> copy;
                destination.setName(this.name);
                destination.setVorname(this.vorname);
                if (this.blockname != null) {
                    copy = new NatuerlichePersonCType.Blockname();
                    ((NatuerlichePersonCType.Blockname)((Object)copy)).setArt(this.blockname.getArt());
                    ((NatuerlichePersonCType.Blockname)((Object)copy)).setValue(this.blockname.getValue());
                    destination.setBlockname((NatuerlichePersonCType.Blockname)((Object)copy));
                }
                destination.setTitel(this.titel);
                if (this.geburtsdaten != null) {
                    copy = new GeburtsdatenCType();
                    ((GeburtsdatenCType)((Object)copy)).setGebDat(this.geburtsdaten.getGebDat());
                    destination.setGeburtsdaten((GeburtsdatenCType)((Object)copy));
                }
                destination.setIdNr(this.idNr);
                if (this.personInfo != null) {
                    copy = destination.getPersonInfo();
                    for (PersonInfoCType info : this.personInfo) {
                        PersonInfoCType next = new PersonInfoCType();
                        next.setTyp(info.getTyp());
                        next.setValue(info.getValue());
                        copy.add(next);
                    }
                }
            }
        }
    }

    private static class GetName
    implements Function<Content, String> {
        private final Function<Content, String> getter;
        private final AllgBlocknameArtSType art;

        public GetName(Function<Content, String> getter, AllgBlocknameArtSType art) {
            this.getter = getter;
            this.art = art;
        }

        @Override
        public String apply(Content value) {
            if (value != null) {
                String content = this.getter.apply(value);
                if (content != null) {
                    return content;
                }
                NatuerlichePersonCType.Blockname blockname = value.getBlockname();
                if (blockname != null && blockname.getArt() == this.art) {
                    return blockname.getValue();
                }
            }
            return "";
        }
    }
}

