/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.PersonInfos;
import de.elster.flutopferhilfen.gui.Steuernummer;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.Validator;
import de.finkonsens.rms.kmv.base.v6.FirmenInfoCType;
import de.finkonsens.rms.kmv.base.v6.NichtNatuerlichePersonCType;
import java.util.Collections;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

class NNatPers
extends ButtonBoxNode {
    private final Form<NichtNatuerlichePersonCType> form = Form.of("Nicht nat\u00fcrliche Person*", NichtNatuerlichePersonCType::new, Form.withText("Wirtschaftsidentnr.", NichtNatuerlichePersonCType::getWIdNr, NichtNatuerlichePersonCType::setWIdNr).validate(Validator.maxLength2(17, "Die Wirtschaftsidentifikationsnummer darf h\u00f6chsten 17 Zeichen lang sein")), Form.withText("Firmenname*", NichtNatuerlichePersonCType::getFirmenname, NichtNatuerlichePersonCType::setFirmenname).validate(Validator.maxLength2(120, "Der Firmenname darf h\u00f6chstens 120 Zeichen lang sein")).required("Der Firmenname muss angegeben werden"));
    private final Steuernummer steuernummer;
    private final PersonInfos<FirmenInfoCType> firmenInfos;

    public NNatPers(ButtonBox parent, ButtonEnum type, NichtNatuerlichePersonCType value, boolean stNrOptional, boolean bufaAllowed, boolean enableFirmenInfos, String stNrHelp, Eric eric) {
        super(parent, type);
        this.form.load(value);
        Optional<NichtNatuerlichePersonCType> input = Optional.ofNullable(value);
        this.steuernummer = new Steuernummer(input.map(NichtNatuerlichePersonCType::getStNr).orElse(null), !stNrOptional, bufaAllowed, stNrHelp, eric);
        VBox content = new VBox();
        content.setFillWidth(true);
        content.getChildren().addAll((Node[])new Node[]{this.form.render(), this.steuernummer.getNode()});
        if (enableFirmenInfos) {
            this.firmenInfos = new PersonInfos<FirmenInfoCType>(input.map(NichtNatuerlichePersonCType::getFirmenInfo).orElse(Collections.emptyList()), FirmenInfoCType::new, FirmenInfoCType::getTyp, FirmenInfoCType::setTyp, FirmenInfoCType::getValue, FirmenInfoCType::setValue);
            ButtonBox firmenInfosButtonBox = this.firmenInfos.getButtonBox();
            firmenInfosButtonBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            firmenInfosButtonBox.getStyleClass().add("formsfx-form");
            TitledPane firmenInfos = new TitledPane("Informationen zur nicht nat\u00fcrlichen Person", firmenInfosButtonBox);
            firmenInfos.setBorder(new Border(new BorderStroke(Color.TRANSPARENT, BorderStrokeStyle.NONE, null, BorderWidths.EMPTY, new Insets(0.0, 20.0, 20.0, 20.0))));
            firmenInfos.setCollapsible(false);
            content.getChildren().add(firmenInfos);
        } else {
            this.firmenInfos = null;
        }
        this.setContent(content);
    }

    public NichtNatuerlichePersonCType save(NDHEmpfaengerCType empfaenger) {
        String elsterSteuernummer;
        NichtNatuerlichePersonCType result = new NichtNatuerlichePersonCType();
        boolean filled = this.form.saveInto(result);
        if (this.firmenInfos != null) {
            boolean bl = filled = this.firmenInfos.saveInto(result.getFirmenInfo()) || filled;
        }
        if ((elsterSteuernummer = this.steuernummer.save(empfaenger)) != null) {
            result.setStNr(elsterSteuernummer);
            filled = true;
        }
        if (filled) {
            return result;
        }
        return null;
    }

    @Override
    public boolean hasChanged() {
        return Validators.anyOf(this.form.hasChanged(), this.steuernummer.hasChanged(), this.firmenInfos != null && this.firmenInfos.hasChanged());
    }

    public boolean validate() {
        return Validators.allOf(this.form.validate(), this.steuernummer.validate(), this.firmenInfos == null || this.firmenInfos.validate());
    }

    public Optional<String> getSteuernummer() {
        return this.steuernummer.getElsterSteuernummer();
    }
}

