/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.CaseView;
import de.elster.flutopferhilfen.gui.CasesView;
import de.elster.flutopferhilfen.gui.InfosController;
import de.elster.flutopferhilfen.gui.PinDialog;
import de.elster.flutopferhilfen.gui.SaveDialog;
import de.elster.flutopferhilfen.gui.Settings;
import de.elster.flutopferhilfen.gui.utils.Icons;
import de.elster.flutopferhilfen.model.Case;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Shape;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class MainWindowController
implements AutoCloseable {
    private static final Pattern CASE_NAME = Pattern.compile("[a-zA-Z\\d_\\-\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df]{1,64}");
    private static final Pattern FORBIDDEN_NAMES = Pattern.compile("CON|PRN|AUX|NUL|COM\\d|LPT\\d", 2);
    @FXML
    BorderPane mainPane;
    @FXML
    SplitPane split;
    @FXML
    public BorderPane select;
    @FXML
    public BorderPane caseContainer;
    @FXML
    public Button settings;
    @FXML
    public Button delete;
    @FXML
    public Button duplicate;
    @FXML
    public Button neu;
    @FXML
    public Button infos;
    private Eric eric = null;
    private CasesView cases2;
    private CaseView caseView;
    private PinDialog pin;
    private Configuration configuration;

    @FXML
    public void initialize() {
        URL css = this.getClass().getResource("basis.css");
        if (css != null) {
            this.mainPane.getStylesheets().add(css.toExternalForm());
        }
        this.split.setDividerPositions(0.2);
        this.cases2 = new CasesView();
        this.cases2.setOnSelectCase(this::onCaseSelect);
        this.select.setCenter(this.cases2);
        this.caseView = new CaseView(this.getEric(null));
        this.caseView.setOnSave(this::onCaseSave);
        this.caseView.setOnGuiValidate(this::onCaseGuiValidate);
        this.caseView.setOnValidate(this::onCaseValidate);
        this.caseView.setOnSend(this::onCaseSend);
        this.caseView.setOnReceive(this::onCaseReceive);
        this.caseView.setOnCancel(this::onCaseCancel);
        this.caseView.setOnGuiValidateStorno(this::onCaseGuiValidateStorno);
        this.caseView.setOnValidateStorno(this::onCaseValidateStorno);
        this.caseView.setOnSendStorno(this::onCaseSendStorno);
        this.caseView.setOnReceiveStorno(this::onCaseReceiveStorno);
        this.caseView.setOnRestore(this::onCaseRestore);
        this.caseView.setOnDelete(this::onCaseDelete);
        this.caseContainer.setCenter(this.caseView);
        this.delete.setGraphic(Icons.getTrash());
        this.delete.setTooltip(new Tooltip("L\u00f6schen"));
        this.delete.setText("");
        this.delete.setMaxWidth(25.0);
        this.delete.setMinWidth(25.0);
        this.settings.setGraphic(Icons.getGear());
        this.settings.setTooltip(new Tooltip("Einstellungen"));
        this.settings.setText("");
        this.settings.setMaxWidth(25.0);
        this.settings.setMinWidth(25.0);
        this.duplicate.setGraphic(Icons.getFiles());
        this.duplicate.setTooltip(new Tooltip("Duplizieren"));
        this.duplicate.setText("");
        this.duplicate.setMaxWidth(25.0);
        this.duplicate.setMinWidth(25.0);
        this.neu.setGraphic(Icons.getPlus());
        this.neu.setTooltip(new Tooltip("Neu"));
        this.neu.setText("");
        this.neu.setMaxWidth(25.0);
        this.neu.setMinWidth(25.0);
        this.infos.setGraphic(Icons.getInfo());
        this.infos.setTooltip(new Tooltip("Informationen"));
        this.infos.setText("");
        this.infos.setMaxWidth(25.0);
        this.infos.setMinWidth(25.0);
        this.pin = new PinDialog();
    }

    private void onCaseSelect(CasesView.SelectEvent e) {
        Case newCase = null;
        if (this.caseView.hasChanged()) {
            SaveDialog dialog = new SaveDialog();
            SaveDialog.Result result = dialog.ask();
            switch (result) {
                case SAVE: {
                    try {
                        if (this.caseView.saveCurrentCase(this.configuration)) {
                            newCase = this.caseView.loadCase(this.configuration, e.getNewItem());
                            break;
                        }
                        e.refuse();
                    }
                    catch (IntrospectionException | IOException | IllegalAccessException | InvocationTargetException | JAXBException | DatatypeConfigurationException ignore) {
                        e.refuse();
                    }
                    break;
                }
                case DISCARD: {
                    try {
                        newCase = this.caseView.loadCase(this.configuration, e.getNewItem());
                    }
                    catch (IntrospectionException | IOException | IllegalAccessException | InvocationTargetException | JAXBException | DatatypeConfigurationException ignore) {
                        e.refuse();
                    }
                    break;
                }
                case CANCEL: {
                    e.refuse();
                }
            }
        } else {
            try {
                newCase = this.caseView.loadCase(this.configuration, e.getNewItem());
            }
            catch (IntrospectionException | IOException | IllegalAccessException | InvocationTargetException | JAXBException | DatatypeConfigurationException ignore) {
                e.refuse();
            }
        }
        this.duplicate.setDisable(newCase == null);
        this.delete.setDisable(newCase == null || newCase.isDeleted());
        this.updateDeadlineBanner(newCase);
    }

    public void onNeu() throws JAXBException {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setGraphic(null);
        dialog.setTitle("Neue Flutopferhilfen-Mitteilung");
        dialog.setHeaderText("Neue Flutopferhilfen-Mitteilung anlegen");
        dialog.setContentText("Name:");
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            String name = (String)result.get();
            Alert message = new Alert(Alert.AlertType.ERROR);
            message.setResizable(true);
            message.setTitle("Neue Flutopferhilfen-Mitteilung");
            message.setHeaderText("Ung\u00fcltiger Name f\u00fcr die Flutopferhilfen-Mitteilung");
            if (!CASE_NAME.matcher(name).matches()) {
                message.setContentText("Der Name \"" + name + "\" f\u00fcr die Flutopferhilfen-Mitteilung ist ung\u00fcltig. Der Name darf nur aus gro\u00dfen und kleinen Buchstaben, Ziffern, Unterstrichen und Bindestrichen bestehen und h\u00f6chstens 64 Zeichen lang sein");
                message.showAndWait();
            } else if (FORBIDDEN_NAMES.matcher(name).matches()) {
                message.setContentText("Die Namen CON, PRN, AUX, NUL, COM1-COM9 und LPT1-LPT9 sind nicht erlaubt");
                message.showAndWait();
            } else {
                Path destination = this.configuration.getCases().resolve(name);
                if (Files.exists(destination, new LinkOption[0])) {
                    message.setContentText("Eine Flutopferhilfen-Mitteilung mit dem Namen " + name + " existiert bereits");
                    message.showAndWait();
                } else {
                    try {
                        new Case((String)result.get(), this.configuration).save(this.configuration, this.configuration.getCases().resolve(name));
                    }
                    catch (IOException e) {
                        message.setContentText("Eine Flutopferhilfen-Mitteilung mit dem Namen " + name + " kann nicht anglegt werden: " + e.getMessage());
                        message.showAndWait();
                        return;
                    }
                    this.cases2.loadCases(this.configuration);
                    if (!this.caseView.hasChanged()) {
                        this.cases2.select(name);
                    }
                }
            }
        }
    }

    public void onSettings() throws IOException {
        Stage settings = Settings.create(this.configuration);
        settings.initOwner(this.split.getScene().getWindow());
        settings.showAndWait();
        this.pin.reset();
        this.createFooter();
    }

    private void onCaseSave(CaseView.CaseEvent e) {
        Case c = e.getCase();
        try {
            c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
        }
        catch (IOException | JAXBException ex) {
            ex.printStackTrace();
        }
    }

    public void onCaseGuiValidate(CaseView.ValidationEvent e) {
        if (!this.caseView.validate()) {
            if (e.isSend()) {
                Alert message = new Alert(Alert.AlertType.INFORMATION);
                message.setResizable(true);
                message.setTitle("Versand");
                message.setAlertType(Alert.AlertType.ERROR);
                message.setHeaderText("Die Flutopferhilfen-Mitteilung ist nicht valide und kann somit nicht versendet werden");
                message.setContentText("Bitte korrigieren Sie zun\u00e4chst die markierten Felder, bevor Sie die Flutopferhilfen-Mitteilung erneut versenden.");
                message.showAndWait();
            }
            e.consume();
        }
    }

    public void onCaseValidate(CaseView.CaseEvent e) {
        Case c = e.getCase();
        Alert message = new Alert(Alert.AlertType.ERROR);
        message.setResizable(true);
        message.setTitle("Validierung");
        try {
            c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
            Case.Result validate = c.validate();
            if (validate.wasSuccessful()) {
                return;
            }
            message.setAlertType(Alert.AlertType.ERROR);
            message.setHeaderText("Interner Fehler: Das erstellte XML-Dokument zur Flutopferhilfen-Mitteilung enth\u00e4lt Schema-Fehler.");
            message.setContentText("Diese Fehler treten in der Regel dann auf, wenn die Eintr\u00e4ge in den Formularfeldern nicht dem erwarteten Format entsprechen.\n\n" + String.join((CharSequence)"\n", validate.getMessages()));
        }
        catch (IOException | JAXBException | SAXException ex) {
            ex.printStackTrace();
            message.setAlertType(Alert.AlertType.ERROR);
            message.setHeaderText("Interner Fehler beim Validieren der Flutopferhilfen-Mitteilung: " + ex.getMessage());
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ex.printStackTrace(printer);
            message.setContentText(writer.toString());
        }
        message.showAndWait();
        e.consume();
    }

    private void onCaseSend(CaseView.CaseEvent e) {
        Case c = e.getCase();
        Alert message = new Alert(Alert.AlertType.INFORMATION);
        message.setResizable(true);
        message.setTitle("Versand");
        try {
            c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
            Case.Result validate = c.validate();
            if (!validate.wasSuccessful()) {
                message.setAlertType(Alert.AlertType.ERROR);
                message.setHeaderText("Interner Fehler: Das erstellte XML-Dokument zur Flutopferhilfen-Mitteilung enth\u00e4lt Schema-Fehler.");
                message.setContentText("Diese Fehler treten in der Regel dann auf, wenn die Eintr\u00e4ge in den Formularfeldern nicht dem erwarteten Format entsprechen.\n\n" + String.join((CharSequence)"\n", validate.getMessages()));
                e.consume();
            } else {
                Case.Result send = c.send(this.getEric(this.configuration.getTestmerkerVersand().orElse(null)), this.configuration, this.pin);
                c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
                this.caseView.reloadCase();
                if (send.wasSuccessful()) {
                    message.setHeaderText("Die Flutopferhilfen-Mitteilung wurde erfolgreich versendet");
                    message.setContentText("Das Verfahren ElsterKMV empfiehlt, das Protokoll innerhalb von f\u00fcnf Tagen nach der \u00dcbermittlung der Mitteilung abzurufen.");
                } else {
                    message.setAlertType(Alert.AlertType.ERROR);
                    message.setHeaderText("Die Flutopferhilfen-Mitteilung konnte nicht versendet werden");
                    message.setContentText(String.join((CharSequence)"\n", send.getMessages()));
                }
            }
        }
        catch (IOException | JAXBException | SAXException ex) {
            ex.printStackTrace();
            message.setAlertType(Alert.AlertType.ERROR);
            message.setHeaderText("Interner Fehler beim Versenden der Flutopferhilfen-Mitteilung: " + ex.getMessage());
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ex.printStackTrace(printer);
            message.setContentText(writer.toString());
        }
        this.cases2.updateCurrentIcon(c);
        this.duplicate.setDisable(false);
        message.showAndWait();
    }

    private void onCaseReceive(CaseView.CaseEvent e) {
        Case c = e.getCase();
        Alert message = new Alert(Alert.AlertType.INFORMATION);
        message.setResizable(true);
        message.setTitle("Protokollabholung");
        try {
            Case.Result request = c.request(this.getEric(this.configuration.getTestmerkerAbholung().orElse(null)), this.pin, this.configuration);
            c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
            if (request.wasSuccessful()) {
                if (request.getMessages().isEmpty()) {
                    message.setHeaderText("Es liegen noch keine Protokolle vor");
                } else {
                    for (String id : request.getMessages()) {
                        try {
                            Case.Result receive = c.receive(this.getEric(this.configuration.getTestmerkerAbholung().orElse(null)), this.pin, id, this.configuration);
                            c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
                            if (receive.wasSuccessful()) {
                                if (c.getState() == Case.State.ACCEPTED) {
                                    message.setHeaderText("Das abgeholte Protokoll enth\u00e4lt keine Fehlermeldungen");
                                } else {
                                    message.setAlertType(Alert.AlertType.ERROR);
                                    message.setHeaderText("Das abgeholte Protokoll enth\u00e4lt Fehlermeldungen");
                                }
                                List<String> bereitstellungIds = request.getValues();
                                Case.Result request2 = c.commit(this.getEric(this.configuration.getTestmerkerAbholung().orElse(null)), this.pin, bereitstellungIds, this.configuration);
                                c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
                                if (request2.wasSuccessful()) continue;
                                this.showMessage(Alert.AlertType.ERROR, "Protokoll Best\u00e4tigung", "Fehler beim Senden der Protokollbest\u00e4tigung.");
                                continue;
                            }
                            message.setAlertType(Alert.AlertType.ERROR);
                            message.setHeaderText("Das Protokoll konnte nicht abgeholt werden");
                            message.setContentText(String.join((CharSequence)"\n", receive.getMessages()));
                        }
                        catch (IOException | JAXBException | XMLStreamException ex) {
                            ex.printStackTrace();
                            message.setAlertType(Alert.AlertType.ERROR);
                            message.setHeaderText("Interner Fehler beim Abholen des Protokolls: " + ex.getMessage());
                            StringWriter writer = new StringWriter();
                            PrintWriter printer = new PrintWriter(writer);
                            ex.printStackTrace(printer);
                            message.setContentText(writer.toString());
                        }
                    }
                }
            } else {
                message.setAlertType(Alert.AlertType.ERROR);
                message.setHeaderText("Die Protokollanfrage war nicht erfolgreich");
                message.setContentText(String.join((CharSequence)"\n", request.getMessages()));
            }
        }
        catch (IOException | JAXBException ex) {
            ex.printStackTrace();
            message.setAlertType(Alert.AlertType.ERROR);
            message.setHeaderText("Interner Fehler beim Abfrage der Protokolle: " + ex.getMessage());
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ex.printStackTrace(printer);
            message.setContentText(writer.toString());
        }
        this.cases2.updateCurrentIcon(c);
        this.duplicate.setDisable(false);
        message.showAndWait();
        this.updateDeadlineBanner(c);
    }

    private void onCaseCancel(CaseView.CaseEvent e) {
        Case c = e.getCase();
        try {
            Case.Result result = c.createStorno(this.configuration);
            c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
            if (!result.wasSuccessful()) {
                Alert message = new Alert(Alert.AlertType.INFORMATION);
                message.setResizable(true);
                message.setTitle("Stornierung");
                message.setAlertType(Alert.AlertType.ERROR);
                message.setHeaderText("Es konnte keine Stornierung angelegt werden");
                message.setContentText(String.join((CharSequence)"\n", result.getMessages()));
                message.showAndWait();
            }
        }
        catch (IOException | JAXBException ex) {
            ex.printStackTrace();
            Alert message = new Alert(Alert.AlertType.INFORMATION);
            message.setResizable(true);
            message.setTitle("Stornierung");
            message.setAlertType(Alert.AlertType.ERROR);
            message.setHeaderText("Interner Fehler beim Anlegen der Stornierung: " + ex.getMessage());
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ex.printStackTrace(printer);
            message.setContentText(writer.toString());
            message.showAndWait();
        }
        this.cases2.updateCurrentIcon(c);
    }

    private void onCaseGuiValidateStorno(CaseView.ValidationEvent e) {
        if (!this.caseView.validateStorno()) {
            if (e.isSend()) {
                Alert message = new Alert(Alert.AlertType.INFORMATION);
                message.setResizable(true);
                message.setTitle("Versand");
                message.setAlertType(Alert.AlertType.ERROR);
                message.setHeaderText("Die Stornierung der Flutopferhilfen-Mitteilung ist nicht valide und kann somit nicht versendet werden");
                message.setContentText("Bitte korrigieren Sie zun\u00e4chst die markierten Felder, bevor Sie die Stornierung der Flutopferhilfen-Mitteilung erneut versenden.");
                message.showAndWait();
            }
            e.consume();
        }
    }

    private void onCaseValidateStorno(CaseView.CaseEvent e) {
        Case c = e.getCase();
        Alert message = new Alert(Alert.AlertType.INFORMATION);
        message.setResizable(true);
        message.setTitle("Validierung");
        try {
            c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
            Case.Result validate = c.stornoValidate();
            if (validate.wasSuccessful()) {
                return;
            }
            message.setAlertType(Alert.AlertType.ERROR);
            message.setHeaderText("Interner Fehler: Das erstellte XML-Dokument zur Stornierung der Flutopferhilfen-Mitteilung enth\u00e4lt Schema-Fehler.");
            message.setContentText("Diese Fehler treten in der Regel dann auf, wenn die Eintr\u00e4ge in den Formularfeldern nicht dem erwarteten Format entsprechen.\n\n" + String.join((CharSequence)"\n", validate.getMessages()));
        }
        catch (IOException | JAXBException | SAXException ex) {
            ex.printStackTrace();
            message.setAlertType(Alert.AlertType.ERROR);
            message.setHeaderText("Interner Fehler beim Validieren der Stornierung der Flutopferhilfen-Mitteilung: " + ex.getMessage());
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ex.printStackTrace(printer);
            message.setContentText(writer.toString());
        }
        this.cases2.updateCurrentIcon(c);
        message.showAndWait();
        e.consume();
    }

    private void onCaseSendStorno(CaseView.CaseEvent e) {
        Case c = e.getCase();
        Alert message = new Alert(Alert.AlertType.INFORMATION);
        message.setResizable(true);
        message.setTitle("Versand");
        try {
            c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
            Case.Result validate = c.stornoValidate();
            if (!validate.wasSuccessful()) {
                message.setAlertType(Alert.AlertType.ERROR);
                message.setHeaderText("Interner Fehler: Das erstellte XML-Dokument zur Stornierung der Flutopferhilfen-Mitteilung enth\u00e4lt Schema-Fehler.");
                message.setContentText("Diese Fehler treten in der Regel dann auf, wenn die Eintr\u00e4ge in den Formularfeldern nicht dem erwarteten Format entsprechen.\n\n" + String.join((CharSequence)"\n", validate.getMessages()));
                e.consume();
            } else {
                Case.Result send = c.cancel(this.getEric(this.configuration.getTestmerkerVersand().orElse(null)), this.pin, this.configuration);
                c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
                this.caseView.reloadCase();
                if (send.wasSuccessful()) {
                    message.setHeaderText("Die Stornierung Flutopferhilfen-Mitteilung wurde erfolgreich versendet");
                    message.setContentText("Das Verfahren ElsterKMV empfiehlt, das Protokoll innerhalb von f\u00fcnf Tagen nach der \u00dcbermittlung der Mitteilung abzurufen.");
                } else {
                    message.setAlertType(Alert.AlertType.ERROR);
                    message.setHeaderText("Die Stornierung der Flutopferhilfen-Mitteilung konnte nicht versendet werden");
                    message.setContentText(String.join((CharSequence)"\n", send.getMessages()));
                }
            }
        }
        catch (IOException | JAXBException | SAXException ex) {
            ex.printStackTrace();
            message.setAlertType(Alert.AlertType.ERROR);
            message.setHeaderText("Interner Fehler beim Versenden der Stornierung der Flutopferhilfen-Mitteilung: " + ex.getMessage());
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ex.printStackTrace(printer);
            message.setContentText(writer.toString());
        }
        this.cases2.updateCurrentIcon(c);
        message.showAndWait();
    }

    private void onCaseReceiveStorno(CaseView.CaseEvent e) {
        Case c = e.getCase();
        Alert message = new Alert(Alert.AlertType.INFORMATION);
        message.setResizable(true);
        message.setTitle("Protokollabholung");
        try {
            Case.Result request = c.stornoRequest(this.getEric(this.configuration.getTestmerkerAbholung().orElse(null)), this.pin, this.configuration);
            c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
            if (request.wasSuccessful()) {
                if (request.getMessages().isEmpty()) {
                    message.setHeaderText("Es liegen noch keine Protokolle zur Stornierung vor");
                } else {
                    for (String id : request.getMessages()) {
                        try {
                            Case.Result receive = c.stornoReceive(this.getEric(this.configuration.getTestmerkerAbholung().orElse(null)), this.pin, id, this.configuration);
                            c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
                            if (receive.wasSuccessful()) {
                                if (c.getState() == Case.State.CANCELED) {
                                    message.setHeaderText("Das abgeholte Protokoll zur Stornierung enth\u00e4lt keine Fehlermeldungen");
                                } else {
                                    message.setAlertType(Alert.AlertType.ERROR);
                                    message.setHeaderText("Das abgeholte Protokoll zur Stornierung enth\u00e4lt Fehlermeldungen");
                                }
                                List<String> bereitstellungIds = request.getValues();
                                Case.Result request2 = c.commit(this.getEric(this.configuration.getTestmerkerAbholung().orElse(null)), this.pin, bereitstellungIds, this.configuration);
                                c.save(this.configuration, this.configuration.getCases().resolve(c.getName()));
                                if (request2.wasSuccessful()) continue;
                                this.showMessage(Alert.AlertType.ERROR, "Protokoll Best\u00e4tigung", "Fehler beim Senden der Protokollbest\u00e4tigung.");
                                continue;
                            }
                            message.setAlertType(Alert.AlertType.ERROR);
                            message.setHeaderText("Das Protokoll zur Stornierung konnte nicht abgeholt werden");
                            message.setContentText(String.join((CharSequence)"\n", receive.getMessages()));
                        }
                        catch (IOException | JAXBException | XMLStreamException ex) {
                            ex.printStackTrace();
                            message.setAlertType(Alert.AlertType.ERROR);
                            message.setHeaderText("Interner Fehler beim Abholen des Protokolls zur Stornierung: " + ex.getMessage());
                            StringWriter writer = new StringWriter();
                            PrintWriter printer = new PrintWriter(writer);
                            ex.printStackTrace(printer);
                            message.setContentText(writer.toString());
                        }
                    }
                }
            } else {
                message.setAlertType(Alert.AlertType.ERROR);
                message.setHeaderText("Die Protokollanfrage zur Stornierung war nicht erfolgreich");
                message.setContentText(String.join((CharSequence)"\n", request.getMessages()));
            }
        }
        catch (IOException | JAXBException ex) {
            ex.printStackTrace();
            message.setAlertType(Alert.AlertType.ERROR);
            message.setHeaderText("Interner Fehler beim Abfrage der Protokolle zur Stornierung: " + ex.getMessage());
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            ex.printStackTrace(printer);
            message.setContentText(writer.toString());
        }
        this.cases2.updateCurrentIcon(c);
        message.showAndWait();
        this.updateDeadlineBanner(c);
    }

    private void onCaseRestore(CaseView.CaseEvent e) {
        Case caze = e.getCase();
        this.caseView.restoreCase();
        this.cases2.updateCurrentIcon(caze);
        try {
            this.caseView.saveCurrentCase(this.configuration);
        }
        catch (IOException | JAXBException exception) {
            // empty catch block
        }
        this.duplicate.setDisable(false);
        this.delete.setDisable(caze.isDeleted());
        this.updateDeadlineBanner(caze);
    }

    private void onCaseDelete(CaseView.CaseEvent e) {
        Case caze = e.getCase();
        Alert message = new Alert(Alert.AlertType.CONFIRMATION, "Soll die Flutopferhilfen-Mitteilung gel\u00f6scht werden?", ButtonType.YES, ButtonType.NO);
        message.setHeaderText("Flutopferhilfen-Mitteilung l\u00f6schen");
        message.setTitle("Flutopferhilfen-Mitteilung");
        Optional result = message.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.YES) {
            caze.delete(this.configuration);
            this.cases2.loadCases(this.configuration);
        } else {
            e.consume();
        }
        this.updateDeadlineBanner(caze);
    }

    public void onCloseRequest(WindowEvent e) {
        if (this.caseView.hasChanged()) {
            SaveDialog dialog = new SaveDialog();
            switch (dialog.ask()) {
                case SAVE: {
                    try {
                        if (this.caseView.saveCurrentCase(this.configuration)) break;
                        e.consume();
                    }
                    catch (IOException | JAXBException ignore) {
                        e.consume();
                    }
                    break;
                }
                case DISCARD: {
                    break;
                }
                case CANCEL: {
                    e.consume();
                }
            }
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.cases2.loadCases(this.configuration);
        this.createFooter();
    }

    private Eric getEric(String testmerker) {
        if (this.eric == null) {
            Path logpath = Configuration.defaultConfiguration().getParent();
            this.eric = Files.exists(logpath, new LinkOption[0]) ? new Eric(logpath) : new Eric();
        }
        if (this.configuration != null) {
            this.configuration.getTransferTestUrl().ifPresent(url -> this.eric.setProperty("transfer.test.url", (String)url));
            this.configuration.getTransferTestClientcert().ifPresent(cert -> this.eric.setProperty("transfer.test.clientcert", (String)cert));
            this.configuration.getTestTransferVerschluesselungszertifikat().ifPresent(cert -> this.eric.setProperty("test.transfer_verschluesselungszertifikat", (String)cert));
            this.configuration.getProxyHost().ifPresent(host -> this.eric.setProperty("http.proxy_host", (String)host));
            this.configuration.getProxyPort().ifPresent(port -> this.eric.setProperty("http.proxy_port", (String)port));
            this.configuration.getProxyUsername().ifPresent(username -> this.eric.setProperty("http.proxy_username", (String)username));
            this.configuration.getProxyPassword().ifPresent(password -> this.eric.setProperty("http.proxy_password", (String)password));
            this.configuration.getProxyAuth().ifPresent(auth -> this.eric.setProperty("http.proxy_auth", (String)auth));
        }
        if (testmerker != null) {
            this.eric.setProperty("test.testmerker", testmerker);
        }
        return this.eric;
    }

    @Override
    public void close() {
        this.eric.close();
    }

    public void onDelete() {
        Case caze = this.caseView.getCase();
        Alert message = new Alert(Alert.AlertType.WARNING);
        message.setResizable(true);
        message.setTitle("Flutopferhilfen-Mitteilung l\u00f6schen");
        message.setHeaderText("Flutopferhilfen-Mitteilung l\u00f6schen");
        message.getButtonTypes().setAll((ButtonType[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        Optional<ButtonType> decision = Optional.of(ButtonType.YES);
        if (caze.getState() == Case.State.SEND) {
            message.setContentText("Die Flutopferhilfen-Mitteilung wurde bereits versendet und ihre Bearbeitung ist eventuell noch nicht abgeschlossen. Bitte beachten Sie, dass das L\u00f6schen weder die serverseitige Verarbeitung stoppt noch die Flutopferhilfen-Mitteilung storniert.\n\nWollen Sie die Flutopferhilfen-Mitteilung trotzdem l\u00f6schen?");
            decision = message.showAndWait();
        } else if (caze.getState() == Case.State.ACCEPTED) {
            message.setContentText("Die Flutopferhilfen-Mitteilung wurde bereits akzeptiert. Bitte beachten Sie, dass das L\u00f6schen nicht die Flutopferhilfen-Mitteilung storniert.\n\nWollen Sie die Flutopferhilfen-Mitteilung trotzdem l\u00f6schen?");
            decision = message.showAndWait();
        } else if (caze.getState() == Case.State.STORNO_SEND) {
            message.setContentText("Die Stornierung der Flutopferhilfen-Mitteilung wurde bereits versendet und ihre Bearbeitung ist eventuell noch nicht abgeschlossen. Bitte beachten Sie, dass das L\u00f6schen nicht die serverseitige Verarbeitung stoppt.\n\nWollen Sie die Flutopferhilfen-Mitteilung trotzdem l\u00f6schen?");
            decision = message.showAndWait();
        }
        if (decision.isPresent() && decision.get() == ButtonType.YES && this.caseView.deleteCase()) {
            this.cases2.updateCurrentIcon(caze);
            this.duplicate.setDisable(false);
            this.delete.setDisable(caze.isDeleted());
            try {
                this.caseView.saveCurrentCase(this.configuration);
            }
            catch (IOException | JAXBException exception) {
                // empty catch block
            }
        }
        this.updateDeadlineBanner(caze);
    }

    public void onDuplicate() throws JAXBException {
        Case caze = this.caseView.getCase();
        if (caze != null) {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("Flutopferhilfen-Mitteilung duplizieren");
            dialog.setGraphic(null);
            dialog.setHeaderText("Aktuelle Flutopferhilfen-Mitteilung duplizieren");
            dialog.setContentText("Name der Kopie:");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                String name = (String)result.get();
                Alert message = new Alert(Alert.AlertType.ERROR);
                message.setResizable(true);
                message.setTitle("Flutopferhilfen-Mitteilung duplizieren");
                message.setHeaderText("Ung\u00fcltiger Name f\u00fcr die Flutopferhilfen-Mitteilung");
                if (!CASE_NAME.matcher(name).matches()) {
                    message.setContentText("Der Name \"" + name + "\" f\u00fcr die Flutopferhilfen-Mitteilung ist ung\u00fcltig. Der Name darf nur aus gro\u00dfen und kleinen Buchstaben, Ziffern, Unterstrichen und Bindestrichen bestehen und h\u00f6chstens 64 Zeichen lang sein");
                    message.showAndWait();
                } else if (FORBIDDEN_NAMES.matcher(name).matches()) {
                    message.setContentText("Die Namen CON, PRN, AUX, NUL, COM1-COM9 und LPT1-LPT9 sind nicht erlaubt");
                    message.showAndWait();
                } else {
                    Path destination = this.configuration.getCases().resolve(name);
                    if (Files.exists(destination, new LinkOption[0])) {
                        message.setContentText("Eine Flutopferhilfen-Mitteilung mit dem Namen " + name + " existiert bereits");
                        message.showAndWait();
                    } else {
                        try {
                            caze.duplicate(name, this.configuration).save(this.configuration, this.configuration.getCases().resolve(name));
                        }
                        catch (IOException e) {
                            message.setContentText("Eine Flutopferhilfen-Mitteilung mit dem Namen " + name + " kann nicht anglegt werden: " + e.getMessage());
                            message.showAndWait();
                            return;
                        }
                        this.cases2.loadCases(this.configuration);
                        if (!this.caseView.hasChanged()) {
                            this.cases2.select(name);
                        }
                    }
                }
            }
        }
    }

    public void onInfos() {
        try {
            Stage settings = InfosController.create(this.configuration);
            settings.initOwner(this.split.getScene().getWindow());
            settings.setOnCloseRequest(event -> {
                if (!this.configuration.istLizenzAkzeptiert().booleanValue()) {
                    this.onInfoClosed((WindowEvent)event);
                }
            });
            settings.show();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onInfoClosed(WindowEvent e) {
        if (this.configuration.istLizenzAkzeptiert().booleanValue()) {
            e.consume();
        } else {
            Stage stage = (Stage)this.mainPane.getScene().getWindow();
            stage.close();
        }
    }

    public void createFooter() {
        if (this.configuration.getClientCertificate().isEmpty()) {
            Label label = new Label("Es wurde noch kein Zertifikat angegeben. Bitte besorgen Sie sich ein Elster Organisationszertifikat und tragen es in den Einstellungen (Zahnradsymbol \u2699) ein!");
            label.setStyle("-fx-font-size: 14px");
            label.setGraphic(Icons.getExclamationTriangle(Color.BROWN));
            label.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            label.setBackground(new Background(new BackgroundFill(Color.web("PapayaWhip"), null, null)));
            label.setMaxWidth(Double.MAX_VALUE);
            this.mainPane.setBottom(label);
        } else {
            HBox box = new HBox();
            box.setAlignment(Pos.CENTER_LEFT);
            box.setSpacing(10.0);
            LocalDate aktuellesDatum = LocalDate.now();
            LocalDate vergleichsDatum = LocalDate.of(2026, 1, 1);
            Label label = null;
            label = aktuellesDatum.isEqual(vergleichsDatum) || aktuellesDatum.isAfter(vergleichsDatum) ? new Label("Achtung: Diese Anwendung wurde am 31.12.2025 eingestellt.") : new Label("Hinweis: Diese Anwendung wird am 31.12.2025 eingestellt.");
            label.setStyle("-fx-font-size: 14px");
            label.setGraphic(Icons.getExclamationTriangle(Color.BROWN));
            label.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            box.setBackground(new Background(new BackgroundFill(Color.web("PapayaWhip"), null, null)));
            label.setMaxWidth(Double.MAX_VALUE);
            Button b1 = new Button("Information");
            b1.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent e) {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION);
                    alert.setTitle("Information");
                    alert.setHeaderText("Ende des Supports f\u00fcr die FLH-Mitteilung");
                    alert.setContentText("Der offizielle Support f\u00fcr die FLH-Mitteilung endet am 31. Dezember 2025.\nAb diesem Zeitpunkt ist die Abgabe von Mitteilungen und die Abholung von Protokollen nicht mehr garantiert.\n\nWas bedeutet das f\u00fcr Sie?\n\u00b7 Ab dem 31.12.2025 d\u00fcrfen \u00fcber die Anwendung keine Daten versendet werden.\n\u00b7 Alle Protokolle m\u00fcssen vor dem 31.12.2025 abgeholt werden. Beachten Sie, dass Sie bei Fehlern noch Zeit f\u00fcr Korrekturlieferungen einplanen m\u00fcssen.\n\u00b7 Der Kundensupport wird ebenfalls eingestellt.\n\u00b7 Bei Abgaben nach dem 31.12.2025 kann nicht garantiert werden, dass die Daten verarbeitet und Protokolle bereitgestellt werden.\n");
                    alert.getDialogPane().setPrefSize(700.0, 400.0);
                    alert.setResizable(true);
                    alert.showAndWait();
                }
            });
            Button b2 = new Button("Ausblenden");
            b2.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent e) {
                    MainWindowController.this.mainPane.setBottom(null);
                }
            });
            box.getChildren().add(label);
            box.getChildren().add(b1);
            box.getChildren().add(b2);
            this.mainPane.setBottom(box);
        }
    }

    private void updateDeadlineBanner(Case caze) {
        if (caze != null && caze.isOverdue()) {
            Label label = new Label("Nach dem Versand bzw. der Stornierung wurde noch kein Protokoll zum abgeholt!\nDie Protokolle werden nicht dauerhaft zur Abholung bereitgehalten, sondern noch einiger Zeit automatisch wieder gel\u00f6scht.");
            label.setStyle("-fx-font-size: 14px");
            Shape graphic = Icons.getExclamationTriangle(Color.BROWN);
            graphic.setScaleX(2.0);
            graphic.setScaleY(2.0);
            label.setGraphic(graphic);
            label.setGraphicTextGap(30.0);
            label.setPadding(new Insets(10.0, 10.0, 10.0, 30.0));
            label.setBackground(new Background(new BackgroundFill(Color.web("PapayaWhip"), null, null)));
            label.setMaxWidth(Double.MAX_VALUE);
            this.caseContainer.setTop(label);
        } else {
            this.caseContainer.setTop(null);
        }
    }

    private static void showExceptionMessage(String title, String prefix, Exception exception) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setResizable(true);
        alert.setHeaderText(prefix + ": " + exception.getMessage());
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        exception.printStackTrace(printer);
        alert.setContentText(writer.toString());
        alert.showAndWait();
    }

    private void showMessage(Alert.AlertType type, String title, String header) {
        this.showMessage(type, title, header, null);
    }

    private void showMessage(Alert.AlertType type, String title, String header, String content) {
        Alert alert = new Alert(type);
        alert.setTitle(title);
        alert.setResizable(true);
        alert.setHeaderText(header);
        if (content != null) {
            alert.setContentText(content);
        }
        alert.showAndWait();
    }
}

