/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.BetroffenerFall;
import de.elster.flutopferhilfen.gui.FlutopferhilfenMitteilung;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.Verfasser;
import de.finkonsens.rms.kmv.base.v6.BetroffenerFallCType;
import de.finkonsens.rms.kmv.base.v6.VerfasserCType;
import de.finkonsens.rms.kmv.flh.v1.FLHCType;
import de.finkonsens.rms.kmv.km.v6.KontrollmitteilungCType;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javafx.scene.control.Tab;
import javafx.scene.control.Tooltip;
import javax.xml.datatype.DatatypeConfigurationException;

public class Kontrollmitteilung {
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final Verfasser verfasser;
    private final BetroffenerFall betroffenerFall;
    private final FlutopferhilfenMitteilung flutopferhilfenMitteilung;

    public Kontrollmitteilung(KontrollmitteilungCType value, NDHEmpfaengerCType empfaenger, Eric eric) {
        this.verfasser = new Verfasser("Verfasser", value != null ? value.getVerfasser() : null, eric);
        this.verfasser.setTooltip(new Tooltip("Der Verfasser ist die auszahlende Stelle"));
        this.betroffenerFall = new BetroffenerFall(value != null ? value.getBetroffenerFall() : null, empfaenger, eric);
        this.flutopferhilfenMitteilung = new FlutopferhilfenMitteilung(value != null ? value.getFLH() : null, eric);
        this.tabs.add(this.verfasser);
        this.tabs.add(this.betroffenerFall);
        this.tabs.add(this.flutopferhilfenMitteilung);
    }

    public void load(KontrollmitteilungCType value, NDHEmpfaengerCType empfaenger) {
        this.verfasser.load(value != null ? value.getVerfasser() : null);
        this.betroffenerFall.load(value != null ? value.getBetroffenerFall() : null, empfaenger);
        this.flutopferhilfenMitteilung.load(value != null ? value.getFLH() : null);
    }

    public KontrollmitteilungCType save(NDHEmpfaengerCType empfaenger) throws IntrospectionException, InvocationTargetException, IllegalAccessException, DatatypeConfigurationException {
        String meldejahr = this.flutopferhilfenMitteilung.getMeldejahr();
        VerfasserCType verfasser = this.verfasser.save();
        FLHCType flh = this.flutopferhilfenMitteilung.save();
        BetroffenerFallCType betroffenerFall = this.betroffenerFall.save(empfaenger, meldejahr);
        if (verfasser != null || betroffenerFall != null || flh != null) {
            KontrollmitteilungCType result = new KontrollmitteilungCType();
            result.setVerfasser(verfasser);
            result.setBetroffenerFall(betroffenerFall);
            result.setFLH(flh);
            return result;
        }
        return null;
    }

    public boolean hasChanged() {
        return Validators.anyOf(this.verfasser.hasChanged(), this.betroffenerFall.hasChanged(), this.flutopferhilfenMitteilung.hasChanged());
    }

    public boolean validate() {
        return Validators.allOf(this.verfasser.validate(), this.betroffenerFall.validate(), this.flutopferhilfenMitteilung.validate());
    }

    public Stream<Tab> getTabs() {
        return Stream.of(this.verfasser, this.betroffenerFall, this.flutopferhilfenMitteilung);
    }

    public void setReadonly(boolean state) {
        this.verfasser.setReadonly(state);
        this.betroffenerFall.setReadonly(state);
        this.flutopferhilfenMitteilung.setReadonly(state);
    }
}

