/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxController;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.StringContainer;
import de.elster.flutopferhilfen.gui.utils.Validator;
import de.finkonsens.rms.kmv.base.v6.FaxNrCType;
import de.finkonsens.rms.kmv.base.v6.KommunikationCType;
import de.finkonsens.rms.kmv.base.v6.TelefonNrCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Komm
implements ButtonBoxController {
    private final ButtonBox buttonBox;
    private final List<FreiDefTel> freiDefTels = new ArrayList<FreiDefTel>();
    private final List<Tel> tels = new ArrayList<Tel>();
    private final List<FreiDefFax> freiDefFaxs = new ArrayList<FreiDefFax>();
    private final List<Fax> faxs = new ArrayList<Fax>();
    private final List<EMail> emails = new ArrayList<EMail>();

    public Komm(KommunikationCType value) {
        this.buttonBox = new ButtonBox(this, true, Type.values());
        this.load(value);
    }

    public ButtonBox getButtonBox() {
        return this.buttonBox;
    }

    @Override
    public void onButtonClicked(ButtonBox buttonBox, ButtonEnum key) {
        if (Type.FREIDEFTEL.equals(key)) {
            this.addFreiDefTel(null);
        } else if (Type.TEL.equals(key)) {
            this.addTel(null);
        } else if (Type.FREIDEFFAX.equals(key)) {
            this.addFreiDefFax(null);
        } else if (Type.FAX.equals(key)) {
            this.addFax(null);
        } else if (Type.EMAIL.equals(key)) {
            this.addEMail(null);
        }
    }

    @Override
    public void onContentRemoved(ButtonBoxNode node) {
        if (Type.FREIDEFTEL.equals(node.getKey())) {
            this.removeFreiDefTel((FreiDefTel)node);
        } else if (Type.TEL.equals(node.getKey())) {
            this.removeTel((Tel)node);
        } else if (Type.FREIDEFFAX.equals(node.getKey())) {
            this.removeFreiDefFax((FreiDefFax)node);
        } else if (Type.FAX.equals(node.getKey())) {
            this.removeFax((Fax)node);
        } else if (Type.EMAIL.equals(node.getKey())) {
            this.removeEMail((EMail)node);
        }
    }

    private void addFreiDefTel(String value) {
        FreiDefTel freiDefTel = new FreiDefTel(this.buttonBox, value);
        this.freiDefTels.add(freiDefTel);
        this.buttonBox.addContent(freiDefTel);
        this.buttonBox.disableButtons(this.tels.size() + this.freiDefTels.size() >= 2, Type.FREIDEFTEL, Type.TEL);
    }

    private void removeFreiDefTel(FreiDefTel element) {
        this.freiDefTels.remove(element);
        this.buttonBox.disableButtons(this.tels.size() + this.freiDefTels.size() >= 2, Type.FREIDEFTEL, Type.TEL);
    }

    private void addTel(TelefonNrCType value) {
        Tel tel = new Tel(this.buttonBox, value);
        this.tels.add(tel);
        this.buttonBox.addContent(tel);
        this.buttonBox.disableButtons(this.tels.size() + this.freiDefTels.size() >= 2, Type.FREIDEFTEL, Type.TEL);
    }

    private void removeTel(Tel element) {
        this.tels.remove(element);
        this.buttonBox.disableButtons(this.tels.size() + this.freiDefTels.size() >= 2, Type.FREIDEFTEL, Type.TEL);
    }

    private void addFax(FaxNrCType value) {
        Fax fax = new Fax(this.buttonBox, value);
        this.faxs.add(fax);
        this.buttonBox.addContent(fax);
        this.buttonBox.disableButtons(this.faxs.size() + this.freiDefFaxs.size() >= 2, Type.FREIDEFFAX, Type.FAX);
    }

    private void removeFax(Fax element) {
        this.faxs.remove(element);
        this.buttonBox.disableButtons(this.faxs.size() + this.freiDefFaxs.size() >= 2, Type.FREIDEFFAX, Type.FAX);
    }

    private void addFreiDefFax(String value) {
        FreiDefFax freideffax = new FreiDefFax(this.buttonBox, value);
        this.freiDefFaxs.add(freideffax);
        this.buttonBox.addContent(freideffax);
        this.buttonBox.disableButtons(this.faxs.size() + this.freiDefFaxs.size() >= 2, Type.FREIDEFFAX, Type.FAX);
    }

    private void removeFreiDefFax(FreiDefFax element) {
        this.freiDefFaxs.remove(element);
        this.buttonBox.disableButtons(this.faxs.size() + this.freiDefFaxs.size() >= 2, Type.FREIDEFFAX, Type.FAX);
    }

    private void addEMail(String value) {
        EMail email = new EMail(this.buttonBox, value);
        this.emails.add(email);
        this.buttonBox.addContent(email);
        this.buttonBox.disableButtons(this.emails.size() >= 2, Type.EMAIL);
    }

    private void removeEMail(EMail element) {
        this.emails.remove(element);
        this.buttonBox.disableButtons(this.emails.size() >= 2, Type.EMAIL);
    }

    public void load(KommunikationCType value) {
        this.buttonBox.clearMessages();
        while (!this.freiDefTels.isEmpty()) {
            this.buttonBox.removeContent(this.freiDefTels.get(0));
        }
        while (!this.tels.isEmpty()) {
            this.buttonBox.removeContent(this.tels.get(0));
        }
        while (!this.freiDefFaxs.isEmpty()) {
            this.buttonBox.removeContent(this.freiDefFaxs.get(0));
        }
        while (!this.faxs.isEmpty()) {
            this.buttonBox.removeContent(this.faxs.get(0));
        }
        while (!this.emails.isEmpty()) {
            this.buttonBox.removeContent(this.emails.get(0));
        }
        if (value != null) {
            for (Object element : value.getTelOrFreiDefTel()) {
                if (element instanceof TelefonNrCType) {
                    this.addTel((TelefonNrCType)element);
                    continue;
                }
                if (!(element instanceof String)) continue;
                this.addFreiDefTel((String)element);
            }
            for (Object element : value.getFaxOrFreiDefFax()) {
                if (element instanceof FaxNrCType) {
                    this.addFax((FaxNrCType)element);
                    continue;
                }
                if (!(element instanceof String)) continue;
                this.addFreiDefFax((String)element);
            }
            for (String email : value.getEMail()) {
                this.addEMail(email);
            }
        }
        this.buttonBox.setChanged(false);
    }

    public KommunikationCType save() {
        this.buttonBox.setChanged(false);
        if (!(this.tels.isEmpty() && this.freiDefTels.isEmpty() && this.faxs.isEmpty() && this.freiDefFaxs.isEmpty() && this.emails.isEmpty())) {
            Object item;
            KommunikationCType result = new KommunikationCType();
            boolean filled = false;
            for (FreiDefTel freiDefTel : this.freiDefTels) {
                item = freiDefTel.save();
                if (item == null) continue;
                result.getTelOrFreiDefTel().add(item);
                filled = true;
            }
            for (Tel tel : this.tels) {
                item = tel.save();
                if (item == null) continue;
                result.getTelOrFreiDefTel().add(item);
                filled = true;
            }
            for (FreiDefFax freiDefFax : this.freiDefFaxs) {
                item = freiDefFax.save();
                if (item == null) continue;
                result.getFaxOrFreiDefFax().add(item);
                filled = true;
            }
            for (Fax fax : this.faxs) {
                item = fax.save();
                if (item == null) continue;
                result.getFaxOrFreiDefFax().add(item);
                filled = true;
            }
            for (EMail email : this.emails) {
                item = email.save();
                if (item == null) continue;
                result.getEMail().add(email.save());
                filled = true;
            }
            if (filled) {
                return result;
            }
        }
        return null;
    }

    public boolean hasChanged() {
        boolean change = this.buttonBox.hasChanged();
        for (FreiDefTel freiDefTel : this.freiDefTels) {
            change |= freiDefTel.hasChanged();
        }
        for (Tel tel : this.tels) {
            change |= tel.hasChanged();
        }
        for (FreiDefFax freiDefFax : this.freiDefFaxs) {
            change |= freiDefFax.hasChanged();
        }
        for (Fax fax : this.faxs) {
            change |= fax.hasChanged();
        }
        for (EMail eMail : this.emails) {
            change |= eMail.hasChanged();
        }
        return change;
    }

    public boolean validate() {
        return Validators.allOf(this.freiDefTels.stream().map(FreiDefTel::validate).collect(Collectors.toList()).stream().allMatch(b -> b), this.tels.stream().map(Tel::validate).collect(Collectors.toList()).stream().allMatch(b -> b), this.freiDefFaxs.stream().map(FreiDefFax::validate).collect(Collectors.toList()).stream().allMatch(b -> b), this.faxs.stream().map(Fax::validate).collect(Collectors.toList()).stream().allMatch(b -> b), this.emails.stream().map(EMail::validate).collect(Collectors.toList()).stream().allMatch(b -> b));
    }

    public boolean isEmpty() {
        return Validators.allOf(this.freiDefTels.isEmpty(), this.tels.isEmpty(), this.freiDefFaxs.isEmpty(), this.faxs.isEmpty(), this.emails.isEmpty());
    }

    private static enum Type implements ButtonEnum
    {
        FREIDEFTEL("Allg. Telefonnummer"),
        TEL("Telefonnummer"),
        FREIDEFFAX("Allg. Faxnummer"),
        FAX("Faxnummer"),
        EMAIL("E-Mail");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static String[] getNames() {
            return (String[])Arrays.stream(Type.values()).map(Type::toString).toArray(String[]::new);
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }

    private static class FreiDefTel
    extends ButtonBoxNode {
        private final Form<StringContainer> form = Form.of(StringContainer::new, Form.withText("Telefonnummer*", StringContainer::getContent, StringContainer::setContent).required("Die Telefonnummer muss angegeben werden").validate(Validator.forPattern2("[0-9+-/() ]{0,30}", "Die Telefonnummer darf nur aus h\u00f6chstens 30 Ziffern bestehen")));

        public FreiDefTel(ButtonBox parent, String value) {
            super(parent, Type.FREIDEFTEL);
            this.form.load(new StringContainer(value));
            this.setContent(this.form.render());
        }

        public String save() {
            StringContainer save = this.form.save();
            return save != null ? save.getContent() : null;
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean validate() {
            return this.form.validate();
        }
    }

    private static class Tel
    extends ButtonBoxNode {
        private final Form<TelefonNrCType> form2 = Form.of("Telefonnummer*", TelefonNrCType::new, Form.withText("Internat. Vorwahl", TelefonNrCType::getIntVorw, TelefonNrCType::setIntVorw).validate(Validator.forPattern2("[0-9]{0,15}", "Die internationale Vorwahl darf nur aus h\u00f6chstens 15 Ziffern bestehen")), Form.withText("Nat. Vorwahl*", TelefonNrCType::getNatVorw, TelefonNrCType::setNatVorw).validate(Validator.forPattern2("[0-9]{0,10}", "Die nationale Vorwahl darf nur aus h\u00f6chstens 10 Ziffern bestehen")).required("Die nationale Vorwahl muss angegeben werden"), Form.withText("Rufnummer*", TelefonNrCType::getRufNr, TelefonNrCType::setRufNr).validate(Validator.forPattern2("[0-9]{0,13}", "Die Rufnummer darf nur aus h\u00f6chstens 13 Ziffern bestehen")).required("Die Rufnummer muss angegeben werden"), Form.withText("DurchwahlNr", TelefonNrCType::getDurchwahlNr, TelefonNrCType::setDurchwahlNr).validate(Validator.forPattern2("[0-9]{0,13}", "Die Durchwahl darf nur aus h\u00f6chstens 13 Ziffern bestehen")));

        public Tel(ButtonBox parent, TelefonNrCType value) {
            super(parent, Type.TEL);
            this.form2.load(value);
            this.setContent(this.form2.render());
        }

        public TelefonNrCType save() {
            return this.form2.save();
        }

        @Override
        public boolean hasChanged() {
            return this.form2.hasChanged();
        }

        public boolean validate() {
            return this.form2.validate();
        }
    }

    private static class FreiDefFax
    extends ButtonBoxNode {
        private final Form<StringContainer> form = Form.of(StringContainer::new, Form.withText("Faxnummer*", StringContainer::getContent, StringContainer::setContent).required("Die Faxnummer muss angegeben werden").validate(Validator.forPattern2("[0-9+-/() ]{0,30}", "Die Faxnummer darf nur aus h\u00f6chstens 30 Ziffern bestehen")));

        public FreiDefFax(ButtonBox parent, String value) {
            super(parent, Type.FREIDEFFAX);
            this.form.load(new StringContainer(value));
            this.setContent(this.form.render());
        }

        public String save() {
            StringContainer save = this.form.save();
            return save != null ? save.getContent() : null;
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean validate() {
            return this.form.validate();
        }
    }

    private static class Fax
    extends ButtonBoxNode {
        private final Form<FaxNrCType> form = Form.of("Faxnummer*", FaxNrCType::new, Form.withText("Internat. Vorwahl", FaxNrCType::getIntVorw, FaxNrCType::setIntVorw).validate(Validator.forPattern2("[0-9]{0,15}", "Die internationale Vorwahl darf nur aus h\u00f6chstens 15 Ziffern bestehen")), Form.withText("Nat. Vorwahl*", FaxNrCType::getNatVorw, FaxNrCType::setNatVorw).validate(Validator.forPattern2("[0-9]{0,10}", "Die nationale Vorwahl darf nur aus h\u00f6chstens 10 Ziffern bestehen")).required("Die nationale Vorwahl muss angegeben werden"), Form.withText("Rufnummer*", FaxNrCType::getRufNr, FaxNrCType::setRufNr).validate(Validator.forPattern2("[0-9]{0,13}", "Die Rufnummer darf nur aus h\u00f6chstens 13 Ziffern bestehen")).required("Die Rufnummer muss angegeben werden"), Form.withText("DurchwahlNr", FaxNrCType::getDurchwahlNr, FaxNrCType::setDurchwahlNr).validate(Validator.forPattern2("[0-9]{0,13}", "Die Durchwahl darf nur aus h\u00f6chstens 13 Ziffern bestehen")));

        public Fax(ButtonBox parent, FaxNrCType value) {
            super(parent, Type.FAX);
            this.form.load(value);
            this.setContent(this.form.render());
        }

        public FaxNrCType save() {
            return this.form.save();
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean validate() {
            return this.form.validate();
        }
    }

    private static class EMail
    extends ButtonBoxNode {
        private final Form<StringContainer> form = Form.of(StringContainer::new, Form.withText("E-Mail*", StringContainer::getContent, StringContainer::setContent).validate(Validator.maxLength2(128, "Die E-Mail Adresse darf h\u00f6chstens 128 Zeichen lang sein")).validate(Validator.forPattern2("([^@]+)@([^@]+)\\.([^@]{2,})", "Die E-Mail Adresse muss die Form <Name>@<Hostname>.<Domain> haben")).required("Die E-Mail-Adresse muss angegeben werden"));

        public EMail(ButtonBox parent, String value) {
            super(parent, Type.EMAIL);
            this.form.load(new StringContainer(value));
            this.setContent(this.form.render());
        }

        public String save() {
            StringContainer save = this.form.save();
            return save != null ? save.getContent() : null;
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean validate() {
            return this.form.validate();
        }
    }
}

