/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.gui.FlutopferhilfenMitteilungApplication;
import de.elster.flutopferhilfen.gui.Settings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class InfosController {
    @FXML
    private Label version;
    @FXML
    private Button buttonOk;
    @FXML
    private Button ablehnen;
    @FXML
    public TextArea licenses;
    private Configuration configuration;

    public static Stage create(Configuration configuration) throws IOException {
        Stage stage = new Stage();
        stage.setTitle("Informationen");
        stage.initModality(Modality.WINDOW_MODAL);
        FXMLLoader loader = new FXMLLoader(Settings.class.getResource("infos.fxml"));
        stage.setScene(new Scene((Parent)loader.load()));
        InfosController infosController = (InfosController)loader.getController();
        infosController.setConfiguration(configuration);
        infosController.setButtons();
        return stage;
    }

    @FXML
    private void initialize() throws IOException {
        String text;
        try (InputStream stream = FlutopferhilfenMitteilungApplication.class.getResourceAsStream("license.txt");){
            text = stream != null ? new String(stream.readAllBytes(), StandardCharsets.UTF_8) : "Interner Fehler, bitte lesen Sie den Lizenztext, der im Auslieferungspaket beiliegt";
        }
        this.licenses.setText(text);
        this.licenses.setEditable(false);
        this.version.setText("Version: " + Configuration.VERSION_CLIENT);
    }

    public void setButtons() {
        if (this.configuration.istLizenzAkzeptiert().booleanValue()) {
            this.buttonOk.setText("Ok");
            this.ablehnen.setVisible(false);
        }
    }

    public void onOk(ActionEvent e) throws IOException {
        this.configuration.setLinzenzAkzeptiert(true);
        this.configuration.save(Configuration.defaultConfiguration());
        Stage stage = (Stage)this.version.getScene().getWindow();
        stage.close();
    }

    public void onAblehnen(ActionEvent e) throws IOException {
        this.configuration.setLinzenzAkzeptiert(false);
        this.configuration.save(Configuration.defaultConfiguration());
        Stage stage = (Stage)this.version.getScene().getWindow();
        stage.fireEvent(new WindowEvent(stage, WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    public void setConfiguration(Configuration config) {
        this.configuration = config;
    }
}

