/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.InstanceLock;
import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.gui.MainWindowController;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.application.Application;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.Window;

public class FlutopferhilfenMitteilungApplication
extends Application {
    private static Application instance;
    private final List<Image> icons;
    private InstanceLock lock;
    private MainWindowController controller;

    public FlutopferhilfenMitteilungApplication() {
        ArrayList<Image> icons = new ArrayList<Image>(3);
        FlutopferhilfenMitteilungApplication.addIcon(icons, "FlutopferhilfenMitteilung_32.png");
        FlutopferhilfenMitteilungApplication.addIcon(icons, "FlutopferhilfenMitteilung_64.png");
        FlutopferhilfenMitteilungApplication.addIcon(icons, "FlutopferhilfenMitteilung_128.png");
        this.icons = Collections.unmodifiableList(icons);
        instance = this;
    }

    private static void addIcon(List<Image> icons, String name) {
        InputStream stream = FlutopferhilfenMitteilungApplication.class.getResourceAsStream(name);
        if (stream != null) {
            icons.add(new Image(stream));
        }
    }

    @Override
    public void start(Stage stage) throws IOException {
        Alert message = new Alert(Alert.AlertType.ERROR);
        message.setTitle("Flutopferhilfen-Mitteilung");
        try {
            this.lock = new InstanceLock();
        }
        catch (UnsupportedOperationException e2) {
            message.setHeaderText("Eine andere Instanz der Flutopferhilfen-Mitteilung l\u00e4uft bereits");
            message.showAndWait();
            return;
        }
        FXMLLoader fxmlLoader = new FXMLLoader(FlutopferhilfenMitteilungApplication.class.getResource("main-view.fxml"));
        Scene scene = new Scene((Parent)fxmlLoader.load(), 1200.0, 800.0);
        Object title = "Flutopferhilfen-Mitteilung";
        try (InputStream stream = Configuration.class.getResourceAsStream("testmerker.properties");){
            title = stream != null ? (String)title + " (Testversion)" : (String)title + " (Produktivversion)";
        }
        stage.setTitle((String)title);
        stage.setScene(scene);
        this.controller = (MainWindowController)fxmlLoader.getController();
        Optional<Configuration> configuration = Configuration.load(Configuration.defaultConfiguration());
        this.controller.setConfiguration(configuration.orElseGet(Configuration::new));
        stage.setOnCloseRequest(this.controller::onCloseRequest);
        stage.setOnShown(e -> {
            if (configuration.isEmpty() || !((Configuration)configuration.get()).istLizenzAkzeptiert().booleanValue()) {
                this.controller.onInfos();
            }
        });
        Window.getWindows().addListener(this::setIcons);
        stage.show();
    }

    @Override
    public void stop() throws Exception {
        if (this.controller != null) {
            this.controller.close();
        }
        if (this.lock != null) {
            this.lock.close();
        }
    }

    private void setIcons(ListChangeListener.Change<? extends Window> changed) {
        while (changed.next()) {
            for (Window window : changed.getAddedSubList()) {
                if (!(window instanceof Stage)) continue;
                ((Stage)window).getIcons().setAll((Collection<Image>)this.icons);
            }
        }
    }

    public static void main(String[] args) {
        FlutopferhilfenMitteilungApplication.launch(args);
    }

    public static void showDocument(String doc) {
        instance.getHostServices().showDocument(doc);
    }
}

