/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.Bankverbindung;
import de.elster.flutopferhilfen.gui.Rechtsgrund;
import de.elster.flutopferhilfen.gui.ToggleButtons;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.Zahlungen;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.Formatter;
import de.elster.flutopferhilfen.gui.utils.Icons;
import de.elster.flutopferhilfen.gui.utils.StringContainer;
import de.elster.flutopferhilfen.gui.utils.Validator;
import de.finkonsens.rms.kmv.flh.v1.AntragFLHCType;
import de.finkonsens.rms.kmv.flh.v1.FLHCType;
import de.finkonsens.rms.kmv.flh.v1.ZahlungFLHCType;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

public class FlutopferhilfenMitteilung
extends Tab {
    private final VBox content;
    private final RechtsgrundPane rechtsgrund;
    private final FoerderzweckPane foerderzweck;
    private final ZahlungenPane zahlungen;
    private final BankverbindungPane bankverbindung;
    private final AntragPane antrag;

    public FlutopferhilfenMitteilung(FLHCType value, Eric eric) {
        super("Flutopferhilfen");
        ScrollPane scroll = new ScrollPane();
        scroll.setFitToWidth(true);
        scroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.content = new VBox();
        this.content.setFillWidth(true);
        scroll.setContent(this.content);
        this.setContent(scroll);
        ObservableList<Node> panes = this.content.getChildren();
        this.rechtsgrund = new RechtsgrundPane(value);
        panes.add(this.rechtsgrund);
        this.foerderzweck = new FoerderzweckPane(value != null ? value.getFoerderzweck() : null);
        panes.add(this.foerderzweck);
        this.zahlungen = new ZahlungenPane(value);
        panes.add(this.zahlungen);
        this.bankverbindung = new BankverbindungPane(value, eric);
        panes.add(this.bankverbindung);
        this.antrag = new AntragPane(value != null ? value.getAntrag() : null);
        panes.add(this.antrag);
    }

    public void load(FLHCType value) {
        this.rechtsgrund.load(value);
        this.foerderzweck.load(value != null ? value.getFoerderzweck() : null);
        this.zahlungen.load(value);
        this.bankverbindung.load(value);
        this.antrag.load(value != null ? value.getAntrag() : null);
        this.setGraphic(null);
    }

    public FLHCType save() {
        FLHCType result = new FLHCType();
        result.setVersion("1");
        String foerderzweck = this.foerderzweck.save();
        boolean rechtsgrund = this.rechtsgrund.saveInto(result);
        boolean zahlungen = this.zahlungen.saveInto(result);
        boolean bankverbindung = this.bankverbindung.saveInto(result);
        AntragFLHCType antrag = this.antrag.save();
        if (rechtsgrund || zahlungen || antrag != null || bankverbindung || foerderzweck != null) {
            result.setAntrag(antrag);
            result.setFoerderzweck(foerderzweck);
            return result;
        }
        return null;
    }

    public String getMeldejahr() {
        return this.zahlungen.getMeldejahr();
    }

    public boolean hasChanged() {
        return this.rechtsgrund.hasChanged() || this.foerderzweck.hasChanged() || this.zahlungen.hasChanged() || this.bankverbindung.hasChanged() || this.antrag.hasChanged();
    }

    public void setReadonly(boolean state) {
        this.setGraphic(null);
        this.content.setDisable(state);
    }

    public boolean validate() {
        boolean valid = Validators.allOf(this.rechtsgrund.validate(), this.foerderzweck.validate(), this.zahlungen.validate(), this.bankverbindung.validate(), this.antrag.validate());
        this.setGraphic(valid ? Icons.getCheck(Color.GREEN) : Icons.getPencil(Color.RED));
        return valid;
    }

    static class RechtsgrundPane
    extends TitledPane {
        private final Rechtsgrund rechtsgrund;

        public RechtsgrundPane(FLHCType value) {
            super("Rechtsgrund (\u00a715 Abs. 1 Nr. 1-5)*", null);
            this.setCollapsible(false);
            this.setPadding(new Insets(7.0));
            VBox content = new VBox();
            content.getStyleClass().add("form-container");
            content.setFillWidth(true);
            this.setContent(content);
            this.rechtsgrund = new Rechtsgrund(value != null ? value.getRechtsgrund() : null);
            content.getChildren().add(this.rechtsgrund.getButtonBox());
        }

        public void load(FLHCType value) {
            this.rechtsgrund.load(value != null ? value.getRechtsgrund() : null);
        }

        public boolean saveInto(FLHCType value) {
            if (value != null) {
                return this.rechtsgrund.saveInto(value.getRechtsgrund());
            }
            return false;
        }

        public boolean hasChanged() {
            return this.rechtsgrund.hasChanged();
        }

        public boolean validate() {
            return this.rechtsgrund.validate();
        }
    }

    static class FoerderzweckPane
    extends TitledPane {
        private final Form<StringContainer> foerderzweck;

        public FoerderzweckPane(String value) {
            super("F\u00f6rderzweck*", null);
            this.setCollapsible(false);
            this.setPadding(new Insets(7.0));
            this.foerderzweck = Form.of(StringContainer::new, Form.withMultilineText("F\u00f6rderzweck*", 4, StringContainer::getContent, StringContainer::setContent).remainingCounter(400).validate(Validator.maxLength2(400, "Die Angabe darf h\u00f6chstens 400 Zeichen lang sein")).required("Die Angabe des F\u00f6rderzwecks ist notwendig").help("Bezeichnung der F\u00f6rderung/Angabe zum gef\u00f6rderten Objekt.\nBsp.:\n- Bezeichnung der Betriebsst\u00e4tte\n- Vermietungsobjekt\n- Bezeichnung der Ersatzbeschaffung"));
            this.foerderzweck.load(new StringContainer(value));
            Node content = this.foerderzweck.render();
            content.getStyleClass().add("form-container");
            this.setContent(content);
        }

        public void load(String value) {
            this.foerderzweck.load(value != null ? new StringContainer(value) : null);
        }

        public String save() {
            StringContainer save = this.foerderzweck.save();
            return save != null ? save.getContent() : null;
        }

        public boolean hasChanged() {
            return this.foerderzweck.hasChanged();
        }

        public boolean validate() {
            return this.foerderzweck.validate();
        }
    }

    static class ZahlungenPane
    extends TitledPane {
        private final Zahlungen zahlungen;

        public ZahlungenPane(FLHCType value) {
            super("Zahlungen*", null);
            this.setCollapsible(false);
            this.setPadding(new Insets(7.0));
            VBox content = new VBox();
            content.getStyleClass().add("form-container");
            content.setFillWidth(true);
            this.setContent(content);
            ObservableList<Node> children = content.getChildren();
            this.zahlungen = new Zahlungen(value != null ? value.getZahlung() : null);
            children.add(this.zahlungen.getButtonBox());
        }

        public void load(FLHCType value) {
            this.zahlungen.load(value != null ? value.getZahlung() : null);
        }

        public boolean saveInto(FLHCType value) {
            if (value != null) {
                List<ZahlungFLHCType> zahlung = value.getZahlung();
                zahlung.clear();
                zahlung.addAll(this.zahlungen.save());
                return !zahlung.isEmpty();
            }
            return false;
        }

        public String getMeldejahr() {
            return this.zahlungen.getMeldejahr();
        }

        public boolean hasChanged() {
            return this.zahlungen.hasChanged();
        }

        public boolean validate() {
            return this.zahlungen.validate();
        }
    }

    static class BankverbindungPane
    extends TitledPane {
        private final Bankverbindung bankverbindung;

        public BankverbindungPane(FLHCType value, Eric eric) {
            super("Bankverbindung*", null);
            this.setCollapsible(false);
            this.setPadding(new Insets(7.0));
            VBox content = new VBox();
            content.getStyleClass().add("form-container");
            content.setFillWidth(true);
            this.setContent(content);
            ObservableList<Node> children = content.getChildren();
            this.bankverbindung = new Bankverbindung(value, eric);
            children.add(this.bankverbindung.getButtonBox());
        }

        public void load(FLHCType value) {
            this.bankverbindung.load(value);
        }

        public boolean saveInto(FLHCType value) {
            return this.bankverbindung.saveInto(value);
        }

        public boolean hasChanged() {
            return this.bankverbindung.hasChanged();
        }

        public boolean validate() {
            return this.bankverbindung.validate();
        }
    }

    static class AntragPane
    extends TitledPane {
        private final Form<AntragFLHCType> form;
        private final ToggleButtons<Eigentuemergemeinschaft> eigentuemergemeinschaft;

        public AntragPane(AntragFLHCType value) {
            super("Antrag", null);
            this.setCollapsible(false);
            this.setPadding(new Insets(7.0));
            this.form = Form.of(AntragFLHCType::new, Form.withText("Ort", AntragFLHCType::getOrt, AntragFLHCType::setOrt).validate(Validator.maxLength2(72, "Der Ort darf h\u00f6chstens 72 Zeichen lang sein")), Form.withDate("Datum", a -> a != null ? Formatter.convertFromXml(a.getDatum()) : null, (a, v) -> a.setDatum(Formatter.convertToXml(v))).validate(Validator.forDate()), Form.withMultilineText("Besch\u00e4digung", 2, AntragFLHCType::getBeschaedigung, AntragFLHCType::setBeschaedigung).remainingCounter(200).validate(Validator.maxLength2(200, "Die Angaben zum besch\u00e4digten Objekt k\u00f6nnen h\u00f6chstens 200 Zeichen lang sein")).help("Angaben zum besch\u00e4digten Objekt\nBsp.:\n- Besch\u00e4digte Betriebsst\u00e4tte\n- Besch\u00e4digte Vermietungsobjekt"), Form.withMultilineText("Ma\u00dfnahmen", 4, AntragFLHCType::getMassnahme, AntragFLHCType::setMassnahme).remainingCounter(400).validate(Validator.maxLength2(400, "Die Kurzbeschreibung der Ma\u00dfnahme darf h\u00f6chstens 400 Zeichen lang sein")).help("Kurzbeschreibung der Ma\u00dfnahme\nBsp.:\n- Haussanierung\n- Ersatzbau\n"));
            this.eigentuemergemeinschaft = new ToggleButtons<Eigentuemergemeinschaft>("Eigent\u00fcmergemeinschaft", Eigentuemergemeinschaft.values());
            this.load(value);
            VBox content = new VBox();
            content.getStyleClass().add("form-container");
            content.setFillWidth(true);
            ObservableList<Node> children = content.getChildren();
            children.addAll((Node[])new Node[]{this.form.render(), this.eigentuemergemeinschaft});
            this.setContent(content);
        }

        public void load(AntragFLHCType value) {
            this.form.load(value);
            if (value == null || value.isEigentuemergemeinschaft() == null) {
                this.eigentuemergemeinschaft.load(Eigentuemergemeinschaft.NEIN);
            } else {
                this.eigentuemergemeinschaft.load(value.isEigentuemergemeinschaft() != false ? Eigentuemergemeinschaft.JA : Eigentuemergemeinschaft.NEIN);
            }
        }

        public AntragFLHCType save() {
            Optional<Eigentuemergemeinschaft> selected = this.eigentuemergemeinschaft.getSelected();
            AntragFLHCType result = this.form.save();
            if (result == null && (selected.isEmpty() || selected.get() == Eigentuemergemeinschaft.NEIN)) {
                return null;
            }
            if (result == null) {
                result = new AntragFLHCType();
            }
            if (!selected.isEmpty() && selected.get() != Eigentuemergemeinschaft.NEIN) {
                result.setEigentuemergemeinschaft(true);
            }
            return result;
        }

        public boolean hasChanged() {
            return this.eigentuemergemeinschaft.hasChanged() || this.form.hasChanged();
        }

        public boolean validate() {
            return this.form.validate();
        }

        private static enum Eigentuemergemeinschaft {
            JA("Ja"),
            NEIN("Nein");

            private final String display;

            private Eigentuemergemeinschaft(String display) {
                this.display = display;
            }

            public String toString() {
                return this.display;
            }
        }
    }
}

