/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.gui.utils.Icons;
import de.elster.flutopferhilfen.gui.utils.Style;
import de.elster.flutopferhilfen.model.Case;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.shape.Shape;

public class CasesView
extends TreeView<Item> {
    private boolean enableSelectHandler = true;
    private EventHandler<SelectEvent> selectCaseHandler;

    public CasesView() {
        this.getStyleClass().add("cases");
        this.getSelectionModel().selectedItemProperty().addListener(this::onSelectCase);
        this.setCellFactory(t -> new TreeCell<Item>(){

            @Override
            protected void updateItem(Item item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText("");
                    this.setGraphic(null);
                    this.pseudoClassStateChanged(Style.HIGHLIGHTED, false);
                } else {
                    this.setText(item.getName());
                    this.setGraphic(item.getGraphic());
                    this.pseudoClassStateChanged(Style.HIGHLIGHTED, item.isOverdue());
                }
            }
        });
    }

    public void setOnSelectCase(EventHandler<SelectEvent> handler) {
        this.selectCaseHandler = handler;
    }

    private void onSelectCase(ObservableValue<? extends TreeItem<Item>> changed, TreeItem<Item> oldItem, TreeItem<Item> newItem) {
        String newValue;
        String oldValue = oldItem != null ? oldItem.getValue().name : null;
        String string = newValue = newItem != null ? newItem.getValue().name : null;
        if ((oldValue != null && !oldValue.equals(newValue) || newValue != null) && this.selectCaseHandler != null) {
            if (this.enableSelectHandler) {
                this.selectCaseHandler.handle(new SelectEvent(this, oldItem, newItem));
            } else {
                this.enableSelectHandler = true;
            }
        }
    }

    private void rollback(TreeItem<Item> oldItem) {
        this.enableSelectHandler = false;
        this.getSelectionModel().select(oldItem);
    }

    public void updateCurrentIcon(Case caze) {
        TreeItem selectedItem = (TreeItem)this.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            Item value = (Item)selectedItem.getValue();
            boolean overdue = caze.isOverdue();
            selectedItem.setValue(new Item(value.getName(), CasesView.mapState(caze.getState(), caze.getStorno() != null, caze.isDeleted(), overdue), overdue));
        }
    }

    public void loadCases(Configuration configuration) {
        try {
            Item old = this.getSelected();
            TreeItem root = new TreeItem();
            Comparator<Case.Content> compare = Comparator.comparing(c -> c.deleted, (x, y) -> -x.compareTo((Boolean)y));
            compare.thenComparing(c -> c.name);
            List cases = Case.list(configuration).map(Path::getFileName).map(Path::toString).flatMap(s -> Case.getCaseMetaData(configuration.getCases().resolve((String)s)).stream()).sorted(Case.Content::compareTo).collect(Collectors.toList());
            for (Case.Content content : cases) {
                boolean overdue = Case.isOverdue(content.state, content.deleted, Case.parseDate(content.sendDate), Case.parseDate(content.stornoSendDate));
                root.getChildren().add(new TreeItem<Item>(new Item(content.name, CasesView.mapState(content.state, content.storno != null, content.deleted, overdue), overdue)));
            }
            this.enableSelectHandler = false;
            this.setRoot(root);
            this.setShowRoot(false);
            this.enableSelectHandler = false;
            this.select(old != null ? old.name : null);
            this.enableSelectHandler = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Shape mapState(Case.State state, boolean stornoCreated, boolean deleted, boolean overdue) {
        if (deleted) {
            return Icons.getTrash();
        }
        Shape result = null;
        switch (state) {
            case EDIT: {
                result = Icons.getPencil();
                break;
            }
            case SEND: {
                result = Icons.getEnvelope();
                break;
            }
            case ACCEPTED: {
                if (!stornoCreated) {
                    result = Icons.getCheck();
                    break;
                }
                result = Icons.getEraser();
                break;
            }
            case STORNO_SEND: {
                result = Icons.getEnvelopeX();
                break;
            }
            case CANCELED: {
                result = Icons.getXCircle();
                break;
            }
            case FINISHED: {
                result = Icons.getCheck();
            }
        }
        result.pseudoClassStateChanged(Style.HIGHLIGHTED, overdue);
        result.getStyleClass().add("icon");
        return result;
    }

    public Item getSelected() {
        TreeItem selected = (TreeItem)this.getSelectionModel().getSelectedItem();
        if (selected != null) {
            return (Item)selected.getValue();
        }
        return null;
    }

    public void select(String name) {
        MultipleSelectionModel<TreeItem<TreeItem<Item>>> model = this.getSelectionModel();
        if (name == null) {
            model.select(null);
        } else {
            TreeItem<Item> item = this.find(this.getRoot(), name);
            if (item != null) {
                model.select(item);
            }
        }
    }

    private TreeItem<Item> find(TreeItem<Item> root, String name) {
        Item value = root.getValue();
        if (value != null && name.equals(value.getName())) {
            return root;
        }
        for (TreeItem treeItem : root.getChildren()) {
            TreeItem<Item> found = this.find(treeItem, name);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static class Item {
        private final String name;
        private final Shape graphic;
        private final boolean overdue;

        public Item(String name, Shape graphic, boolean overdue) {
            this.name = name;
            this.graphic = graphic;
            this.overdue = overdue;
        }

        public String getName() {
            return this.name;
        }

        public Shape getGraphic() {
            return this.graphic;
        }

        public boolean isOverdue() {
            return this.overdue;
        }
    }

    public static class SelectEvent
    extends Event {
        public static final EventType<SelectEvent> SELECT_EVENT_TYPE = new EventType("SelectEvent");
        private final CasesView origin;
        private final TreeItem<Item> oldItem;
        private final TreeItem<Item> newItem;

        public SelectEvent(CasesView origin, TreeItem<Item> oldItem, TreeItem<Item> newItem) {
            super(SELECT_EVENT_TYPE);
            this.origin = origin;
            this.oldItem = oldItem;
            this.newItem = newItem;
        }

        public String getNewItem() {
            if (this.newItem != null) {
                return this.newItem.getValue().name;
            }
            return null;
        }

        public void refuse() {
            this.origin.rollback(this.oldItem);
        }
    }
}

