/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.Kontrollmitteilung;
import de.elster.flutopferhilfen.gui.Protokoll;
import de.elster.flutopferhilfen.gui.Storno;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.utils.Icons;
import de.elster.flutopferhilfen.model.Case;
import de.elster.flutopferhilfen.model.ElsterXml;
import de.finkonsens.rms.kmv.km.v6.KontrollmitteilungCType;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;

public class CaseView
extends BorderPane {
    private final ButtonBar buttons;
    private final Button save = new Button("Speichern");
    private final Button validate;
    private final Button send;
    private final Button receive;
    private final Button cancel;
    private final Button validateStorno;
    private final Button sendStorno;
    private final Button receiveStorno;
    private final Button restore;
    private final Button delete;
    private final TabPane tabs;
    private final Kontrollmitteilung kontrollmitteilung;
    private final Protokoll protokoll;
    private final Storno storno;
    private final Protokoll stornoProtokoll;
    private Case caze = null;
    private EventHandler<CaseEvent> saveHandler = null;
    private EventHandler<ValidationEvent> guiValidateHandler = null;
    private EventHandler<CaseEvent> validateHandler = null;
    private EventHandler<CaseEvent> sendHandler = null;
    private EventHandler<CaseEvent> receiveHandler = null;
    private EventHandler<CaseEvent> cancelHandler = null;
    private EventHandler<ValidationEvent> guiValidateStornoHandler = null;
    private EventHandler<CaseEvent> validateStornoHandler = null;
    private EventHandler<CaseEvent> sendStornoHandler = null;
    private EventHandler<CaseEvent> receiveStornoHandler = null;
    private EventHandler<CaseEvent> restoreHandler = null;
    private EventHandler<CaseEvent> deleteHandler = null;

    public CaseView(Eric eric) {
        this.save.setOnAction(this::onSave);
        this.validate = new Button("Validieren");
        this.validate.setOnAction(this::onValidate);
        this.send = new Button("Versenden");
        this.send.setOnAction(this::onSend);
        this.receive = new Button("Protokoll abholen");
        this.receive.setOnAction(this::onReceive);
        this.cancel = new Button("Stornieren");
        this.cancel.setOnAction(this::onCancel);
        this.validateStorno = new Button("Storno validieren");
        this.validateStorno.setOnAction(this::onValidateStorno);
        this.sendStorno = new Button("Storno versenden");
        this.sendStorno.setOnAction(this::onSendStorno);
        this.receiveStorno = new Button("Storno-Protokoll abholen");
        this.receiveStorno.setOnAction(this::onReceiveStorno);
        this.restore = new Button("Wiederherstellen");
        this.restore.setOnAction(this::onRestore);
        this.delete = new Button("L\u00f6schen");
        this.delete.setOnAction(this::onDelete);
        this.buttons = new ButtonBar();
        this.buttons.getButtons().addAll((Node[])new Node[]{this.save, this.validate, this.send, this.receive, this.cancel, this.validateStorno, this.sendStorno, this.receiveStorno, this.restore});
        this.buttons.setPadding(new Insets(7.0));
        this.tabs = new TabPane();
        this.tabs.setStyle("-fx-open-tab-animation: NONE; -fx-close-tab-animation: NONE;");
        this.tabs.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.setBottom(this.buttons);
        this.setCenter(this.tabs);
        this.kontrollmitteilung = new Kontrollmitteilung(null, null, eric);
        this.protokoll = new Protokoll("Protokoll", Collections.emptySet(), null, null);
        this.storno = new Storno(null, eric);
        this.stornoProtokoll = new Protokoll("Storno-Protokoll", Collections.emptySet(), null, null);
        ObservableList<Tab> tabs = this.tabs.getTabs();
        tabs.addAll(this.kontrollmitteilung.getTabs().collect(Collectors.toList()));
        tabs.add(this.protokoll);
        tabs.addAll((Collection<Tab>)this.storno.getTabs());
        tabs.add(this.stornoProtokoll);
        this.updateDisabled();
    }

    public void closeCase() throws DatatypeConfigurationException, IntrospectionException, InvocationTargetException, IllegalAccessException {
        this.validate.setGraphic(null);
        this.caze = null;
        this.reloadCase();
    }

    public Case loadCase(Configuration configuration, String newCaze) throws DatatypeConfigurationException, IntrospectionException, InvocationTargetException, IllegalAccessException, JAXBException, IOException {
        if (newCaze != null) {
            this.caze = new Case(configuration.getCases().resolve(newCaze));
            this.reloadCase();
            return this.caze;
        }
        this.closeCase();
        return null;
    }

    public void reloadCase() {
        this.validate.setGraphic(null);
        Optional<Case> caze = Optional.ofNullable(this.caze);
        this.kontrollmitteilung.load(caze.map(Case::getKontrollmitteilung).map(de.elster.flutopferhilfen.model.Kontrollmitteilung::getKontrollmitteilung).orElse(null), caze.map(Case::getKontrollmitteilung).map(de.elster.flutopferhilfen.model.Kontrollmitteilung::getElster).map(ElsterXml::getNdhEmpfaenger).orElse(null));
        this.protokoll.load(caze.map(Case::getTransferTickets).orElse(Collections.emptySet()), caze.map(Case::getSendDate).orElse(null), caze.map(Case::getProtokoll).map(de.elster.flutopferhilfen.model.Protokoll::getProtokoll).orElse(null));
        this.storno.load(caze.map(Case::getStorno).map(de.elster.flutopferhilfen.model.Storno::getStorno).orElse(null));
        this.stornoProtokoll.load(caze.map(Case::getStornoTransferTickets).orElse(Collections.emptySet()), caze.map(Case::getStornoSendDate).orElse(null), caze.map(Case::getStornoProtokoll).map(de.elster.flutopferhilfen.model.Protokoll::getProtokoll).orElse(null));
        this.updateDisabled();
    }

    public boolean saveCurrentCase(Configuration configuration) throws JAXBException, IOException {
        if (this.caze != null) {
            if (this.updateCase()) {
                this.caze.save(configuration, configuration.getCases().resolve(this.caze.getName()));
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean deleteCase() {
        if (this.caze != null) {
            this.caze.setDeleted(true);
            this.updateCase();
            this.updateDisabled();
            return true;
        }
        return false;
    }

    public void restoreCase() {
        if (this.caze != null) {
            this.caze.setDeleted(false);
            this.updateCase();
            this.updateDisabled();
        }
    }

    private void updateDisabled() {
        this.setDisable(this.caze == null);
        if (this.caze != null) {
            Case.State state = this.caze.getState();
            boolean showProtokoll = !this.caze.getTransferTickets().isEmpty() || Optional.ofNullable(this.caze.getProtokoll()).map(de.elster.flutopferhilfen.model.Protokoll::getProtokoll).isPresent();
            boolean hasStorno = Optional.ofNullable(this.caze.getStorno()).map(de.elster.flutopferhilfen.model.Storno::getStorno).isPresent();
            boolean hasStornoProtokoll = !this.caze.getStornoTransferTickets().isEmpty() || Optional.ofNullable(this.caze.getStornoProtokoll()).map(de.elster.flutopferhilfen.model.Protokoll::getProtokoll).isPresent();
            List newTabs = this.kontrollmitteilung.getTabs().collect(Collectors.toList());
            if (showProtokoll) {
                newTabs.add(this.protokoll);
            }
            if (hasStorno) {
                newTabs.addAll(this.storno.getTabs());
            }
            if (hasStornoProtokoll) {
                newTabs.add(this.stornoProtokoll);
            }
            Tab selected = (Tab)this.tabs.getSelectionModel().getSelectedItem();
            ObservableList<Tab> tabs = this.tabs.getTabs();
            tabs.clear();
            tabs.addAll(newTabs);
            this.tabs.getSelectionModel().select(selected);
            ArrayList<Button> newButtons = new ArrayList<Button>();
            if (this.caze.isDeleted()) {
                this.kontrollmitteilung.setReadonly(true);
                this.protokoll.setReadonly(true);
                this.storno.setReadonly(true);
                this.stornoProtokoll.setReadonly(true);
                newButtons.add(this.restore);
                newButtons.add(this.delete);
            } else {
                switch (state) {
                    case EDIT: {
                        this.kontrollmitteilung.setReadonly(false);
                        this.protokoll.setReadonly(false);
                        newButtons.add(this.save);
                        newButtons.add(this.validate);
                        newButtons.add(this.send);
                        break;
                    }
                    case SEND: {
                        this.kontrollmitteilung.setReadonly(true);
                        this.protokoll.setReadonly(false);
                        newButtons.add(this.receive);
                        break;
                    }
                    case ACCEPTED: {
                        this.kontrollmitteilung.setReadonly(true);
                        if (!hasStorno) {
                            this.storno.setReadonly(true);
                            this.protokoll.setReadonly(false);
                            newButtons.add(this.cancel);
                            break;
                        }
                        this.storno.setReadonly(false);
                        this.protokoll.setReadonly(false);
                        newButtons.add(this.save);
                        newButtons.add(this.validateStorno);
                        newButtons.add(this.sendStorno);
                        break;
                    }
                    case STORNO_SEND: {
                        this.kontrollmitteilung.setReadonly(true);
                        this.protokoll.setReadonly(false);
                        this.storno.setReadonly(true);
                        newButtons.add(this.receiveStorno);
                        break;
                    }
                    case CANCELED: {
                        this.kontrollmitteilung.setReadonly(true);
                        this.protokoll.setReadonly(true);
                        this.storno.setReadonly(true);
                        this.stornoProtokoll.setReadonly(false);
                        break;
                    }
                    case FINISHED: {
                        this.kontrollmitteilung.setReadonly(true);
                        this.protokoll.setReadonly(true);
                        this.storno.setReadonly(true);
                        this.stornoProtokoll.setReadonly(false);
                    }
                }
            }
            ObservableList<Node> buttons = this.buttons.getButtons();
            buttons.clear();
            buttons.addAll((Collection<Node>)newButtons);
        }
    }

    private boolean updateCase() {
        try {
            NDHEmpfaengerCType empfaenger = new NDHEmpfaengerCType();
            KontrollmitteilungCType output = this.kontrollmitteilung.save(empfaenger);
            this.caze.getKontrollmitteilung().update(output, empfaenger);
            de.elster.flutopferhilfen.model.Storno storno = this.caze.getStorno();
            if (storno != null) {
                storno.update(this.storno.save());
            }
            return true;
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException | DatatypeConfigurationException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void setOnSave(EventHandler<CaseEvent> handler) {
        this.saveHandler = handler;
    }

    public void setOnGuiValidate(EventHandler<ValidationEvent> handler) {
        this.guiValidateHandler = handler;
    }

    public void setOnValidate(EventHandler<CaseEvent> handler) {
        this.validateHandler = handler;
    }

    public void setOnSend(EventHandler<CaseEvent> handler) {
        this.sendHandler = handler;
    }

    public void setOnReceive(EventHandler<CaseEvent> handler) {
        this.receiveHandler = handler;
    }

    public boolean hasChanged() {
        return Validators.anyOf(this.kontrollmitteilung.hasChanged(), this.storno.hasChanged());
    }

    public void setOnCancel(EventHandler<CaseEvent> handler) {
        this.cancelHandler = handler;
    }

    public void setOnGuiValidateStorno(EventHandler<ValidationEvent> handler) {
        this.guiValidateStornoHandler = handler;
    }

    public void setOnValidateStorno(EventHandler<CaseEvent> handler) {
        this.validateStornoHandler = handler;
    }

    public void setOnSendStorno(EventHandler<CaseEvent> handler) {
        this.sendStornoHandler = handler;
    }

    public void setOnReceiveStorno(EventHandler<CaseEvent> handler) {
        this.receiveStornoHandler = handler;
    }

    public void setOnRestore(EventHandler<CaseEvent> handler) {
        this.restoreHandler = handler;
    }

    public void setOnDelete(EventHandler<CaseEvent> handler) {
        this.deleteHandler = handler;
    }

    private void onSave(Event e) {
        if (this.updateCase() && this.saveHandler != null) {
            this.saveHandler.handle(new CaseEvent(this.caze));
        }
    }

    public boolean validate() {
        return this.kontrollmitteilung.validate();
    }

    public boolean validateStorno() {
        return this.storno.validate();
    }

    private void onValidate(Event e) {
        boolean valid = false;
        ValidationEvent event = new ValidationEvent(false);
        if (this.guiValidateHandler != null) {
            this.guiValidateHandler.handle(event);
            boolean bl = valid = !event.isConsumed();
        }
        if (valid && this.updateCase() && this.validateHandler != null) {
            CaseEvent caseEvent = new CaseEvent(this.caze);
            this.validateHandler.handle(caseEvent);
            valid = !caseEvent.isConsumed();
        }
        this.setValidateImage(valid);
    }

    private void onSend(Event e) {
        boolean valid = false;
        ValidationEvent event = new ValidationEvent(true);
        if (this.guiValidateHandler != null) {
            this.guiValidateHandler.handle(event);
            boolean bl = valid = !event.isConsumed();
        }
        if (valid && this.updateCase() && this.sendHandler != null) {
            CaseEvent caseEvent = new CaseEvent(this.caze);
            this.sendHandler.handle(caseEvent);
            valid = !caseEvent.isConsumed();
        }
        this.setValidateImage(valid);
    }

    private void onReceive(Event e) {
        if (this.receiveHandler != null) {
            this.receiveHandler.handle(new CaseEvent(this.caze));
        }
        this.reloadCase();
    }

    private void onCancel(ActionEvent actionEvent) {
        if (this.cancelHandler != null) {
            this.cancelHandler.handle(new CaseEvent(this.caze));
        }
        this.reloadCase();
    }

    private void onValidateStorno(ActionEvent actionEvent) {
        boolean valid = false;
        ValidationEvent event = new ValidationEvent(false);
        if (this.guiValidateStornoHandler != null) {
            this.guiValidateStornoHandler.handle(event);
            boolean bl = valid = !event.isConsumed();
        }
        if (valid && this.updateCase() && this.validateStornoHandler != null) {
            CaseEvent caseEvent = new CaseEvent(this.caze);
            this.validateStornoHandler.handle(caseEvent);
            valid = !caseEvent.isConsumed();
        }
        this.setStornoValidateImage(valid);
    }

    private void onSendStorno(ActionEvent e) {
        boolean valid = false;
        ValidationEvent event = new ValidationEvent(true);
        if (this.guiValidateStornoHandler != null) {
            this.guiValidateStornoHandler.handle(event);
            boolean bl = valid = !event.isConsumed();
        }
        if (valid && this.updateCase() && this.sendStornoHandler != null) {
            CaseEvent caseEvent = new CaseEvent(this.caze);
            this.sendStornoHandler.handle(caseEvent);
            valid = !caseEvent.isConsumed();
        }
        this.setValidateImage(valid);
    }

    private void onReceiveStorno(ActionEvent e) {
        if (this.receiveStornoHandler != null) {
            this.receiveStornoHandler.handle(new CaseEvent(this.caze));
        }
        this.reloadCase();
    }

    private void onRestore(ActionEvent e) {
        if (this.restoreHandler != null) {
            this.restoreHandler.handle(new CaseEvent(this.caze));
        }
        this.reloadCase();
    }

    private void onDelete(ActionEvent e) {
        if (this.deleteHandler != null) {
            CaseEvent event = new CaseEvent(this.caze);
            this.deleteHandler.handle(event);
            if (!event.isConsumed()) {
                try {
                    this.closeCase();
                }
                catch (IntrospectionException | IllegalAccessException | InvocationTargetException | DatatypeConfigurationException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public Case getCase() {
        return this.caze;
    }

    private void setValidateImage(boolean valid) {
        this.validate.setGraphic(valid ? Icons.getCheckEmpty() : Icons.getXCircleEmpty());
    }

    private void setStornoValidateImage(boolean valid) {
        this.validateStorno.setGraphic(valid ? Icons.getCheckEmpty() : Icons.getXCircleEmpty());
    }

    public static class CaseEvent
    extends Event {
        public static final EventType<CaseEvent> CASE_EVENT_TYPE = new EventType("CaseEvent");
        private final Case caze;

        public CaseEvent(EventType<? extends Event> type, Case caze) {
            super(type);
            this.caze = caze;
        }

        public CaseEvent(Case caze) {
            this(CASE_EVENT_TYPE, caze);
        }

        public Case getCase() {
            return this.caze;
        }
    }

    public static class ValidationEvent
    extends Event {
        public static final EventType<ValidationEvent> VALIDATION_EVENT_TYPE = new EventType("ValidationEvent");
        private final boolean send;

        public ValidationEvent(boolean send) {
            super(VALIDATION_EVENT_TYPE);
            this.send = send;
        }

        public boolean isSend() {
            return this.send;
        }
    }
}

