/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.elster.flutopferhilfen.gui.utils.Identifier;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public abstract class ButtonBoxNode
extends HBox {
    private final ButtonBox parent;
    private final ButtonEnum key;
    private Node content;

    public ButtonBoxNode(ButtonBox parent, ButtonEnum key) {
        this(parent, key, false);
    }

    public ButtonBoxNode(ButtonBox parent, ButtonEnum key, boolean disableRemove) {
        String id = Identifier.toIdentifier(key.toString());
        this.parent = parent;
        this.key = key;
        this.setId("buttonboxnode-" + id);
        this.setFillHeight(true);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setMinWidth(-1.0);
        this.setMaxWidth(-1.0);
        if (!disableRemove) {
            Button delete = new Button("x");
            delete.setId("buttonboxnode-delete-" + id);
            this.getChildren().add(delete);
            delete.setOnAction(this::onDelete);
            this.setPadding(new Insets(0.0, 7.0, 0.0, 0.0));
        }
    }

    private void onDelete(ActionEvent event) {
        this.parent.removeContent(this);
    }

    protected void setContent(Node content) {
        this.content = content;
        this.getChildren().add(0, content);
        ButtonBoxNode.setHgrow(content, Priority.ALWAYS);
    }

    public Node getContent() {
        return this.content;
    }

    public ButtonEnum getKey() {
        return this.key;
    }

    public abstract boolean hasChanged();
}

