/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.gui.ButtonBoxController;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.elster.flutopferhilfen.gui.utils.Icons;
import de.elster.flutopferhilfen.gui.utils.Identifier;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ButtonBox
extends BorderPane {
    private static final String PROPERTY_KEY = "KEY";
    private ButtonBoxController controller;
    private final Map<ButtonEnum, Button> names = new HashMap<ButtonEnum, Button>();
    private final HBox controls;
    private final FlowPane buttons;
    private final VBox header;
    private final VBox content;
    protected boolean changed = false;
    private Label help;

    public ButtonBox(ButtonBoxController controller, boolean top, ButtonEnum ... keys) {
        this.getStyleClass().add("form-container");
        this.buttons = new FlowPane();
        this.buttons.setHgap(5.0);
        this.buttons.setVgap(5.0);
        this.buttons.setAlignment(Pos.TOP_LEFT);
        this.controls = new HBox(this.buttons);
        HBox.setHgrow(this.buttons, Priority.ALWAYS);
        this.header = new VBox();
        this.header.setFillWidth(true);
        this.header.getChildren().add(this.controls);
        this.header.setSpacing(10.0);
        if (top) {
            this.setTop(this.header);
            this.header.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        } else {
            this.setBottom(this.header);
            this.header.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
            this.setPadding(new Insets(0.0, 0.0, 7.0, 0.0));
        }
        this.addButtons(keys);
        this.content = new VBox();
        this.content.setFillWidth(true);
        this.setCenter(this.content);
        this.setController(controller);
    }

    private void addButtons(ButtonEnum ... keys) {
        ObservableList<Node> children = this.buttons.getChildren();
        for (ButtonEnum name : keys) {
            String caption = name.toString();
            Button next = new Button(caption);
            next.setId(Identifier.toIdentifier(caption));
            if (name.getTooltip() != null) {
                Tooltip tooltip = new Tooltip();
                tooltip.setText(name.getTooltip());
                next.setTooltip(tooltip);
            }
            next.getProperties().put(PROPERTY_KEY, name);
            next.setOnAction(this::onButtonClicked);
            children.add(next);
            this.names.put(name, next);
        }
    }

    private void onButtonClicked(ActionEvent e) {
        Button source = (Button)e.getSource();
        Object key = source.getProperties().get(PROPERTY_KEY);
        if (key instanceof ButtonEnum && this.names.containsKey((ButtonEnum)key)) {
            this.controller.onButtonClicked(this, (ButtonEnum)key);
            this.changed = true;
        }
    }

    private void setController(ButtonBoxController controller) {
        this.controller = controller;
    }

    public void addErrorMessage(String message) {
        Label label = new Label(message);
        label.getStyleClass().add("error");
        label.setWrapText(true);
        label.setMinHeight(Double.NEGATIVE_INFINITY);
        label.setGraphic(Icons.getExclamationTriangle());
        this.header.getChildren().add(label);
    }

    public void clearMessages() {
        ObservableList<Node> children = this.header.getChildren();
        children.remove(1, children.size());
        this.help = null;
    }

    public void addHelp(String message) {
        StackPane pane = new StackPane(Icons.getQuestionCircle());
        pane.setOnMouseClicked(e -> this.toggleHelp(message));
        pane.setAlignment(Pos.CENTER);
        pane.setCursor(Cursor.HAND);
        pane.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.controls.getChildren().add(pane);
    }

    private void toggleHelp(String message) {
        if (this.help == null) {
            this.help = new Label(message);
            this.help.getStyleClass().add("help");
            this.help.setGraphic(Icons.getInfo());
            this.help.setWrapText(true);
            this.help.setMinHeight(Double.NEGATIVE_INFINITY);
            this.header.getChildren().add(this.help);
        } else {
            this.header.getChildren().remove(this.help);
            this.help = null;
        }
    }

    public void addContent(ButtonBoxNode node) {
        this.content.getChildren().add(node);
    }

    public void addContent(int index, ButtonBoxNode node) {
        this.content.getChildren().add(index, node);
    }

    public void removeContent(ButtonBoxNode node) {
        if (node != null) {
            this.content.getChildren().remove(node);
            this.controller.onContentRemoved(node);
            this.changed = true;
        }
    }

    public void disableButtons(boolean disabled, ButtonEnum ... keys) {
        for (ButtonEnum key : keys) {
            Button button = this.names.get(key);
            if (button == null) continue;
            button.setDisable(disabled);
        }
    }

    public void visibleButtons(boolean visible, ButtonEnum ... keys) {
        for (ButtonEnum key : keys) {
            Button button = this.names.get(key);
            if (button == null) continue;
            button.setManaged(visible);
            button.setVisible(visible);
        }
    }

    public void setChanged(boolean neuerStatus) {
        this.changed = neuerStatus;
    }

    public boolean hasChanged() {
        boolean change = this.changed;
        for (Node n : this.content.getChildren()) {
            ButtonBoxNode bbn = (ButtonBoxNode)n;
            change |= bbn.hasChanged();
        }
        return change;
    }
}

