/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.Adresse;
import de.elster.flutopferhilfen.gui.BetroffenePerson;
import de.elster.flutopferhilfen.gui.Komm;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.WeiterePerson;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.Formatter;
import de.elster.flutopferhilfen.gui.utils.Icons;
import de.elster.flutopferhilfen.gui.utils.Validator;
import de.finkonsens.rms.kmv.base.v6.AdresseCType;
import de.finkonsens.rms.kmv.base.v6.BetroffenePersonCType;
import de.finkonsens.rms.kmv.base.v6.BetroffenerFallCType;
import de.finkonsens.rms.kmv.base.v6.KommunikationCType;
import de.finkonsens.rms.kmv.base.v6.MaxAdresseCType;
import de.finkonsens.rms.kmv.base.v6.OrdnungsbegriffArtSType;
import de.finkonsens.rms.kmv.base.v6.SteuerfallCType;
import de.finkonsens.rms.kmv.base.v6.WeiterePersonCType;
import java.util.Collections;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

class BetroffenerFall
extends Tab {
    private final VBox content;
    private final BetroffenePersonPane betroffenePerson;
    private final WeiterePersonPane weiterePerson;

    public BetroffenerFall(BetroffenerFallCType value, NDHEmpfaengerCType empfaenger, Eric eric) {
        super("Betroffener Fall");
        ScrollPane scroll = new ScrollPane();
        scroll.setFitToWidth(true);
        scroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.content = new VBox();
        this.content.setFillWidth(true);
        scroll.setContent(this.content);
        this.setContent(scroll);
        ObservableList<Node> panes = this.content.getChildren();
        Optional<SteuerfallCType.BetroffenePerson> betroffenePerson = Optional.ofNullable(value).map(BetroffenerFallCType::getSteuerfall).map(SteuerfallCType::getBetroffenePerson);
        this.betroffenePerson = new BetroffenePersonPane(betroffenePerson.orElse(null), empfaenger, eric);
        panes.add(this.betroffenePerson);
        this.weiterePerson = new WeiterePersonPane(betroffenePerson.map(BetroffenePersonCType::getWeiterePerson).orElse(Collections.emptyList()).stream().findAny().orElse(null), eric);
        panes.add(this.weiterePerson);
    }

    public void load(BetroffenerFallCType value, NDHEmpfaengerCType empfaenger) {
        Optional<BetroffenerFallCType> input = Optional.ofNullable(value);
        Optional<SteuerfallCType.BetroffenePerson> betroffenePerson = input.map(BetroffenerFallCType::getSteuerfall).map(SteuerfallCType::getBetroffenePerson);
        this.betroffenePerson.load(betroffenePerson.orElse(null), empfaenger);
        this.weiterePerson.load(betroffenePerson.map(BetroffenePersonCType::getWeiterePerson).orElse(Collections.emptyList()).stream().findFirst().orElse(null));
        this.setGraphic(null);
    }

    public BetroffenerFallCType save(NDHEmpfaengerCType empfaenger, String meldejahr) {
        BetroffenerFallCType result = new BetroffenerFallCType();
        result.setMeldejahr(meldejahr);
        SteuerfallCType.BetroffenePerson betroffenePerson = this.betroffenePerson.save(empfaenger);
        WeiterePersonCType weiterePerson = this.weiterePerson.save();
        if (betroffenePerson != null) {
            BetroffenerFallCType.Steuerfall steuerfall = new BetroffenerFallCType.Steuerfall();
            steuerfall.setBetroffenePerson(betroffenePerson);
            this.betroffenePerson.getNNatPersSteuernummer().ifPresent(stnr -> {
                SteuerfallCType.Ordnungsbegriff ordnungsbegriff = new SteuerfallCType.Ordnungsbegriff();
                ordnungsbegriff.setArt(OrdnungsbegriffArtSType.ST_NR);
                ordnungsbegriff.setValue((String)stnr);
                steuerfall.setOrdnungsbegriff(ordnungsbegriff);
            });
            if (weiterePerson != null) {
                betroffenePerson.getWeiterePerson().add(weiterePerson);
            }
            result.setSteuerfall(steuerfall);
        } else if (weiterePerson != null) {
            BetroffenerFallCType.Steuerfall steuerfall = new BetroffenerFallCType.Steuerfall();
            SteuerfallCType.BetroffenePerson emptyBetroffenePerson = new SteuerfallCType.BetroffenePerson();
            steuerfall.setBetroffenePerson(emptyBetroffenePerson);
            emptyBetroffenePerson.getWeiterePerson().add(weiterePerson);
            result.setSteuerfall(steuerfall);
        }
        if (betroffenePerson != null || weiterePerson != null) {
            return result;
        }
        return null;
    }

    public boolean hasChanged() {
        return Validators.anyOf(this.betroffenePerson.hasChanged(), this.weiterePerson.hasChanged());
    }

    public void setReadonly(boolean state) {
        this.setGraphic(null);
        this.content.setDisable(state);
    }

    public boolean validate() {
        boolean valid = Validators.allOf(this.betroffenePerson.validate(this.weiterePerson.getType()), this.weiterePerson.validate(this.betroffenePerson.getType()));
        this.setGraphic(valid ? Icons.getCheck(Color.GREEN) : Icons.getPencil(Color.RED));
        return valid;
    }

    static class BetroffenePersonPane
    extends TitledPane {
        private final BetroffenePerson betroffenePerson;
        private final Adresse adresse;
        private final Komm komm;

        public BetroffenePersonPane(SteuerfallCType.BetroffenePerson value, NDHEmpfaengerCType empfaenger, Eric eric) {
            super("Betroffene Person*", null);
            this.setCollapsible(false);
            this.setPadding(new Insets(7.0));
            VBox content = new VBox();
            content.getStyleClass().add("form-container");
            content.setFillWidth(true);
            this.setContent(content);
            ObservableList<Node> children = content.getChildren();
            this.betroffenePerson = new BetroffenePerson(value, empfaenger, eric);
            children.add(this.betroffenePerson.getButtonBox());
            this.adresse = new Adresse(Formatter.mapAdresse(value != null ? value.getAdresse() : null), true);
            children.add(this.adresse.getButtonBox());
            this.komm = new Komm(value != null ? value.getKomm() : null);
            children.add(this.komm.getButtonBox());
        }

        public void load(SteuerfallCType.BetroffenePerson value, NDHEmpfaengerCType empfaenger) {
            this.betroffenePerson.load(value, empfaenger);
            this.adresse.load(Formatter.mapAdresse(value != null ? value.getAdresse() : null));
            this.komm.load(value != null ? value.getKomm() : null);
        }

        private static BetroffenePersonCType.Adresse mapToBetroffenePersonAdresse(AdresseCType value) {
            if (value != null) {
                BetroffenePersonCType.Adresse result = new BetroffenePersonCType.Adresse();
                Optional<AdresseCType> input = Optional.of(value);
                result.setStrAdresse(input.map(AdresseCType::getStrAdresse).orElse(null));
                result.setPostfachAdresse(input.map(AdresseCType::getPostfachAdresse).orElse(null));
                result.setGKAdresse(input.map(AdresseCType::getGKAdresse).orElse(null));
                return result;
            }
            return null;
        }

        public SteuerfallCType.BetroffenePerson save(NDHEmpfaengerCType empfaenger) {
            SteuerfallCType.BetroffenePerson result = this.betroffenePerson.save(empfaenger);
            BetroffenePersonCType.Adresse adresse = BetroffenePersonPane.mapToBetroffenePersonAdresse(this.adresse.save());
            KommunikationCType komm = this.komm.save();
            if (result != null || adresse != null || komm != null) {
                if (result == null) {
                    result = new SteuerfallCType.BetroffenePerson();
                }
                result.setAdresse(adresse);
                result.setKomm(komm);
                return result;
            }
            return null;
        }

        public boolean hasChanged() {
            return Validators.anyOf(this.betroffenePerson.hasChanged(), this.adresse.hasChanged(), this.komm.hasChanged());
        }

        public boolean validate(WeiterePerson.Type weiterePerson) {
            return Validators.allOf(this.betroffenePerson.validate(weiterePerson), this.adresse.validate(false), this.komm.validate());
        }

        public BetroffenePerson.Type getType() {
            return this.betroffenePerson.getPersonType();
        }

        public Optional<String> getNNatPersSteuernummer() {
            return this.betroffenePerson.getNNatPersSteuernummer();
        }
    }

    static class WeiterePersonPane
    extends TitledPane {
        private final WeiterePerson weiterePerson;
        private final Adresse adresse;
        private final Komm komm;

        public WeiterePersonPane(WeiterePersonCType value, Eric eric) {
            super("Weitere Person", null);
            this.setCollapsible(false);
            this.setPadding(new Insets(7.0));
            VBox content = new VBox();
            content.setFillWidth(true);
            content.getStyleClass().add("form-container");
            this.setContent(content);
            ObservableList<Node> children = content.getChildren();
            this.weiterePerson = new WeiterePerson(value, eric);
            children.add(this.weiterePerson.getButtonBox());
            this.adresse = new Adresse(Formatter.mapAdresse(value != null ? value.getAdresse() : null), true);
            children.add(this.adresse.getButtonBox());
            this.komm = new Komm(value != null ? value.getKomm() : null);
            children.add(this.komm.getButtonBox());
        }

        public void load(WeiterePersonCType value) {
            Optional<WeiterePersonCType> input = Optional.ofNullable(value);
            this.weiterePerson.load(value);
            this.adresse.load(input.map(WeiterePersonCType::getAdresse).map(Formatter::mapAdresse).orElse(null));
            this.komm.load(input.map(WeiterePersonCType::getKomm).orElse(null));
        }

        private static MaxAdresseCType mapToMaxAdresse(AdresseCType value) {
            if (value != null) {
                MaxAdresseCType result = new MaxAdresseCType();
                Optional<AdresseCType> input = Optional.of(value);
                result.setStrAdresse(input.map(AdresseCType::getStrAdresse).orElse(null));
                result.setPostfachAdresse(input.map(AdresseCType::getPostfachAdresse).orElse(null));
                result.setGKAdresse(input.map(AdresseCType::getGKAdresse).orElse(null));
                return result;
            }
            return null;
        }

        public WeiterePersonCType save() {
            WeiterePersonCType result = this.weiterePerson.save();
            MaxAdresseCType adresse = WeiterePersonPane.mapToMaxAdresse(this.adresse.save());
            KommunikationCType komm = this.komm.save();
            if (result != null || adresse != null || komm != null) {
                if (result == null) {
                    result = new WeiterePersonCType();
                }
                result.setAdresse(adresse);
                result.setKomm(komm);
                return result;
            }
            return null;
        }

        public boolean hasChanged() {
            return Validators.anyOf(this.weiterePerson.hasChanged(), this.adresse.hasChanged(), this.komm.hasChanged());
        }

        public boolean validate(BetroffenePerson.Type betroffenePerson) {
            boolean empty = Validators.allOf(this.weiterePerson.isEmpty(), this.adresse.isEmpty(), this.komm.isEmpty());
            return Validators.allOf(this.weiterePerson.validate(empty, betroffenePerson), this.adresse.validate(true), this.komm.validate());
        }

        public WeiterePerson.Type getType() {
            return this.weiterePerson.getType();
        }
    }

    static class AllgemeinPane
    extends TitledPane {
        private final Form<BetroffenerFallCType> meldejahr;

        public AllgemeinPane(BetroffenerFallCType value) {
            super("Allgemein", null);
            this.setCollapsible(false);
            this.setPadding(new Insets(7.0));
            VBox content = new VBox();
            content.getStyleClass().add("form-container");
            this.setContent(content);
            ObservableList<Node> children = content.getChildren();
            content.setFillWidth(true);
            this.meldejahr = Form.of(BetroffenerFallCType::new, Form.withText("Meldejahr*", BetroffenerFallCType::getMeldejahr, BetroffenerFallCType::setMeldejahr).validate(Validator.forPattern2("[0-9]{4}", "Das Meldejahr muss eine vierstellige Jahreszahl sein")).help("Das Meldejahr ist das Kalenderjahr, in dem das Datum der Zahlung oder der Zahlungsanordnung liegt.").required("Das Meldejahr muss angegeben werden"));
            this.meldejahr.load(value);
            children.add(this.meldejahr.render());
        }

        public void load(BetroffenerFallCType value) {
            this.meldejahr.load(value);
        }

        public boolean saveInto(BetroffenerFallCType value) {
            if (value != null) {
                return this.meldejahr.saveInto(value);
            }
            return false;
        }

        boolean hasChanged() {
            return this.meldejahr.hasChanged();
        }

        public boolean validate() {
            return this.meldejahr.validate();
        }
    }
}

