/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.elsterxml.schema.v11.NDHEmpfaengerCType;
import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxController;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.NNatPers;
import de.elster.flutopferhilfen.gui.NatPers;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.WeiterePerson;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.finkonsens.rms.kmv.base.v6.BetroffenePersonCType;
import de.finkonsens.rms.kmv.base.v6.NichtNatuerlichePersonCType;
import de.finkonsens.rms.kmv.base.v6.SteuerfallCType;
import java.util.Optional;

public class BetroffenePerson
implements ButtonBoxController {
    private NatPers natPers;
    private NNatPers nnatPers;
    private final Eric eric;
    private final ButtonBox buttonBox;

    public BetroffenePerson(SteuerfallCType.BetroffenePerson value, NDHEmpfaengerCType empfaenger, Eric eric) {
        this.eric = eric;
        this.buttonBox = new ButtonBox(this, true, Type.values());
        this.buttonBox.addHelp("Nicht nat\u00fcrliche bzw. juristische Personen sind insbesondere Kapital- und Personengesellschaften (z.B. GmbH, AG, GbR, OHG).");
        this.load(value, empfaenger);
    }

    public void load(SteuerfallCType.BetroffenePerson value, NDHEmpfaengerCType empfaenger) {
        this.buttonBox.clearMessages();
        if (this.natPers != null) {
            this.buttonBox.removeContent(this.natPers);
        }
        if (this.nnatPers != null) {
            this.buttonBox.removeContent(this.nnatPers);
        }
        if (value != null) {
            BetroffenePersonCType.NatPers natPers = value.getNatPers();
            NichtNatuerlichePersonCType nNatPers = value.getNNatPers();
            if (natPers != null) {
                this.addNatPers(natPers, empfaenger);
            } else if (nNatPers != null) {
                this.addNNatPers(nNatPers);
            }
        }
        this.buttonBox.setChanged(false);
    }

    public SteuerfallCType.BetroffenePerson save(NDHEmpfaengerCType empfaenger) {
        this.buttonBox.setChanged(false);
        if (this.natPers != null) {
            SteuerfallCType.BetroffenePerson result = new SteuerfallCType.BetroffenePerson();
            result.setNatPers(this.natPers.saveToBetroffenePerson(empfaenger));
            return result;
        }
        if (this.nnatPers != null) {
            SteuerfallCType.BetroffenePerson result = new SteuerfallCType.BetroffenePerson();
            result.setNNatPers(this.nnatPers.save(empfaenger));
            return result;
        }
        return null;
    }

    private void addNatPers(BetroffenePersonCType.NatPers value, NDHEmpfaengerCType empfaenger) {
        this.natPers = new NatPers(this.buttonBox, Type.NATPERS, value, empfaenger, true, true, "Zu \u00fcbermitteln ist die Identifikationsnummer des Leistungsempf\u00e4ngers gem\u00e4\u00df \u00a7 139a ff AO. Ist diese nicht bekannt, kann eine maschinelle Anfrage nach der Identifikationsnummer des Leistungsempf\u00e4ngers beim Bundeszentralamt f\u00fcr Steuern (BZSt) gestellt werden.", this.eric);
        this.buttonBox.addContent(this.natPers);
        this.buttonBox.disableButtons(true, Type.NATPERS, Type.NNATPERS);
    }

    private void addNNatPers(NichtNatuerlichePersonCType value) {
        this.nnatPers = new NNatPers(this.buttonBox, Type.NNATPERS, value, false, true, true, "F\u00fcr Personengesellschaften und K\u00f6rperschaften ist die Steuernummer der nicht nat\u00fcrlichen Person anzugeben.\n\nFalls keine Steuernummer vorliegt, muss hier stattdessen die vierstellige Finanzamtsnummer des zust\u00e4ndigen Finanzamts eingetragen werden.", this.eric);
        this.buttonBox.addContent(this.nnatPers);
        this.buttonBox.disableButtons(true, Type.NATPERS, Type.NNATPERS);
    }

    public ButtonBox getButtonBox() {
        return this.buttonBox;
    }

    public Type getPersonType() {
        if (this.natPers != null) {
            return Type.NATPERS;
        }
        if (this.nnatPers != null) {
            return Type.NNATPERS;
        }
        return null;
    }

    public Optional<String> getNNatPersSteuernummer() {
        return Optional.ofNullable(this.nnatPers).flatMap(NNatPers::getSteuernummer);
    }

    @Override
    public void onButtonClicked(ButtonBox buttonBox, ButtonEnum key) {
        if (Type.NATPERS.equals(key)) {
            this.addNatPers(null, null);
        } else if (Type.NNATPERS.equals(key)) {
            this.addNNatPers(null);
        }
    }

    @Override
    public void onContentRemoved(ButtonBoxNode node) {
        if (Type.NATPERS.equals(node.getKey())) {
            this.removeNatPers();
        } else if (Type.NNATPERS.equals(node.getKey())) {
            this.removeNNatPers();
        }
    }

    public boolean hasChanged() {
        boolean change = this.buttonBox.hasChanged();
        if (this.natPers != null) {
            change |= this.natPers.hasChanged();
        }
        if (this.nnatPers != null) {
            change |= this.nnatPers.hasChanged();
        }
        return change;
    }

    private void removeNatPers() {
        this.natPers = null;
        this.buttonBox.disableButtons(false, Type.NATPERS, Type.NNATPERS);
    }

    private void removeNNatPers() {
        this.nnatPers = null;
        this.buttonBox.disableButtons(false, Type.NATPERS, Type.NNATPERS);
    }

    public boolean validate(WeiterePerson.Type weiterePerson) {
        this.buttonBox.clearMessages();
        boolean valid = true;
        if (this.natPers == null && this.nnatPers == null) {
            this.buttonBox.addErrorMessage("Es muss eine betroffene nat\u00fcrliche oder nicht nat\u00fcrliche Person angegeben werden");
            valid = false;
        }
        if (weiterePerson == WeiterePerson.Type.FIRMA && this.natPers == null) {
            this.buttonBox.addErrorMessage("Ist die weitere Person eine Firma, m\u00fcssen Angaben zu einer nat\u00fcrliche Person gemacht werden");
            valid = false;
        }
        return Validators.allOf(valid, this.natPers == null || this.natPers.validate(), this.nnatPers == null || this.nnatPers.validate());
    }

    public static enum Type implements ButtonEnum
    {
        NATPERS("Nat\u00fcrliche Person"),
        NNATPERS("Nicht nat\u00fcrliche Person");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }
}

