/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.gui.Komm;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.Validator;
import de.finkonsens.rms.kmv.base.v6.BearbeiterCType;
import de.finkonsens.rms.kmv.base.v6.KommunikationCType;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public class Bearbeiter
extends VBox {
    private final Form<BearbeiterCType> form = Form.of(BearbeiterCType::new, Form.withText("Bearbeitername", BearbeiterCType::getName, BearbeiterCType::setName).validate(Validator.maxLength2(72, "Der Name des Bearbeiters darf h\u00f6chstens 72 Zeichen lang sein")), Form.withText("Kennzeichnung", BearbeiterCType::getKennzeichnung, BearbeiterCType::setKennzeichnung).validate(Validator.maxLength2(20, "Die Kennzeichnung des Bearbeiters darf h\u00f6chstens 20 Zeichen lang sein")).validate(Validator.minLength2(3, "Die Kennzeichnung des Bearbeiters muss mindestens 3 Zeichen lang sein")));
    private final Komm komm;

    public Bearbeiter(BearbeiterCType value) {
        this.setFillWidth(true);
        ObservableList<Node> children = this.getChildren();
        this.form.load(value);
        children.add(this.form.render());
        this.komm = new Komm(value != null ? value.getKomm() : null);
        children.add(this.komm.getButtonBox());
    }

    public void load(BearbeiterCType value) {
        this.form.load(value);
        this.komm.load(value != null ? value.getKomm() : null);
    }

    public BearbeiterCType save() {
        BearbeiterCType result = new BearbeiterCType();
        KommunikationCType komm = this.komm.save();
        result.setKomm(komm);
        if (this.form.saveInto(result) || komm != null) {
            return result;
        }
        return null;
    }

    public boolean hasChanged() {
        return Validators.anyOf(this.form.hasChanged(), this.komm.hasChanged());
    }

    public boolean validate() {
        return Validators.allOf(this.form.validate(), this.komm.validate());
    }

    public boolean isEmpty() {
        return Validators.allOf(this.form.isEmpty(), this.komm.isEmpty());
    }
}

