/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.eric.Eric;
import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxController;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.Formatter;
import de.elster.flutopferhilfen.gui.utils.Validator;
import de.finkonsens.rms.kmv.flh.v1.BankverbindungFLHCType;
import de.finkonsens.rms.kmv.flh.v1.FLHCType;
import javafx.geometry.Insets;
import javafx.scene.control.Label;

public class Bankverbindung
implements ButtonBoxController {
    private final ButtonBox buttonBox = new ButtonBox(this, false, Type.values());
    private final Eric eric;
    private BankverbindungNode bankverbindung;
    private BarzahlungNode barzahlung;

    public Bankverbindung(FLHCType value, Eric eric) {
        this.buttonBox.addHelp("Liegen mehrere Zahlungen auf unterschiedliche\nBankverbindungen vor, ist die Bankverbindung der j\u00fcngsten\nZahlung anzuweisen.");
        this.eric = eric;
        this.load(value);
    }

    public ButtonBox getButtonBox() {
        return this.buttonBox;
    }

    @Override
    public void onButtonClicked(ButtonBox buttonBox, ButtonEnum key) {
        if (Type.BANKVERBINDUNG.equals(key)) {
            this.addBankverbindung(null);
        } else if (Type.BARZAHLUNG.equals(key)) {
            this.addBarzahlung();
        }
    }

    @Override
    public void onContentRemoved(ButtonBoxNode node) {
        if (Type.BANKVERBINDUNG.equals(node.getKey())) {
            this.removeBankverbindung();
        } else if (Type.BARZAHLUNG.equals(node.getKey())) {
            this.removeBarzahlung();
        }
    }

    private void addBankverbindung(BankverbindungFLHCType value) {
        this.bankverbindung = new BankverbindungNode(this.buttonBox, value, this.eric);
        this.buttonBox.addContent(this.bankverbindung);
        this.buttonBox.disableButtons(true, Type.BANKVERBINDUNG, Type.BARZAHLUNG);
    }

    private void removeBankverbindung() {
        this.bankverbindung = null;
        this.buttonBox.disableButtons(false, Type.BANKVERBINDUNG, Type.BARZAHLUNG);
    }

    private void addBarzahlung() {
        this.barzahlung = new BarzahlungNode(this.buttonBox);
        this.buttonBox.addContent(this.barzahlung);
        this.buttonBox.disableButtons(true, Type.BANKVERBINDUNG, Type.BARZAHLUNG);
    }

    private void removeBarzahlung() {
        this.barzahlung = null;
        this.addBankverbindung(null);
        this.buttonBox.disableButtons(true, Type.BANKVERBINDUNG, Type.BARZAHLUNG);
    }

    public void load(FLHCType value) {
        this.buttonBox.clearMessages();
        if (this.barzahlung != null) {
            this.buttonBox.removeContent(this.barzahlung);
        }
        if (this.bankverbindung != null) {
            this.buttonBox.removeContent(this.bankverbindung);
        }
        if (value != null) {
            BankverbindungFLHCType bankverbindung = value.getBankverbindung();
            Boolean barzahlung = value.isBarzahlung();
            if (bankverbindung != null) {
                this.addBankverbindung(bankverbindung);
            } else if (barzahlung != null && barzahlung.booleanValue()) {
                this.addBarzahlung();
            } else {
                this.addBankverbindung(null);
            }
        }
        this.buttonBox.setChanged(false);
    }

    public boolean saveInto(FLHCType value) {
        this.buttonBox.setChanged(false);
        if (value != null) {
            if (this.bankverbindung != null) {
                value.setBankverbindung(this.bankverbindung.save());
                value.setBarzahlung(null);
                return true;
            }
            if (this.barzahlung != null) {
                value.setBankverbindung(null);
                value.setBarzahlung(true);
                return true;
            }
        }
        return false;
    }

    public boolean hasChanged() {
        boolean change = this.buttonBox.hasChanged();
        if (this.bankverbindung != null) {
            change = change || this.bankverbindung.hasChanged();
        }
        return change;
    }

    public boolean validate() {
        this.buttonBox.clearMessages();
        if (this.bankverbindung == null && this.barzahlung == null) {
            this.buttonBox.addErrorMessage("Es muss entwender eine Bankverbindung angegeben oder eine Barzahlung best\u00e4tigt werden");
            return false;
        }
        if (this.bankverbindung != null) {
            return this.bankverbindung.validate();
        }
        return true;
    }

    public boolean isEmpty() {
        return (this.bankverbindung == null || this.bankverbindung.isEmpty()) && this.barzahlung == null;
    }

    private static enum Type implements ButtonEnum
    {
        BANKVERBINDUNG("Bankverbindung"),
        BARZAHLUNG("Barzahlung");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }

    private static class BankverbindungNode
    extends ButtonBoxNode {
        private final Form<BankverbindungFLHCType> form;

        public BankverbindungNode(ButtonBox parent, BankverbindungFLHCType value, Eric eric) {
            super(parent, Type.BANKVERBINDUNG);
            Form.FieldBuilder[] fieldBuilderArray = new Form.FieldBuilder[4];
            fieldBuilderArray[0] = Form.withText("Kontoinhaber*", BankverbindungFLHCType::getKontoinhaber, BankverbindungFLHCType::setKontoinhaber).validate(Validator.maxLength2(250, "Der Kontoinhaber darf h\u00f6chstens 250 Zeichen lang sein")).required("Der Kontoinhaber muss angegeben werden");
            fieldBuilderArray[1] = Form.withText("IBAN*", v -> Formatter.formatIBAN(v.getIBAN()), (b, v) -> b.setIBAN(Formatter.unformatIBAN(v))).validate(Validator.maxLength2(34, "Die IBAN darf h\u00f6chstens 34 Zeichen lang sein")).required("Die IBAN muss angegeben werden").validate(Validator.forPredicate2(s -> eric.pruefeIBAN(s.replace(" ", "")), "Die IBAN ist fachlich ung\u00fcltig"));
            fieldBuilderArray[2] = Form.withText("BIC", BankverbindungFLHCType::getBIC, BankverbindungFLHCType::setBIC).validate(Validator.maxLength2(11, "Die BIC darf h\u00f6chstens 11 Zeichen lang sein")).validate(Validator.forPredicate2(eric::pruefeBIC, "Die BIC ist fachlich ung\u00fcltig"));
            fieldBuilderArray[3] = Form.withText("Kreditinstitut", BankverbindungFLHCType::getKreditinstitut, BankverbindungFLHCType::setKreditinstitut).validate(Validator.maxLength2(250, "Es d\u00fcrfen h\u00f6chstens 250 Zeichen eingegeben werden"));
            this.form = Form.of(BankverbindungFLHCType::new, fieldBuilderArray);
            this.form.load(value);
            this.setContent(this.form.render());
        }

        public BankverbindungFLHCType save() {
            return this.form.save();
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean isEmpty() {
            return this.form.isEmpty();
        }

        public boolean validate() {
            return this.form.validate();
        }
    }

    private static class BarzahlungNode
    extends ButtonBoxNode {
        public BarzahlungNode(ButtonBox parent) {
            super(parent, Type.BARZAHLUNG);
            Label label = new Label("Hiermit wird best\u00e4tigt, dass die Zahlung ausschlie\u00dflich in Bar erfolgt ist.");
            label.setWrapText(true);
            label.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            label.setMaxWidth(Double.MAX_VALUE);
            this.setContent(label);
        }

        @Override
        public boolean hasChanged() {
            return false;
        }
    }
}

