/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxController;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.paint.Color;

public class Auskunftssperre
implements ButtonBoxController {
    private final TitledPane content;
    private final ButtonBox buttonBox;
    private final List<AuskunftssperreElement> selected = new ArrayList<AuskunftssperreElement>();

    public Auskunftssperre(List<String> values) {
        this.buttonBox = new ButtonBox(this, true, Type.values());
        this.buttonBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.buttonBox.getStyleClass().add("formsfx-form");
        this.content = new TitledPane("Auskunftssperren", this.buttonBox);
        this.content.setBorder(new Border(new BorderStroke(Color.TRANSPARENT, BorderStrokeStyle.NONE, null, BorderWidths.EMPTY, new Insets(0.0, 20.0, 20.0, 20.0))));
        this.content.setCollapsible(false);
        this.load(values);
    }

    public Node getNode() {
        return this.content;
    }

    public void load(List<String> values) {
        this.buttonBox.clearMessages();
        while (!this.selected.isEmpty()) {
            this.buttonBox.removeContent(this.selected.get(0));
        }
        values.stream().map(Type::find).forEach(this::addAuskunftssperre);
        this.buttonBox.setChanged(false);
    }

    public boolean saveInto(List<String> values) {
        this.buttonBox.setChanged(false);
        boolean filled = false;
        for (AuskunftssperreElement node : this.selected) {
            values.add(((Type)node.getKey()).getValue());
            filled = true;
        }
        return filled;
    }

    public boolean hasChanged() {
        return this.buttonBox.hasChanged();
    }

    public boolean isEmpty() {
        return this.selected.isEmpty();
    }

    @Override
    public void onButtonClicked(ButtonBox buttonBox, ButtonEnum key) {
        this.addAuskunftssperre((Type)key);
    }

    @Override
    public void onContentRemoved(ButtonBoxNode node) {
        this.removeAuskunftssperre((Type)node.getKey());
    }

    private void addAuskunftssperre(Type key) {
        AuskunftssperreElement node = new AuskunftssperreElement(this.buttonBox, key);
        this.selected.add(node);
        this.buttonBox.addContent(node);
        this.buttonBox.disableButtons(true, key);
    }

    private void removeAuskunftssperre(Type key) {
        this.selected.removeIf(node -> node.getKey().equals(key));
        this.buttonBox.disableButtons(false, key);
    }

    private static enum Type implements ButtonEnum
    {
        _01("\u00a7 51 Abs. 5 Nr.2 BMG", "01", "Auskunftssperre nach \u00a7 51 Abs. 5 Nr.2 BMG (Adoptionspflegeverh\u00e4ltnis gem. \u00a7 175 Abs. 2 BGB)"),
        _02("\u00a7 42 Abs. 3 Satz 2 BMG", "02", "\u00dcbermittlungssperre nach \u00a7 42 Abs. 3 Satz 2 BMG (\u00dcbermittlung an \u00f6ffentlich-rechtliche Religionsgesellschaften)"),
        _03("\u00a7 51 Abs. 1 BMG", "03", "Auskunftssperre nach \u00a7 51 Abs. 1 BMG auf Antrag des Betroffenen (bei Gefahr f\u00fcr Leben, Gesundheit, pers\u00f6nliche Freiheit oder \u00e4hnliche schutzw\u00fcrdige Interessen)"),
        _05("\u00a7 51 Abs. 5 i.v.m. \u00a7 50 Abs. 2 BMG", "05", "Auskunftssperre nach \u00a7 51 Abs. 5 i.v.m. \u00a7 50 Abs. 2 BMG (bei Alters- oder Ehejubil\u00e4en)"),
        _06("\u00a7 51 Abs. 5 Nr. 1 BMG", "06", "Auskunftssperre nach \u00a7 51 Abs. 5 Nr. 1 BMG (Speicherung erfolgt nur in dem Melderegister der Meldebeh\u00f6rde, in deren Zust\u00e4ndigkeitsbereich die Annahme als Kind verarbeitet wurde - \u00a7 63 Personenstandsgesetz)"),
        _07("\u00a7 50 Abs. 5 i.v.m. \u00a7 50 Abs. 1 BMG", "07", "Auskunftssperre nach \u00a7 50 Abs. 5 i.v.m. \u00a7 50 Abs. 1 BMG (Widerspruchsrecht zur Auskunft an Parteien u.a.)"),
        _10("\u00a7 36 Abs. 2 BMG", "10", "\u00dcbermittlung nach \u00a7 36 Abs. 2 BMG (Widerspruchsrecht gegen \u00dcbermittlung an das Bundesamt f\u00fcr Personalmanagement der Bundeswehr)"),
        _11("\u00a7 51 Abs. 1 BMG", "11", "Auskunftssperre nach \u00a7 51 Abs. 1 BMG auf Veranlassung einer Sicherheitsbeh\u00f6rde (bei Gefahr f\u00fcr Leben, Gesundheit, pers\u00f6nliche Freiheit oder \u00e4hnliche schutzw\u00fcrdige Interessen)"),
        _12("\u00a7 51 Abs. 5 Nr. 1 BMG", "12", "Auskunftssperren nach \u00a7 51 Abs. 5 Nr. 1 BMG (Eintragungen nach dem Transsexuellengesetz - \u00a7 63 Abs. 2 Personenstandsgesetz)"),
        _13("\u00a7 50 Abs. 5 i.V.m. \u00a7 50 Abs. 3 BMG", "13", "Auskunftssperre nach \u00a7 50 Abs. 5 i.V.m. \u00a7 50 Abs. 3 BMG (Widerspruchsrecht zur Auskunft an Adressbuchverlage)");

        private final String display;
        private final String value;
        private final String message;

        private Type(String display, String value, String message) {
            this.display = display;
            this.value = value;
            this.message = message;
        }

        public String toString() {
            return this.display;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public String getTooltip() {
            return this.message;
        }

        public static Type find(String value) {
            return Arrays.stream(Type.values()).filter(t -> t.value.equals(value)).findAny().orElse(null);
        }
    }

    private static class AuskunftssperreElement
    extends ButtonBoxNode {
        public AuskunftssperreElement(ButtonBox parent, Type key) {
            super(parent, key);
            Label label = new Label(key.getTooltip());
            label.setWrapText(true);
            label.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            label.setMaxWidth(Double.MAX_VALUE);
            this.setContent(label);
        }

        @Override
        public boolean hasChanged() {
            return false;
        }
    }
}

