/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.gui;

import de.elster.flutopferhilfen.gui.ButtonBox;
import de.elster.flutopferhilfen.gui.ButtonBoxController;
import de.elster.flutopferhilfen.gui.ButtonBoxNode;
import de.elster.flutopferhilfen.gui.Validators;
import de.elster.flutopferhilfen.gui.utils.ButtonEnum;
import de.elster.flutopferhilfen.gui.utils.Form;
import de.elster.flutopferhilfen.gui.utils.Staat;
import de.elster.flutopferhilfen.gui.utils.Validator;
import de.finkonsens.rms.kmv.base.v6.AdresseCType;
import de.finkonsens.rms.kmv.base.v6.GKAdresseCType;
import de.finkonsens.rms.kmv.base.v6.PostfachAdresseCType;
import de.finkonsens.rms.kmv.base.v6.StrassenAdresseCType;
import java.util.Arrays;

public class Adresse
implements ButtonBoxController {
    private final boolean enableAuslandsadresse;
    private final ButtonBox buttonBox;
    private StrAdresse strAdresse;
    private AuslandsAdresse auslandsAdresse;
    private PostfachAdresse postfachAdresse;
    private GKAdresse gkAdresse;

    public Adresse(AdresseCType value, boolean enableAuslandsadresse) {
        this.enableAuslandsadresse = enableAuslandsadresse;
        this.buttonBox = new ButtonBox(this, enableAuslandsadresse, Type.values(enableAuslandsadresse));
        this.buttonBox.visibleButtons(enableAuslandsadresse, Type.STRASSENADRESSE);
        this.load(value);
    }

    public ButtonBox getButtonBox() {
        return this.buttonBox;
    }

    @Override
    public void onButtonClicked(ButtonBox buttonBox, ButtonEnum key) {
        if (Type.STRASSENADRESSE.equals(key)) {
            this.addStrAdresse(null);
        } else if (Type.AUSLANDSADRESSE.equals(key)) {
            this.addAuslandsAdresse(null);
        } else if (Type.POSTFACHADRESSE.equals(key)) {
            this.addPostfachAdresse(null);
        } else if (Type.GROSSKUNDENADRESSE.equals(key)) {
            this.addGkAdresse(null);
        }
    }

    private void addStrAdresse(StrassenAdresseCType strAdresse) {
        this.strAdresse = new StrAdresse(this.buttonBox, strAdresse, this.enableAuslandsadresse);
        this.buttonBox.addContent(0, this.strAdresse);
        this.disableButtons();
    }

    private void addAuslandsAdresse(StrassenAdresseCType auslandsAdresse) {
        this.auslandsAdresse = new AuslandsAdresse(this.buttonBox, auslandsAdresse);
        this.buttonBox.addContent(0, this.auslandsAdresse);
        this.disableButtons();
    }

    private void addPostfachAdresse(PostfachAdresseCType postfachAdresse) {
        this.postfachAdresse = new PostfachAdresse(this.buttonBox, postfachAdresse);
        this.buttonBox.addContent(this.postfachAdresse);
        this.disableButtons();
    }

    private void addGkAdresse(GKAdresseCType gkAdresse) {
        this.gkAdresse = new GKAdresse(this.buttonBox, gkAdresse);
        this.buttonBox.addContent(this.gkAdresse);
        this.disableButtons();
    }

    private void disableButtons() {
        this.buttonBox.disableButtons(this.strAdresse != null || this.auslandsAdresse != null, Type.STRASSENADRESSE, Type.AUSLANDSADRESSE);
        this.buttonBox.disableButtons(this.strAdresse == null && this.auslandsAdresse == null || this.postfachAdresse != null, Type.POSTFACHADRESSE);
        this.buttonBox.disableButtons(this.strAdresse == null && this.auslandsAdresse == null || this.gkAdresse != null, Type.GROSSKUNDENADRESSE);
    }

    @Override
    public void onContentRemoved(ButtonBoxNode node) {
        if (Type.STRASSENADRESSE.equals(node.getKey())) {
            this.removeStrAdresse();
        } else if (Type.AUSLANDSADRESSE.equals(node.getKey())) {
            this.removeAuslandsAdresse();
        } else if (Type.POSTFACHADRESSE.equals(node.getKey())) {
            this.removePostfachAdresse();
        } else if (Type.GROSSKUNDENADRESSE.equals(node.getKey())) {
            this.removeGkAdresse();
        }
    }

    private void removeStrAdresse() {
        this.strAdresse = null;
        this.disableButtons();
    }

    private void removeAuslandsAdresse() {
        this.auslandsAdresse = null;
        this.disableButtons();
    }

    private void removePostfachAdresse() {
        this.postfachAdresse = null;
        this.disableButtons();
    }

    private void removeGkAdresse() {
        this.gkAdresse = null;
        this.disableButtons();
    }

    public void load(AdresseCType value) {
        this.buttonBox.clearMessages();
        this.buttonBox.removeContent(this.strAdresse);
        this.buttonBox.removeContent(this.auslandsAdresse);
        this.buttonBox.removeContent(this.postfachAdresse);
        this.buttonBox.removeContent(this.gkAdresse);
        if (value != null) {
            StrassenAdresseCType strAdresse = value.getStrAdresse();
            if (strAdresse != null) {
                GKAdresseCType gkAdresse;
                String auslandsPLZ = strAdresse.getAuslandsPLZ();
                if (auslandsPLZ != null) {
                    this.addAuslandsAdresse(strAdresse);
                } else {
                    this.addStrAdresse(strAdresse);
                }
                PostfachAdresseCType postfachAdresse = strAdresse.getPostfachAdresse();
                if (postfachAdresse != null) {
                    this.addPostfachAdresse(postfachAdresse);
                }
                if ((gkAdresse = strAdresse.getGKAdresse()) != null) {
                    this.addGkAdresse(gkAdresse);
                }
            } else if (!this.enableAuslandsadresse) {
                this.addStrAdresse(null);
            }
        } else if (!this.enableAuslandsadresse) {
            this.addStrAdresse(null);
        }
        this.disableButtons();
        this.buttonBox.setChanged(false);
    }

    public AdresseCType save() {
        GKAdresseCType gkAdresse;
        PostfachAdresseCType postfachAdresse;
        this.buttonBox.setChanged(false);
        StrassenAdresseCType adresse = null;
        if (this.strAdresse != null) {
            adresse = this.strAdresse.save();
        } else if (this.auslandsAdresse != null) {
            adresse = this.auslandsAdresse.save();
        }
        if (this.postfachAdresse != null && (postfachAdresse = this.postfachAdresse.save()) != null) {
            if (adresse == null) {
                adresse = new StrassenAdresseCType();
            }
            adresse.setPostfachAdresse(postfachAdresse);
        }
        if (this.gkAdresse != null && (gkAdresse = this.gkAdresse.save()) != null) {
            if (adresse == null) {
                adresse = new StrassenAdresseCType();
            }
            adresse.setGKAdresse(gkAdresse);
        }
        if (adresse != null) {
            AdresseCType result = new AdresseCType();
            result.setStrAdresse(adresse);
            return result;
        }
        return null;
    }

    public boolean hasChanged() {
        boolean change = this.buttonBox.hasChanged();
        if (this.strAdresse != null) {
            change |= this.strAdresse.hasChanged();
        }
        if (this.auslandsAdresse != null) {
            change |= this.auslandsAdresse.hasChanged();
        }
        if (this.postfachAdresse != null) {
            change |= this.postfachAdresse.hasChanged();
        }
        if (this.gkAdresse != null) {
            change |= this.gkAdresse.hasChanged();
        }
        return change;
    }

    public boolean validate(boolean optional) {
        this.buttonBox.clearMessages();
        boolean valid = true;
        if (!optional && this.strAdresse == null && this.auslandsAdresse == null) {
            if (this.enableAuslandsadresse) {
                this.buttonBox.addErrorMessage("Es muss eine Stra\u00dfen- oder Auslandsadresse angegeben werden");
            } else {
                this.buttonBox.addErrorMessage("Es muss eine Stra\u00dfenadresse angegeben werden");
            }
            valid = false;
        }
        return Validators.allOf(valid, this.strAdresse == null || this.strAdresse.validate(), this.auslandsAdresse == null || this.auslandsAdresse.validate(), this.postfachAdresse == null || this.postfachAdresse.validate(), this.gkAdresse == null || this.gkAdresse.validate());
    }

    public boolean isEmpty() {
        return Validators.allOf(this.strAdresse == null || this.strAdresse.isEmpty(), this.auslandsAdresse == null || this.auslandsAdresse.isEmpty(), this.postfachAdresse == null || this.postfachAdresse.isEmpty(), this.gkAdresse == null || this.gkAdresse.isEmpty());
    }

    private static enum Type implements ButtonEnum
    {
        STRASSENADRESSE("Stra\u00dfenadresse"),
        POSTFACHADRESSE("Postfachadresse"),
        GROSSKUNDENADRESSE("Gro\u00dfkundenadresse"),
        AUSLANDSADRESSE("Auslandsadresse");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Type[] values(boolean enableAuslandsadresse) {
            if (enableAuslandsadresse) {
                return Type.values();
            }
            return (Type[])Arrays.stream(Type.values()).filter(v -> !AUSLANDSADRESSE.equals(v)).toArray(Type[]::new);
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }

    private static class StrAdresse
    extends ButtonBoxNode {
        private final Form<StrassenAdresseCType> form = Form.of("Stra\u00dfenadresse*", StrassenAdresseCType::new, Form.withText("Stra\u00dfe*", StrassenAdresseCType::getStr, StrassenAdresseCType::setStr).validate(Validator.maxLength2(72, "Die Angabe zur Stra\u00dfe darf h\u00f6chstens 72 Zeichen lang sein")).validate(Validator.forPattern2(".*\\p{L}.*", "Der Stra\u00dfenname muss mindestens einen Buchstaben enthalten")).required("Die Stra\u00dfe muss angegeben werden"), Form.withText("Hausnummer", StrassenAdresseCType::getHausnummer, StrassenAdresseCType::setHausnummer).validate(Validator.forPattern2("[0-9]{0,5}", "Die Hausnummer darf nur aus h\u00f6chstens f\u00fcnf Ziffern bestehen")), Form.withText("Hausnr.-Zusatz", StrassenAdresseCType::getHNrZusatz, StrassenAdresseCType::setHNrZusatz).validate(Validator.maxLength2(20, "Die Zusatzangabe zur Hausnummer darf h\u00f6chstens 20 Zeichen lang sein")), Form.withText("Adresserg\u00e4nzung", StrassenAdresseCType::getAdressergaenzung, StrassenAdresseCType::setAdressergaenzung).validate(Validator.maxLength2(46, "Die Adresserg\u00e4nzung darf h\u00f6chstens 46 Zeichen lang sein")), Form.withText("Ort*", StrassenAdresseCType::getOrt, StrassenAdresseCType::setOrt).validate(Validator.maxLength2(72, "Die Angabe zum Ort darf h\u00f6chstens 72 Zeichen lang sein")).validate(Validator.forPattern2("[\\p{L}\\p{P}\\p{Zs}\\p{Nd}]*", "Die Ortsangabe enth\u00e4lt ung\u00fcltige Zeichen")).required("Der Ort muss angegeben werden"), Form.withText("Postleitzahl*", StrassenAdresseCType::getPLZ, StrassenAdresseCType::setPLZ).validate(Validator.forPattern2("[0-9]{5}", "Die Postleitzahl muss aus genau 5 Ziffern bestehen")).required("Die Postleitzahl muss angegeben werden"));

        public StrAdresse(ButtonBox parent, StrassenAdresseCType value, boolean enableAuslandsadresse) {
            super(parent, Type.STRASSENADRESSE, !enableAuslandsadresse);
            this.form.load(value);
            this.setContent(this.form.render());
        }

        public StrassenAdresseCType save() {
            return this.form.save();
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean validate() {
            return this.form.validate();
        }

        public boolean isEmpty() {
            return this.form.isEmpty();
        }
    }

    private static class AuslandsAdresse
    extends ButtonBoxNode {
        private final Form<StrassenAdresseCType> form = Form.of("Auslandsadresse*", StrassenAdresseCType::new, Form.withText("Stra\u00dfe*", StrassenAdresseCType::getStr, StrassenAdresseCType::setStr).validate(Validator.maxLength2(72, "Die Angabe zur Stra\u00dfe darf h\u00f6chstens 72 Zeichen lang sein")).required("Die Stra\u00dfe muss angegeben werden"), Form.withText("Hausnummer", StrassenAdresseCType::getHausnummer, StrassenAdresseCType::setHausnummer).validate(Validator.forPattern2("[0-9]{0,5}", "Die Hausnummer darf nur aus h\u00f6chstens f\u00fcnf Ziffern bestehen")), Form.withText("Hausnr.-Zusatz", StrassenAdresseCType::getHNrZusatz, StrassenAdresseCType::setHNrZusatz).validate(Validator.maxLength2(20, "Die Zusatzangabe zur Hausnummer darf h\u00f6chstens 20 Zeichen lang sein")), Form.withText("Adresserg\u00e4nzung", StrassenAdresseCType::getAdressergaenzung, StrassenAdresseCType::setAdressergaenzung).validate(Validator.maxLength2(46, "Die Adresserg\u00e4nzung darf h\u00f6chstens 46 Zeichen lang sein")), Form.withText("Ort*", StrassenAdresseCType::getOrt, StrassenAdresseCType::setOrt).validate(Validator.maxLength2(72, "Die Angabe zum Ort darf h\u00f6chstens 72 Zeichen lang sein")).required("Der Ort muss angegeben werden"), Form.withText("Auslands-PLZ*", StrassenAdresseCType::getAuslandsPLZ, StrassenAdresseCType::setAuslandsPLZ).required("Die Auslandspostleitzahl muss angegeben werden"), Form.withChoice("Land*", Staat.values(), s -> new Staat(s.getStaatS()), (s, v) -> s.setStaatS(v.getKey())).required("F\u00fcr eine Auslandsadresse ist ein Land auszuw\u00e4hlen"));

        public AuslandsAdresse(ButtonBox parent, StrassenAdresseCType value) {
            super(parent, Type.AUSLANDSADRESSE);
            this.form.load(value);
            this.setContent(this.form.render());
        }

        public StrassenAdresseCType save() {
            return this.form.save();
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean validate() {
            return this.form.validate();
        }

        public boolean isEmpty() {
            return this.form.isEmpty();
        }
    }

    private static class PostfachAdresse
    extends ButtonBoxNode {
        private final Form<PostfachAdresseCType> form = Form.of("Postfachadresse*", PostfachAdresseCType::new, Form.withText("Postfach*", PostfachAdresseCType::getPostfach, PostfachAdresseCType::setPostfach).required("Das Postfach muss angegeben werden").validate(Validator.forPattern2("[0-9]{0,8}", "Die Postfachnummer muss aus h\u00f6chstens 8 Ziffern bestehen")), Form.withText("Postleitzahl*", PostfachAdresseCType::getPostfachPLZ, PostfachAdresseCType::setPostfachPLZ).required("Die Postleitzahl zum Postfach muss angegeben werden").validate(Validator.forPattern2("[0-9]{5}", "Die Postleitzahl muss aus genau 5 Ziffern bestehen")), Form.withText("Ort", PostfachAdresseCType::getPostfachOrt, PostfachAdresseCType::setPostfachOrt).validate(Validator.maxLength2(72, "Der Ort darf h\u00f6chstens 72 Zeichen lang sein")));

        public PostfachAdresse(ButtonBox parent, PostfachAdresseCType value) {
            super(parent, Type.POSTFACHADRESSE);
            this.form.load(value);
            this.setContent(this.form.render());
        }

        public PostfachAdresseCType save() {
            return this.form.save();
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean isEmpty() {
            return this.form.isEmpty();
        }

        public boolean validate() {
            return this.form.validate();
        }
    }

    private static class GKAdresse
    extends ButtonBoxNode {
        private final Form<GKAdresseCType> form = Form.of("Gro\u00dfkundenadresse*", GKAdresseCType::new, Form.withText("Postleitzahl*", GKAdresseCType::getGKPLZ, GKAdresseCType::setGKPLZ).required("Die Gro\u00dfkundenpostleitzahl muss angegeben werden").validate(Validator.forPattern2("[0-9]{5}", "Die Postleitzahl muss aus genau 5 Ziffern bestehen")), Form.withText("Ort*", GKAdresseCType::getGKOrt, GKAdresseCType::setGKOrt).required("Der Ort zur Gro\u00dfkundenpostleitzahl muss angegeben werden").validate(Validator.maxLength2(72, "Der Ort darf h\u00f6chstens 72 Zeichen lang sein")));

        public GKAdresse(ButtonBox parent, GKAdresseCType value) {
            super(parent, Type.GROSSKUNDENADRESSE);
            this.form.load(value);
            this.setContent(this.form.render());
        }

        public GKAdresseCType save() {
            return this.form.save();
        }

        @Override
        public boolean hasChanged() {
            return this.form.hasChanged();
        }

        public boolean isEmpty() {
            return this.form.isEmpty();
        }

        public boolean validate() {
            return this.form.validate();
        }
    }
}

