/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.eric;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface OttoWrapper
extends Library {
    public static final OttoWrapper INSTANCE = OttoWrapper.load();
    public static final int OTTOLOG_FEHLERMELDUNGEN = 4;
    public static final int OTTOLOG_WARNUNGEN = 3;
    public static final int OTTOLOG_INFORMATIONEN = 2;
    public static final int OTTOLOG_DEBUGMELDUNGEN = 1;

    private static OttoWrapper load() {
        try {
            System.setProperty("jna.encoding", "UTF-8");
            String ottoapi = OttoWrapper.extractLibrary("otto");
            System.load(ottoapi);
            return Native.load(ottoapi, OttoWrapper.class, Collections.singletonMap("string-encoding", "UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int OttoInstanzErzeugen(byte[] var1, OttoLogCallback var2, Pointer var3, PointerByReference var4);

    public int OttoInstanzFreigeben(Pointer var1);

    public int OttoZertifikatOeffnen(Pointer var1, Pointer var2, byte[] var3, PointerByReference var4);

    public int OttoZertifikatSchliessen(Pointer var1);

    public int OttoEmpfangBeginnen(Pointer var1, byte[] var2, Pointer var3, byte[] var4, PointerByReference var5);

    public int OttoRueckgabepufferErzeugen(Pointer var1, PointerByReference var2);

    public int OttoRueckgabepufferFreigeben(Pointer var1);

    public int OttoEmpfangFortsetzen(Pointer var1, Pointer var2);

    public long OttoRueckgabepufferGroesse(Pointer var1);

    public Pointer OttoRueckgabepufferInhalt(Pointer var1);

    public int OttoEmpfangBeenden(Pointer var1);

    public int OttoPruefsummeErzeugen(Pointer var1, PointerByReference var2);

    public int OttoPruefsummeAktualisieren(Pointer var1, byte[] var2, long var3);

    public int OttoPruefsummeSignieren(Pointer var1, Pointer var2, Pointer var3);

    public int OttoPruefsummeFreigeben(Pointer var1);

    public int OttoVersandBeginnen(Pointer var1, String var2, byte[] var3, PointerByReference var4);

    public int OttoVersandFortsetzen(Pointer var1, byte[] var2, long var3);

    public int OttoVersandAbschliessen(Pointer var1, Pointer var2);

    public int OttoVersandBeenden(Pointer var1);

    public int OttoProxyKonfigurationSetzen(Pointer var1, OttoProxyKonfiguration var2);

    private static String extractLibrary(String libname) throws IOException {
        Path extracted = Native.extractFromResourcePath(libname).toPath();
        if (extracted.getFileName().toString().startsWith("jna")) {
            Path original = extracted.getParent().resolve(OttoWrapper.getLibraryFilename(libname));
            Files.deleteIfExists(original);
            original.toFile().deleteOnExit();
            Files.copy(extracted, original, new CopyOption[0]);
            return original.toString();
        }
        return extracted.toString();
    }

    private static Path getLibraryFilename(String libname) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            return Paths.get(libname + ".dll", new String[0]);
        }
        if (os.contains("mac") || os.contains("darwin")) {
            return Paths.get("lib" + libname + ".dylib", new String[0]);
        }
        return Paths.get("lib" + libname + ".so", new String[0]);
    }

    public static interface OttoLogCallback
    extends Callback {
        public void invoke(String var1, String var2, int var3, String var4, IntByReference var5);
    }

    public static class OttoProxyKonfiguration
    extends Structure {
        public int version;
        public Pointer url;
        public Pointer benutzerName;
        public Pointer benutzerPasswort;
        public Pointer authentifizierungsMethode;

        protected List getFieldOrder() {
            return Arrays.asList("version", "url", "benutzerName", "benutzerPasswort", "authentifizierungsMethode");
        }
    }
}

