/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.eric;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import de.elster.flutopferhilfen.config.Configuration;
import de.elster.flutopferhilfen.eric.EricException;
import de.elster.flutopferhilfen.eric.OttoErrorcode;
import de.elster.flutopferhilfen.eric.OttoFehlertext;
import de.elster.flutopferhilfen.eric.OttoWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Otto
implements AutoCloseable {
    private final OttoWrapper wrapper = OttoWrapper.INSTANCE;
    private final Pointer instanz;
    private Pointer zertifikat;
    private final String herstellerId = "23400";
    private final int BufferSize = 0x500000;

    public Otto(Configuration configuration) throws EricException, IOException {
        Path logPath = Configuration.defaultConfiguration().getParent();
        String logFile = ".";
        if (Files.exists(logPath, new LinkOption[0])) {
            logFile = logPath.toString();
        }
        PointerByReference instanzRef = new PointerByReference();
        int rc = this.wrapper.OttoInstanzErzeugen(Otto.strToByteArray(logFile), null, null, instanzRef);
        if (rc != OttoErrorcode.OTTO_OK.getErrorcode()) {
            throw new EricException("Otto Instanz kann nicht erzeugt werden (" + OttoFehlertext.getErrorText(rc) + ")");
        }
        this.instanz = instanzRef.getValue();
        if (configuration.getProxyHost().isPresent() && configuration.getProxyPort().isPresent()) {
            OttoWrapper.OttoProxyKonfiguration proxy = new OttoWrapper.OttoProxyKonfiguration();
            proxy.version = 1;
            Object url = configuration.getProxyHost().get();
            if (configuration.getProxyPort().isPresent()) {
                url = (String)url + ":" + configuration.getProxyPort().get();
            }
            proxy.url = Otto.stringToPointer((String)url);
            proxy.benutzerName = configuration.getProxyUsername().isPresent() ? Otto.stringToPointer(configuration.getProxyUsername().get()) : Pointer.NULL;
            proxy.benutzerPasswort = configuration.getProxyPassword().isPresent() ? Otto.stringToPointer(configuration.getProxyPassword().get()) : Pointer.NULL;
            if (configuration.getProxyAuth().isPresent()) {
                proxy.authentifizierungsMethode = Otto.stringToPointer(configuration.getProxyAuth().get());
            } else {
                proxy.authentifizierungsMethode = Pointer.NULL;
                proxy.benutzerName = Pointer.NULL;
                proxy.benutzerPasswort = Pointer.NULL;
            }
            rc = this.wrapper.OttoProxyKonfigurationSetzen(this.instanz, proxy);
            if (rc != OttoErrorcode.OTTO_OK.getErrorcode()) {
                throw new EricException("Otto Proxy kann nicht konfiguriert werden. (" + OttoFehlertext.getErrorText(rc) + ")");
            }
        }
    }

    public int ladeZertifikat(Configuration configuration, String pin) throws EricException, IOException {
        PointerByReference zertifikatRef = new PointerByReference();
        URI zertifikatPfad = configuration.getClientCertificate().get();
        String inputPath = zertifikatPfad.getScheme().equals("file") ? Paths.get(zertifikatPfad).toString() : zertifikatPfad.toString();
        int rc = OttoErrorcode.OTTO_OK.getErrorcode();
        try {
            Pointer pathPointer = null;
            String defaultencoding = System.getProperty("native.encoding");
            pathPointer = defaultencoding == null ? Otto.byteArrayToPointer(inputPath.getBytes()) : Otto.byteArrayToPointer(inputPath.getBytes(defaultencoding));
            rc = this.wrapper.OttoZertifikatOeffnen(this.instanz, pathPointer, Otto.strToByteArray(pin), zertifikatRef);
            if (rc == OttoErrorcode.OTTO_OK.getErrorcode()) {
                this.zertifikat = zertifikatRef.getValue();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new EricException("Encoding Cp850 wird nicht unterst\u00fctzt.");
        }
        return rc;
    }

    public byte[] empfangeDaten(String ottoId) throws EricException, IOException {
        int rc = OttoErrorcode.OTTO_OK.getErrorcode();
        PointerByReference datenRef = new PointerByReference();
        rc = this.wrapper.OttoRueckgabepufferErzeugen(this.instanz, datenRef);
        if (rc != OttoErrorcode.OTTO_OK.getErrorcode()) {
            throw new EricException("Otto Empfang Buffer kann nicht erzeugt werden (" + OttoFehlertext.getErrorText(rc) + ")");
        }
        PointerByReference empfangRef = new PointerByReference();
        rc = this.wrapper.OttoEmpfangBeginnen(this.instanz, Otto.strToByteArray(ottoId), this.zertifikat, Otto.strToByteArray("23400"), empfangRef);
        if (rc != OttoErrorcode.OTTO_OK.getErrorcode()) {
            int rc1 = this.wrapper.OttoRueckgabepufferFreigeben(datenRef.getValue());
            throw new EricException("Otto Empfang kann nicht begonnen werden (" + OttoFehlertext.getErrorText(rc) + ")");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int geleseneByte = 0;
        int anzahlByte = 0;
        do {
            if ((rc = this.wrapper.OttoEmpfangFortsetzen(empfangRef.getValue(), datenRef.getValue())) != OttoErrorcode.OTTO_OK.getErrorcode()) continue;
            anzahlByte = (int)this.wrapper.OttoRueckgabepufferGroesse(datenRef.getValue());
            Pointer daten = this.wrapper.OttoRueckgabepufferInhalt(datenRef.getValue());
            if (geleseneByte + anzahlByte >= 0x500000) {
                throw new EricException("Buffer nicht ausreichend gro\u00df.");
            }
            outputStream.write(daten.getByteArray(0L, anzahlByte));
            geleseneByte += anzahlByte;
        } while (rc == OttoErrorcode.OTTO_OK.getErrorcode() && anzahlByte > 0);
        if (rc == OttoErrorcode.OTTO_OK.getErrorcode() || datenRef.getValue() != Pointer.NULL) {
            int n = this.wrapper.OttoRueckgabepufferFreigeben(datenRef.getValue());
        }
        if (rc == OttoErrorcode.OTTO_OK.getErrorcode() || empfangRef.getValue() != Pointer.NULL) {
            int n = this.wrapper.OttoEmpfangBeenden(empfangRef.getValue());
        }
        if (rc != OttoErrorcode.OTTO_OK.getErrorcode()) {
            throw new EricException("Fehler bei Abholen des Protokolls (" + OttoFehlertext.getErrorText(rc) + ")");
        }
        return outputStream.toByteArray();
    }

    @Override
    public void close() throws Exception {
        int rc = this.wrapper.OttoZertifikatSchliessen(this.zertifikat);
        rc = this.wrapper.OttoInstanzFreigeben(this.instanz);
    }

    public static byte[] strToByteArray(String s) throws IOException {
        int stringLaenge = 0;
        if (s != null && !s.isEmpty()) {
            stringLaenge = s.length();
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(stringLaenge);
        stream.write(s.getBytes());
        stream.write(0);
        return stream.toByteArray();
    }

    public static Pointer stringToPointer(String input) throws IOException {
        return Otto.byteArrayToPointer(Otto.strToByteArray(input));
    }

    public static Pointer byteArrayToPointer(byte[] input) {
        int length = input.length + 1;
        Memory ptr = new Memory(length);
        ptr.write(0L, input, 0, length - 1);
        ptr.setByte(length - 1, (byte)0);
        return ptr;
    }

    public static byte[] getReturnBufferContent(OttoWrapper ottoLib, Pointer ottoReturnBuffer) {
        long dataLength = ottoLib.OttoRueckgabepufferGroesse(ottoReturnBuffer);
        if (dataLength > Integer.MAX_VALUE) {
            throw new RuntimeException("Gr\u00f6\u00dfe des R\u00fcckgabepuffers gr\u00f6\u00dfer als 2147483647 Byte-");
        }
        Pointer dataPointer = ottoLib.OttoRueckgabepufferInhalt(ottoReturnBuffer);
        return dataPointer.getByteArray(0L, (int)dataLength);
    }

    public static String getReturnBufferContentAsString(OttoWrapper ottoLib, Pointer ottoReturnBuffer) {
        byte[] bufferContent = Otto.getReturnBufferContent(ottoLib, ottoReturnBuffer);
        return new String(bufferContent, StandardCharsets.UTF_8);
    }
}

