/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.eric;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;

public interface EricWrapper
extends Library {
    public static final EricWrapper INSTANCE = EricWrapper.load();
    public static final int ERIC_OK = 0;
    public static final int ERIC_GLOBAL_PRUEF_FEHLER = 610001002;
    public static final int ERIC_TRANSFER_ERR_XML_THEADER = 610101210;
    public static final int ERIC_TRANSFER_ERR_XML_NHEADER = 610101292;
    public static final int ERIC_CRYPT_E_PIN_WRONG = 610201106;
    public static final int ERIC_CRYPT_E_PIN_LOCKED = 610201107;
    public static final int ERIC_CRYPT_E_P12_SIG_KEY = 610201113;
    public static final int ERIC_CRYPT_E_P12_ENC_KEY = 610201114;
    public static final int ERIC_CRYPT_E_P11_SIG_KEY = 610201115;
    public static final int ERIC_CRYPT_E_P11_ENC_KEY = 610201116;
    public static final int ERIC_CRYPT_PIN_BENOETIGT = 610201205;
    public static final int ERIC_TRANSFER_ERR_PROXYCONNECT = 610101276;
    public static final int ERIC_TRANSFER_ERR_PROXYAUTH = 610101280;
    public static final int ERIC_TRANSFER_ERR_PROXYPORT_INVALID = 610101284;
    public static final int ERIC_TRANSFER_ERR_CONNECTSERVER = 610101278;
    public static final int ERIC_TRANSFER_ERR_TIMEOUT = 610101283;
    public static final int ERIC_VALIDIERE = 2;
    public static final int ERIC_SENDE = 4;

    public static boolean isTokenError(int returnCode) {
        return returnCode / 100 == 6102011;
    }

    private static EricWrapper load() {
        try {
            System.setProperty("jna.encoding", "UTF-8");
            System.load(EricWrapper.extractLibrary("ericxerces"));
            System.load(EricWrapper.extractLibrary("eSigner"));
            String ericapi = EricWrapper.extractLibrary("ericapi");
            System.load(ericapi);
            System.load(EricWrapper.extractLibrary("commonData"));
            System.load(EricWrapper.extractLibrary("checkElsterDatenabholung"));
            System.load(EricWrapper.extractLibrary("checkElsterKMV"));
            return Native.load(ericapi, EricWrapper.class, Collections.singletonMap("string-encoding", "UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Pointer EricMtInstanzErzeugen(String var1, String var2);

    public int EricMtInstanzFreigeben(Pointer var1);

    public Pointer EricMtRueckgabepufferErzeugen(Pointer var1);

    public int EricMtRueckgabepufferFreigeben(Pointer var1, Pointer var2);

    public Pointer EricMtRueckgabepufferInhalt(Pointer var1, Pointer var2);

    public int EricMtRueckgabepufferLaenge(Pointer var1, Pointer var2);

    public int EricMtVersion(Pointer var1, Pointer var2);

    public int EricMtGetHandleToCertificate(Pointer var1, IntByReference var2, IntByReference var3, String var4);

    public int EricMtCloseHandleToCertificate(Pointer var1, int var2);

    public int EricMtBearbeiteVorgang(Pointer var1, String var2, String var3, int var4, Pointer var5, EricVerschluesselungsParameter var6, IntByReference var7, Pointer var8, Pointer var9);

    public int EricMtEinstellungSetzen(Pointer var1, String var2, String var3);

    public int EricMtCheckXML(Pointer var1, String var2, String var3, Pointer var4);

    public int EricMtDekodiereDaten(Pointer var1, int var2, String var3, byte[] var4, Pointer var5);

    public int EricMtPruefeSteuernummer(Pointer var1, String var2);

    public int EricMtFormatStNr(Pointer var1, String var2, Pointer var3);

    public int EricMtMakeElsterStnr(Pointer var1, String var2, String var3, String var4, Pointer var5);

    public int EricMtPruefeIdentifikationsMerkmal(Pointer var1, String var2);

    public int EricMtPruefeBIC(Pointer var1, String var2);

    public int EricMtPruefeIBAN(Pointer var1, String var2);

    public int EricMtPruefeBuFaNummer(Pointer var1, String var2);

    public int EricMtHoleFehlertext(Pointer var1, int var2, Pointer var3);

    private static String extractLibrary(String libname) throws IOException {
        Path extracted = Native.extractFromResourcePath(libname).toPath();
        if (extracted.getFileName().toString().startsWith("jna")) {
            Path original = extracted.getParent().resolve(EricWrapper.getLibraryFilename(libname));
            Files.deleteIfExists(original);
            original.toFile().deleteOnExit();
            Files.copy(extracted, original, new CopyOption[0]);
            return original.toString();
        }
        return extracted.toString();
    }

    private static Path getLibraryFilename(String libname) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            return Paths.get(libname + ".dll", new String[0]);
        }
        if (os.contains("mac") || os.contains("darwin")) {
            return Paths.get("lib" + libname + ".dylib", new String[0]);
        }
        return Paths.get("lib" + libname + ".so", new String[0]);
    }

    @Structure.FieldOrder(value={"version", "zertifikatHandle", "pin"})
    public static class EricVerschluesselungsParameter
    extends Structure {
        public int version;
        public int zertifikatHandle;
        public String pin;

        EricVerschluesselungsParameter(int version, int zertifikatHandle, String pin) {
            this.version = version;
            this.zertifikatHandle = zertifikatHandle;
            this.pin = pin;
        }
    }
}

