/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.eric;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import de.elster.flutopferhilfen.eric.EricWrapper;
import de.elster.flutopferhilfen.eric.schemas.EricBearbeiteVorgang;
import de.elster.flutopferhilfen.eric.schemas.TransferTyp;
import de.elster.flutopferhilfen.eric.schemas.TransfersTyp;
import de.elster.flutopferhilfen.model.ElsterXml;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class Eric
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(Eric.class.getName());
    private final EricWrapper wrapper = EricWrapper.INSTANCE;
    private final Pointer instance;

    public Eric() {
        this(null);
    }

    public Eric(Path logpath) {
        this.instance = this.wrapper.EricMtInstanzErzeugen(null, logpath != null ? logpath.toString() : ".");
        if (this.instance == null) {
            throw new RuntimeException("Kann ERiC-Instanz nicht erzeugen");
        }
    }

    @Override
    public void close() {
        this.wrapper.EricMtInstanzFreigeben(this.instance);
    }

    public String version() {
        try (ReturnBuffer buffer = new ReturnBuffer();){
            int rc = this.wrapper.EricMtVersion(this.instance, buffer.getHandle());
            if (rc == 0) {
                String string = buffer.getContent();
                return string;
            }
            throw new RuntimeException("Kann ERiC-Versionen nicht bestimmen: " + rc);
        }
    }

    public Token getToken(URI path) throws TokenException {
        return new Token(path);
    }

    public void setProperty(String name, String value) {
        int rc = this.wrapper.EricMtEinstellungSetzen(this.instance, name, value);
        if (rc != 0) {
            throw new RuntimeException("Kann Einstellung " + name + " nicht auf den Wert " + value + " setzen: " + rc);
        }
    }

    public boolean pruefeSteuernummer(String stnr) {
        return this.wrapper.EricMtPruefeSteuernummer(this.instance, stnr) == 0;
    }

    public boolean pruefeSteuerID(String stnr) {
        return this.wrapper.EricMtPruefeIdentifikationsMerkmal(this.instance, stnr) == 0;
    }

    public boolean pruefeBIC(String bic) {
        return this.wrapper.EricMtPruefeBIC(this.instance, bic) == 0;
    }

    public boolean pruefeIBAN(String iban) {
        return this.wrapper.EricMtPruefeIBAN(this.instance, iban) == 0;
    }

    public boolean pruefeBuFaNummer(String nummer) {
        return this.wrapper.EricMtPruefeBuFaNummer(this.instance, nummer) == 0;
    }

    public Optional<String> formatiereSteuernummer(String elsterSteuernummer) {
        try (ReturnBuffer rueckgabeBuffer = new ReturnBuffer();){
            int rc = this.wrapper.EricMtFormatStNr(this.instance, elsterSteuernummer, rueckgabeBuffer.getHandle());
            if (rc == 0) {
                Optional<String> optional = Optional.of(rueckgabeBuffer.getContent());
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
    }

    public Optional<String> getElsterSteuernummer(String laendernummer, String bescheidSteuernummer) {
        try (ReturnBuffer rueckgabeBuffer = new ReturnBuffer();){
            int rc = this.wrapper.EricMtMakeElsterStnr(this.instance, bescheidSteuernummer, laendernummer, null, rueckgabeBuffer.getHandle());
            if (rc == 0) {
                Optional<String> optional = Optional.of(rueckgabeBuffer.getContent());
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
    }

    public Optional<String> holeFehlertext(int returncode) {
        try (ReturnBuffer fehlertextBuffer = new ReturnBuffer();){
            int rc = this.wrapper.EricMtHoleFehlertext(this.instance, returncode, fehlertextBuffer.getHandle());
            if (rc == 0) {
                Optional<String> optional = Optional.of(fehlertextBuffer.getContent());
                return optional;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
    }

    public CheckXmlResult checkXml(String xml, String datenartVersion) {
        try (ReturnBuffer fehlertextBuffer = new ReturnBuffer();){
            int rc = this.wrapper.EricMtCheckXML(this.instance, xml, datenartVersion, fehlertextBuffer.getHandle());
            CheckXmlResult checkXmlResult = new CheckXmlResult(rc, fehlertextBuffer.getContent());
            return checkXmlResult;
        }
    }

    public VorgangBuilder bearbeiteVorgang(String xml, String datenart) {
        return new VorgangBuilder(xml, datenart);
    }

    public class ReturnBuffer
    implements Closeable {
        private final Pointer buffer;

        public ReturnBuffer() {
            this.buffer = Eric.this.wrapper.EricMtRueckgabepufferErzeugen(Eric.this.instance);
            if (this.buffer == null) {
                throw new RuntimeException("Kann Rueckgabepuffer nicht erzeugen");
            }
        }

        @Override
        public void close() {
            Eric.this.wrapper.EricMtRueckgabepufferFreigeben(Eric.this.instance, this.buffer);
        }

        public byte[] getBytes() {
            Pointer pointer = Eric.this.wrapper.EricMtRueckgabepufferInhalt(Eric.this.instance, this.buffer);
            if (pointer == null || pointer.equals(Pointer.NULL)) {
                throw new RuntimeException("Kann Inhalt des Rueckgabepuffers nicht bestimmen");
            }
            int length = Eric.this.wrapper.EricMtRueckgabepufferLaenge(Eric.this.instance, this.buffer);
            return pointer.getByteArray(0L, length);
        }

        public String getContent() {
            return new String(this.getBytes(), StandardCharsets.UTF_8);
        }

        public int getLength() {
            return Eric.this.wrapper.EricMtRueckgabepufferLaenge(Eric.this.instance, this.buffer);
        }

        public Pointer getHandle() {
            return this.buffer;
        }
    }

    public class Token
    implements Closeable {
        private final int handle;
        private final boolean signaturePin;
        private final boolean decryptionPin;
        private final boolean encryptionPin;

        public Token(URI path) throws TokenException {
            IntByReference handle = new IntByReference();
            IntByReference info = new IntByReference();
            String inputPath = path.getScheme().equals("file") ? Paths.get(path).toString() : path.toString();
            int rc = Eric.this.wrapper.EricMtGetHandleToCertificate(Eric.this.instance, handle, info, inputPath);
            if (rc != 0) {
                throw new TokenException("Kann Zertifikat " + path + " nicht oeffnen: " + rc);
            }
            this.handle = handle.getValue();
            int pinInfoValue = info.getValue();
            this.signaturePin = (pinInfoValue & 1) != 0;
            this.decryptionPin = (pinInfoValue & 2) != 0;
            this.encryptionPin = (pinInfoValue & 4) != 0;
        }

        @Override
        public void close() {
            Eric.this.wrapper.EricMtCloseHandleToCertificate(Eric.this.instance, this.handle);
        }

        public int getHandle() {
            return this.handle;
        }

        public boolean needsSignaturePin() {
            return this.signaturePin;
        }

        public boolean needsDecryptionPin() {
            return this.decryptionPin;
        }

        public boolean needsEncryptionPin() {
            return this.encryptionPin;
        }
    }

    public static class CheckXmlResult {
        private final int rc;
        private final String errors;

        CheckXmlResult(int rc, String errors) {
            this.rc = rc;
            this.errors = errors;
        }

        public int getRc() {
            return this.rc;
        }

        public String getErrors() {
            return this.errors;
        }
    }

    public class VorgangBuilder {
        private final String xml;
        private final String datenartVersion;
        private Token token;
        private String pin;

        private VorgangBuilder(String xml, String datenartVersion) {
            this.xml = xml;
            this.datenartVersion = datenartVersion;
        }

        public VorgangBuilder useToken(Token token) {
            this.token = token;
            return this;
        }

        public VorgangBuilder withPin(String pin) {
            this.pin = pin;
            return this;
        }

        public VorgangResult validate() throws JAXBException {
            return this.bearbeite(2);
        }

        public VorgangResult send() throws JAXBException {
            return this.bearbeite(6);
        }

        private VorgangResult bearbeite(int bearbeitungsFlags) throws JAXBException {
            EricWrapper.EricVerschluesselungsParameter verschluesselungsParameter = null;
            if (this.token != null) {
                verschluesselungsParameter = new EricWrapper.EricVerschluesselungsParameter(3, this.token.getHandle(), this.pin);
            }
            IntByReference transferHandle = new IntByReference();
            try (ReturnBuffer returnBuffer = new ReturnBuffer();){
                ReturnBuffer serverResponse = new ReturnBuffer();
                try {
                    int rc = Eric.this.wrapper.EricMtBearbeiteVorgang(Eric.this.instance, this.xml, this.datenartVersion, bearbeitungsFlags, null, verschluesselungsParameter, transferHandle, returnBuffer.getHandle(), serverResponse.getHandle());
                    logger.fine("EricBearbeiteVorgang rc = " + rc);
                    logger.fine("\tdatenartVersion = " + this.datenartVersion);
                    logger.fine("\tbearbeitungsflags = " + bearbeitungsFlags);
                    logger.fine("\txml = " + this.xml);
                    logger.fine("\treturnBuffer = " + returnBuffer.getContent());
                    logger.fine("\tserverResponse = " + serverResponse.getContent());
                    VorgangResult vorgangResult = new VorgangResult(rc, transferHandle.getValue(), returnBuffer.getContent(), serverResponse.getContent());
                    serverResponse.close();
                    return vorgangResult;
                }
                catch (Throwable throwable) {
                    try {
                        serverResponse.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public static class DecodeResult {
        private final int rc;
        private final byte[] output;

        public DecodeResult(int rc, byte[] output) {
            this.rc = rc;
            this.output = output;
        }

        public DecodeResult(int rc) {
            this(rc, null);
        }

        public int getRc() {
            return this.rc;
        }

        public byte[] getOutput() {
            return this.output;
        }
    }

    public static class TokenException
    extends Exception {
        public TokenException(String message) {
            super(message);
        }
    }

    public static class VorgangResult {
        private final int rc;
        private final int transferHandle;
        private final EricBearbeiteVorgang returnBuffer;
        private final ElsterXml serverAnswer;

        public VorgangResult(int rc, int transferHandle, String returnBuffer, String serverAnswer) throws JAXBException {
            this.rc = rc;
            this.transferHandle = transferHandle;
            JAXBContext context = JAXBContext.newInstance(EricBearbeiteVorgang.class);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            this.returnBuffer = returnBuffer == null || returnBuffer.isEmpty() ? null : (EricBearbeiteVorgang)unmarshaller.unmarshal(new ByteArrayInputStream(returnBuffer.getBytes(StandardCharsets.UTF_8)));
            this.serverAnswer = serverAnswer == null || serverAnswer.isEmpty() ? null : new ElsterXml(new StringReader(serverAnswer));
        }

        public int getRc() {
            return this.rc;
        }

        public int getTransferHandle() {
            return this.transferHandle;
        }

        public EricBearbeiteVorgang getReturnBuffer() {
            return this.returnBuffer;
        }

        public ElsterXml getServerAnswer() {
            return this.serverAnswer;
        }

        public List<String> getTransferTickets() {
            if (this.returnBuffer != null) {
                ArrayList<String> result = new ArrayList<String>();
                for (JAXBElement<?> element : this.returnBuffer.getContent()) {
                    if (!"Transfers".equals(element.getName().getLocalPart())) continue;
                    TransfersTyp transfers = (TransfersTyp)element.getValue();
                    result.addAll(transfers.getTransfer().stream().map(TransferTyp::getTransferTicket).collect(Collectors.toList()));
                }
                return result;
            }
            return Collections.emptyList();
        }
    }
}

