/*
 * Decompiled with CFR 0.152.
 */
package de.elster.flutopferhilfen.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;

public class Configuration {
    public static final String DEFAULT_DATENLIEFERANT = "Bitte den Namen Ihrer Beh\u00f6rde hier eintragen";
    private static final VersionProperties versionProperties = new VersionProperties();
    private static final TestmerkerProperties testmerkerProperties = new TestmerkerProperties();
    public static final String NAME_CLIENT = versionProperties.getName();
    public static final String VERSION_CLIENT = versionProperties.getVersion();
    public static final String NAME_VERSION_CLIENT = NAME_CLIENT + " " + VERSION_CLIENT;
    private final Content content;

    public static Path defaultConfiguration() {
        String appdata = System.getenv("LOCALAPPDATA");
        if (appdata != null) {
            return Paths.get(appdata, "flutopferhilfen", "config.yaml");
        }
        return Paths.get(System.getProperty("user.home"), ".flutopferhilfen", "config.yaml");
    }

    public static Optional<Configuration> load(Path source) throws IOException {
        if (Files.exists(source, new LinkOption[0])) {
            ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return Optional.of(new Configuration(mapper.readValue(source.toFile(), Content.class)));
        }
        return Optional.empty();
    }

    private Configuration(Content content) {
        this.content = content;
        try {
            Files.createDirectories(this.content.cases, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Das Verzeichnis f\u00fcr die Flutopferhilfen-Mitteilungen " + this.content.cases + " konnte nicht angelegt werden", e);
        }
    }

    public Configuration() {
        Path defaultPath = Configuration.defaultConfiguration();
        this.content = new Content();
        this.content.cases = defaultPath.getParent().resolve("cases");
        if (!Files.exists(this.content.cases, new LinkOption[0])) {
            try {
                Files.createDirectories(this.content.cases, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Das Verzeichnis " + this.content.cases + " f\u00fcr die Flutopferhilfen-Mitteilungen kann nicht angelegt werden", e);
            }
        }
        this.content.datenlieferant = DEFAULT_DATENLIEFERANT;
        try {
            this.save(defaultPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Die Standardkonfiguration kann nicht unter " + defaultPath + " gespeichert werden", e);
        }
    }

    public void save(Path destination) throws IOException {
        if (!Files.exists(destination.getParent(), new LinkOption[0])) {
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        }
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        mapper.writeValue(destination.toFile(), (Object)this.content);
    }

    public Path getCases() {
        return this.content.cases;
    }

    public Optional<URI> getClientCertificate() {
        return Optional.ofNullable(this.content.clientCertificate);
    }

    public Optional<String> getTransferTestUrl() {
        return Optional.ofNullable(this.content.transferTestUrl);
    }

    public Optional<String> getTransferTestClientcert() {
        return Optional.ofNullable(this.content.transferTestClientcert);
    }

    public Optional<String> getTestTransferVerschluesselungszertifikat() {
        return Optional.ofNullable(this.content.testTransferVerschluesselungszertifikat);
    }

    public Optional<String> getTestmerkerVersand() {
        if (this.content.testmerkerVersand2 != null) {
            return Optional.of(this.content.testmerkerVersand2);
        }
        return Optional.ofNullable(testmerkerProperties.getTestmerkerVersand());
    }

    public Optional<String> getTestmerkerAbholung() {
        if (this.content.testmerkerAbholung2 != null) {
            return Optional.of(this.content.testmerkerAbholung2);
        }
        return Optional.ofNullable(testmerkerProperties.getTestmerkerAbholung());
    }

    public Optional<String> getZusatzInfo() {
        return Optional.ofNullable(this.content.zusatzInfo);
    }

    public Optional<String> getDatenlieferant() {
        return Optional.ofNullable(this.content.datenlieferant);
    }

    public String getVersionClient() {
        return NAME_VERSION_CLIENT;
    }

    public Boolean istLizenzAkzeptiert() {
        return this.content.lizenzAkzeptiert != null && this.content.lizenzAkzeptiert != false;
    }

    public void setZusatzInfo(String zusatzInfo) {
        this.content.zusatzInfo = zusatzInfo;
    }

    public void setTransferTestUrl(String transferTestUrl) {
        this.content.transferTestUrl = transferTestUrl;
    }

    public void setTransferTestClientcert(String transferTestClientcert) {
        this.content.transferTestClientcert = transferTestClientcert;
    }

    public void setTestTransferVerschluesselungszertifikat(String testTransferVerschluesselungszertifikat) {
        this.content.testTransferVerschluesselungszertifikat = testTransferVerschluesselungszertifikat;
    }

    public void setClientCertificate(URI clientCertificate) {
        this.content.clientCertificate = clientCertificate;
    }

    public void setTestmerkerVersand(String testmerker) {
        this.content.testmerkerVersand2 = testmerker;
    }

    public void setTestmerkerAbholung(String testmerker) {
        this.content.testmerkerAbholung2 = testmerker;
    }

    public void setDatenlieferant(String datenlieferant) {
        this.content.datenlieferant = datenlieferant;
    }

    public void setLinzenzAkzeptiert(Boolean akzeptiert) {
        this.content.lizenzAkzeptiert = akzeptiert;
    }

    public Optional<String> getProxyHost() {
        return Optional.ofNullable(this.content.proxyHost);
    }

    public void setProxyHost(String proxyHost) {
        this.content.proxyHost = proxyHost;
    }

    public Optional<String> getProxyPort() {
        return Optional.ofNullable(this.content.proxyPort);
    }

    public void setProxyPort(String proxyPort) {
        this.content.proxyPort = proxyPort;
    }

    public Optional<String> getProxyUsername() {
        return Optional.ofNullable(this.content.proxyUsername);
    }

    public void setProxyUsername(String proxyUsername) {
        this.content.proxyUsername = proxyUsername;
    }

    public Optional<String> getProxyPassword() {
        String proxyPassword = this.content.proxyPassword;
        if (proxyPassword != null && !proxyPassword.isEmpty()) {
            try {
                return Optional.of(new String(Encryption.crypt(Encryption.fromHex(proxyPassword), true), StandardCharsets.UTF_8));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public void setProxyPassword(String proxyPassword) throws IOException {
        this.content.proxyPassword = proxyPassword != null && !proxyPassword.isEmpty() ? Encryption.toHex(Encryption.crypt(proxyPassword.getBytes(StandardCharsets.UTF_8), false)) : null;
    }

    public Optional<String> getProxyAuth() {
        return Optional.ofNullable(this.content.proxyAuth);
    }

    public void setProxyAuth(String proxyAuth) {
        this.content.proxyAuth = proxyAuth;
    }

    private static class Content {
        public Path cases;
        public URI clientCertificate;
        public String datenlieferant;
        public String transferTestUrl;
        public String transferTestClientcert;
        public String testTransferVerschluesselungszertifikat;
        public String testmerkerVersand2;
        public String testmerkerAbholung2;
        public String zusatzInfo;
        public Boolean lizenzAkzeptiert;
        public String proxyHost;
        public String proxyPort;
        public String proxyUsername;
        public String proxyPassword;
        public String proxyAuth;

        private Content() {
        }
    }

    private static class TestmerkerProperties {
        private final String testmerkerVersand;
        private final String testmerkerAbholung;

        public TestmerkerProperties() {
            InputStream stream = Configuration.class.getResourceAsStream("testmerker.properties");
            Properties properties = new Properties();
            if (stream != null) {
                try {
                    properties.load(stream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.testmerkerVersand = properties.getProperty("testmerkerVersand");
            this.testmerkerAbholung = properties.getProperty("testmerkerAbholung");
        }

        public String getTestmerkerVersand() {
            return this.testmerkerVersand;
        }

        public String getTestmerkerAbholung() {
            return this.testmerkerAbholung;
        }
    }

    private static class Encryption {
        private static final byte[] KEY = Encryption.fromHex("AB5E2170C6FBD1F8E9D5C2A30A01395C33D4272C8FD6CD7AEB45D40E068C86A0");
        private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        private Encryption() {
        }

        public static byte[] crypt(byte[] content, boolean decrypt) throws IOException {
            ByteArrayOutputStream keyStream = new ByteArrayOutputStream();
            keyStream.write(KEY);
            while (keyStream.size() < content.length) {
                keyStream.write(KEY);
            }
            byte[] key = Arrays.copyOfRange(keyStream.toByteArray(), 0, content.length);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            for (int pos = 0; pos < content.length; ++pos) {
                if (decrypt) {
                    output.write((256 + (key[pos] ^ content[pos]) - key[pos]) % 256);
                    continue;
                }
                output.write(key[pos] ^ (content[pos] + key[pos]) % 256);
            }
            return output.toByteArray();
        }

        public static String toHex(byte[] values) {
            StringBuilder output = new StringBuilder();
            for (byte value : values) {
                int v = value & 0xFF;
                output.append(HEX_CHARS[v >>> 4]);
                output.append(HEX_CHARS[v & 0xF]);
            }
            return output.toString();
        }

        private static byte hexDigit(char c) {
            if ((c = Character.toLowerCase(c)) >= '0' && c <= '9') {
                return (byte)(c - 48);
            }
            return (byte)(c - 97 + 10);
        }

        public static byte[] fromHex(String values) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            boolean fullByte = false;
            byte next = 0;
            for (int pos = 0; pos < values.length(); ++pos) {
                char c = Character.toLowerCase(values.charAt(pos));
                if (!fullByte) {
                    next = (byte)(Encryption.hexDigit(c) << 4);
                    fullByte = true;
                    continue;
                }
                next = (byte)(next | Encryption.hexDigit(c));
                output.write(next);
                fullByte = false;
            }
            return output.toByteArray();
        }
    }

    private static class VersionProperties {
        private final String name;
        private final String version;

        public VersionProperties() {
            Properties properties = new Properties();
            try {
                properties.load(Configuration.class.getResourceAsStream("version.properties"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.name = properties.getProperty("name", "FlutopferhilfenMitteilung");
            this.version = properties.getProperty("version", "<unbekannt>");
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

